/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.management;

import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.List;
import javax.management.MXBean;

@MXBean
public interface ISessionMonitorMBean {
    public int getNumHttpSessions();

    public int getNumUiSessions();

    public int getNumClientSessions();

    public List<SessionDetail> getSessionDetails();

    public List<String> getSessionTable();

    public static class SessionDetail {
        private final String m_httpSessionId;
        private final String m_clientSessionId;
        private final String m_uiSessionId;
        private final String m_userId;
        private final String m_uiState;
        private final String m_clientState;
        private final long m_lastAccessed;

        @ConstructorProperties(value={"httpSessionId", "uiSessionId", "clientSessionId", "userId", "uiState", "clientState", "lastAccessed"})
        public SessionDetail(String httpSessionId, String uiSessionId, String clientSessionId, String userId, String uiState, String clientState, long lastAccessed) {
            this.m_httpSessionId = httpSessionId;
            this.m_uiSessionId = uiSessionId;
            this.m_clientSessionId = clientSessionId;
            this.m_userId = userId;
            this.m_uiState = uiState;
            this.m_clientState = clientState;
            this.m_lastAccessed = lastAccessed;
        }

        public String getHttpSessionId() {
            return this.m_httpSessionId;
        }

        public String getUiSessionId() {
            return this.m_uiSessionId;
        }

        public String getClientSessionId() {
            return this.m_clientSessionId;
        }

        public String getUserId() {
            return this.m_userId;
        }

        public String getUiState() {
            return this.m_uiState;
        }

        public String getClientState() {
            return this.m_clientState;
        }

        public Date getLastAccessed() {
            return new Date(this.m_lastAccessed);
        }

        public long getAgeInSeconds() {
            return (System.currentTimeMillis() - this.m_lastAccessed) / 1000L;
        }

        public static String toCsvHeader() {
            return "UiState | ClientState | Age[s] | LastAccessed | UserId | HttpSession | UiSession | ClientSession";
        }

        public String toCsvRow() {
            return this.m_uiState + " | " + this.m_clientState + " | " + this.getAgeInSeconds() + " | " + this.getLastAccessed() + " | " + this.m_userId + " | " + this.m_httpSessionId + " | " + this.m_uiSessionId + " | " + this.m_clientSessionId;
        }

        public String toString() {
            return this.toCsvRow();
        }
    }
}

