/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.res;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceHolder;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceUrlUtility;

public class BinaryResourceMediator {
    private final IJsonAdapter<?> m_jsonAdapter;
    private final Map<String, BinaryResource> m_binaryResources = new HashMap<String, BinaryResource>(0);

    public BinaryResourceMediator(IJsonAdapter<?> jsonAdapter) {
        this.m_jsonAdapter = jsonAdapter;
    }

    public void addBinaryResource(BinaryResource binaryResource) {
        this.m_binaryResources.put(BinaryResourceUrlUtility.getFilenameWithFingerprint(binaryResource), binaryResource);
    }

    public String createUrl(BinaryResource binaryResource) {
        return BinaryResourceUrlUtility.createDynamicAdapterResourceUrl(this.m_jsonAdapter, binaryResource);
    }

    public BinaryResourceHolder getBinaryResourceHolder(String filenameWithFingerprint) {
        BinaryResource binaryResource = this.m_binaryResources.get(filenameWithFingerprint);
        if (binaryResource != null) {
            return new BinaryResourceHolder(binaryResource);
        }
        return null;
    }
}

