/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.res;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.Platform;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.server.commons.servlet.UrlHints;
import org.eclipse.scout.rt.server.commons.servlet.cache.GlobalHttpResourceCache;
import org.eclipse.scout.rt.server.commons.servlet.cache.HttpCacheControl;
import org.eclipse.scout.rt.server.commons.servlet.cache.HttpCacheKey;
import org.eclipse.scout.rt.server.commons.servlet.cache.HttpCacheObject;
import org.eclipse.scout.rt.server.commons.servlet.cache.IHttpResourceCache;
import org.eclipse.scout.rt.ui.html.AbstractUiServletRequestHandler;
import org.eclipse.scout.rt.ui.html.res.loader.IResourceLoader;
import org.eclipse.scout.rt.ui.html.res.loader.ResourceLoaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Order(value=5900.0)
public class ResourceRequestHandler
extends AbstractUiServletRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceRequestHandler.class);
    public static final String INDEX_HTML = "/index.html";
    public static final String URL_PARAM_CLEAR_CACHE = "clearCache";
    private final List<ResourceLoaders> m_resourceLoaders = Collections.unmodifiableList(BEANS.all(ResourceLoaders.class));
    private final HttpCacheControl m_httpCacheControl = (HttpCacheControl)BEANS.get(HttpCacheControl.class);

    @Override
    public boolean handleGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfoEx = this.resolvePathInfoEx(req);
        IResourceLoader resourceLoader = this.createLoaderFor(req, pathInfoEx);
        if (resourceLoader == null) {
            return false;
        }
        this.clearCacheIfNecessary(req);
        HttpCacheObject cachedObject = this.resolveResourceFromCache(req, pathInfoEx, resourceLoader);
        boolean valid = resourceLoader.validateResource(pathInfoEx, cachedObject);
        if (!valid) {
            return false;
        }
        if (this.m_httpCacheControl.checkAndSetCacheHeaders(req, resp, cachedObject)) {
            return true;
        }
        this.writeResourceToResponse(req, resp, cachedObject);
        return true;
    }

    protected void writeResourceToResponse(HttpServletRequest req, HttpServletResponse resp, HttpCacheObject cachedObject) throws IOException {
        BinaryResource binaryResource = cachedObject.getResource();
        this.setHttpResponseHeaders(resp, binaryResource);
        cachedObject.applyHttpResponseInterceptors(req, resp);
        if (!"HEAD".equals(req.getMethod())) {
            resp.getOutputStream().write(binaryResource.getContent());
        }
    }

    protected void clearCacheIfNecessary(HttpServletRequest req) {
        if (Platform.get().inDevelopmentMode() && req.getParameter(URL_PARAM_CLEAR_CACHE) != null) {
            ((GlobalHttpResourceCache)BEANS.get(GlobalHttpResourceCache.class)).clear();
            LOG.info("Resource cache has been cleared, requested by URL parameter {}", (Object)URL_PARAM_CLEAR_CACHE);
        }
    }

    protected IResourceLoader createLoaderFor(HttpServletRequest req, String requestedExternalPath) {
        for (ResourceLoaders loaderFactory : this.m_resourceLoaders) {
            IResourceLoader loader = loaderFactory.create(req, requestedExternalPath);
            if (loader == null) continue;
            return loader;
        }
        return null;
    }

    protected HttpCacheObject resolveResourceFromCache(HttpServletRequest req, String pathInfoEx, IResourceLoader resourceLoader) throws IOException {
        String cacheResultMsg;
        HttpCacheKey cacheKey = resourceLoader.createCacheKey(pathInfoEx);
        HttpCacheObject resource = null;
        if (!UrlHints.isCacheHint((HttpServletRequest)req)) {
            LOG.debug("Requested resource with cacheKey={}. Caching is disabled by URL hint", (Object)cacheKey);
            return resourceLoader.loadResource(cacheKey);
        }
        IHttpResourceCache resourceCache = resourceLoader.getCache(cacheKey);
        if (resourceCache == null) {
            LOG.debug("Loader for resource with cacheKey={} does not support caching.", (Object)cacheKey);
            return resourceLoader.loadResource(cacheKey);
        }
        resource = resourceCache.get(cacheKey);
        if (resource == null) {
            resource = resourceLoader.loadResource(cacheKey);
            if (resource == null) {
                cacheResultMsg = "Resource is not cached (cache miss), could not load resource (not added to the cache)";
            } else {
                resourceCache.put(resource);
                cacheResultMsg = "Resource is not cached (cache miss), resource loaded and added to the cache";
            }
        } else {
            cacheResultMsg = "Resource found in cache (cache hit), using cached resource";
        }
        LOG.debug("Requested resource with cacheKey={}. {}", (Object)cacheKey, (Object)cacheResultMsg);
        return resource;
    }

    protected void setHttpResponseHeaders(HttpServletResponse resp, BinaryResource resource) {
        String contentType;
        resp.setContentLength(resource.getContentLength());
        String charset = resource.getCharset();
        if (charset != null) {
            resp.setCharacterEncoding(charset);
        }
        if ((contentType = resource.getContentType()) != null) {
            resp.setContentType(contentType);
        } else {
            LOG.warn("Could not determine content-type of resource: {}", (Object)resource);
        }
    }

    protected List<ResourceLoaders> resourceLoaders() {
        return this.m_resourceLoaders;
    }

    protected String resolvePathInfoEx(HttpServletRequest req) {
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            return null;
        }
        if ("/".equals(pathInfo)) {
            pathInfo = INDEX_HTML;
        }
        return pathInfo;
    }
}

