/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.res.loader;

import java.io.IOException;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.server.commons.servlet.cache.GlobalHttpResourceCache;
import org.eclipse.scout.rt.server.commons.servlet.cache.HttpCacheKey;
import org.eclipse.scout.rt.server.commons.servlet.cache.HttpCacheObject;
import org.eclipse.scout.rt.server.commons.servlet.cache.IHttpResourceCache;
import org.eclipse.scout.rt.ui.html.res.loader.IResourceLoader;

public abstract class AbstractResourceLoader
implements IResourceLoader {
    private final IHttpResourceCache m_cache;

    protected AbstractResourceLoader() {
        this((IHttpResourceCache)BEANS.get(GlobalHttpResourceCache.class));
    }

    protected AbstractResourceLoader(IHttpResourceCache cache) {
        this.m_cache = cache;
    }

    @Override
    public boolean validateResource(String requestedExternalPath, HttpCacheObject cachedObject) {
        return cachedObject != null && cachedObject.getResource() != null && cachedObject.getResource().getContent() != null;
    }

    @Override
    public HttpCacheObject loadResource(HttpCacheKey cacheKey) throws IOException {
        String pathInfo = cacheKey.getResourcePath();
        BinaryResource content = this.loadResource(pathInfo);
        if (content == null) {
            return null;
        }
        return new HttpCacheObject(cacheKey, content);
    }

    @Override
    public HttpCacheKey createCacheKey(String resourcePath) {
        return new HttpCacheKey(resourcePath);
    }

    @Override
    public IHttpResourceCache getCache(HttpCacheKey cacheKey) {
        return this.m_cache;
    }
}

