/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.res.loader;

import java.net.URI;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.resource.BinaryRefs;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.util.collection.TTLCache;
import org.eclipse.scout.rt.server.commons.servlet.cache.HttpCacheKey;
import org.eclipse.scout.rt.server.commons.servlet.cache.HttpCacheObject;
import org.eclipse.scout.rt.server.commons.servlet.cache.IHttpResourceCache;
import org.eclipse.scout.rt.ui.html.HttpSessionHelper;
import org.eclipse.scout.rt.ui.html.res.loader.AbstractResourceLoader;
import org.eclipse.scout.rt.ui.html.res.loader.BinaryRefResourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryRefResourceLoader
extends AbstractResourceLoader {
    private static final Logger LOG = LoggerFactory.getLogger(BinaryRefResourceLoader.class);
    private static final String BINARY_REF_CACHE = "binaryRef.cache";
    private final HttpServletRequest m_req;

    public BinaryRefResourceLoader(HttpServletRequest req) {
        super(null);
        this.m_req = req;
    }

    public HttpServletRequest getRequest() {
        return this.m_req;
    }

    @Override
    public IHttpResourceCache getCache(HttpCacheKey cacheKey) {
        HttpSession httpSession = this.getRequest().getSession();
        if (httpSession == null) {
            return null;
        }
        Object o = httpSession.getAttribute(BINARY_REF_CACHE);
        if (o instanceof IHttpResourceCache) {
            return (IHttpResourceCache)o;
        }
        IHttpResourceCache cache = this.createCache();
        httpSession.setAttribute(BINARY_REF_CACHE, (Object)cache);
        return cache;
    }

    protected IHttpResourceCache createCache() {
        return new IHttpResourceCache(){
            private final TTLCache<HttpCacheKey, HttpCacheObject> m_cache = new TTLCache(300000L);

            public boolean put(HttpCacheObject obj) {
                if (obj == null) {
                    return false;
                }
                if (obj.getResource() != null && obj.getResource().isCachingAllowed()) {
                    return false;
                }
                this.m_cache.put((Object)obj.getCacheKey(), (Object)obj);
                return true;
            }

            public HttpCacheObject get(HttpCacheKey cacheKey) {
                return (HttpCacheObject)this.m_cache.get((Object)cacheKey);
            }

            public HttpCacheObject remove(HttpCacheKey cacheKey) {
                return (HttpCacheObject)this.m_cache.remove((Object)cacheKey);
            }

            public void clear() {
                this.m_cache.clear();
            }
        };
    }

    @Override
    public BinaryResource loadResource(String pathInfo) {
        HttpSession httpSession = this.getRequest().getSession();
        if (httpSession == null) {
            return null;
        }
        BinaryRefResourceInfo info = this.createBinaryRefResourceInfo(pathInfo);
        if (info == null) {
            return null;
        }
        URI uri = info.toBinaryRefUri();
        IClientSession clientSession = ((HttpSessionHelper)BEANS.get(HttpSessionHelper.class)).getSessionStore(httpSession).getClientSessionMap().entrySet().stream().findAny().map(Map.Entry::getValue).orElse(null);
        if (clientSession == null) {
            return null;
        }
        try {
            return (BinaryResource)ClientRunContexts.copyCurrent().withSession(clientSession, true).call(() -> BinaryRefs.loadBinaryResource((URI)uri));
        }
        catch (Exception e) {
            LOG.warn("Unable to load binary resource for URI {}", (Object)uri, (Object)e);
            return null;
        }
    }

    protected BinaryRefResourceInfo createBinaryRefResourceInfo(HttpCacheKey cacheKey) {
        return this.createBinaryRefResourceInfo(cacheKey.getResourcePath());
    }

    protected BinaryRefResourceInfo createBinaryRefResourceInfo(String pathInfo) {
        return BinaryRefResourceInfo.fromPath(pathInfo);
    }
}

