/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.res.loader;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.resource.BinaryResources;
import org.eclipse.scout.rt.platform.resource.MimeType;
import org.eclipse.scout.rt.platform.util.IOUtility;
import org.eclipse.scout.rt.ui.html.ResourceBase;
import org.eclipse.scout.rt.ui.html.res.loader.AbstractResourceLoader;

public class LegacyBrowserScriptLoader
extends AbstractResourceLoader {
    public static final String LEGACY_BROWSERS_SCRIPT = "legacy-browsers.js";

    @Override
    public BinaryResource loadResource(String pathInfo) throws IOException {
        URL url = ResourceBase.class.getResource(LEGACY_BROWSERS_SCRIPT);
        URLConnection connection = url.openConnection();
        return BinaryResources.create().withFilename(pathInfo).withContent(IOUtility.readFromUrl((URL)url)).withContentType(MimeType.JS.getType()).withCharset(StandardCharsets.UTF_8).withLastModified(connection.getLastModified()).withCachingAllowed(true).withCacheMaxAge(14400).build();
    }
}

