/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.res.loader;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.resource.BinaryResources;
import org.eclipse.scout.rt.platform.util.FileUtility;
import org.eclipse.scout.rt.ui.html.UiHtmlConfigProperties;
import org.eclipse.scout.rt.ui.html.json.JsonLocale;
import org.eclipse.scout.rt.ui.html.res.loader.AbstractResourceLoader;
import org.json.JSONArray;
import org.json.JSONObject;

public class LocalesLoader
extends AbstractResourceLoader {
    @Override
    public BinaryResource loadResource(String pathInfo) {
        List<String> languageTags = LocalesLoader.getLanguageTags();
        JSONArray jsonLocales = new JSONArray();
        for (String tag : languageTags) {
            jsonLocales.put((Object)this.jsonLocale(tag));
        }
        byte[] localeBytes = jsonLocales.toString(2).getBytes(StandardCharsets.UTF_8);
        return BinaryResources.create().withFilename(pathInfo).withCharset(StandardCharsets.UTF_8).withContentType(FileUtility.getContentTypeForExtension((String)"json")).withContent(localeBytes).withCachingAllowed(true).build();
    }

    public static List<String> getLanguageTags() {
        List<String> languageTags = (List<String>)CONFIG.getPropertyValue(UiHtmlConfigProperties.UiLocalesProperty.class);
        if (languageTags.size() == 1 && "all".equals(languageTags.get(0))) {
            languageTags = LocalesLoader.getAvailableLanguageTags();
        }
        return languageTags;
    }

    protected JSONObject jsonLocale(String languageTag) {
        Locale locale = Locale.forLanguageTag(languageTag);
        return JsonLocale.toJson(locale);
    }

    public static List<String> getAvailableLanguageTags() {
        return Arrays.stream(Locale.getAvailableLocales()).map(Locale::toLanguageTag).collect(Collectors.toList());
    }
}

