/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.res.loader;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Platform;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.ui.html.IUiTextContributor;
import org.eclipse.scout.rt.ui.html.res.loader.IResourceLoader;
import org.eclipse.scout.rt.ui.html.res.loader.LocalesLoader;
import org.eclipse.scout.rt.ui.html.res.loader.TextsLoader;
import org.eclipse.scout.rt.ui.html.res.loader.UiTextContributionFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceBuilder.class);
    private Path m_outputDir;
    private List<IUiTextContributor> m_contributors;

    public ResourceBuilder(Path outputDir, List<IUiTextContributor> contributors) {
        this.m_outputDir = outputDir;
        this.m_contributors = contributors;
    }

    public static void main(String[] args) {
        Platform.get().awaitPlatformStarted();
        try {
            Path outputDir = ResourceBuilder.build(args);
            LOG.info("All files built and written to {}", (Object)outputDir);
        }
        finally {
            Platform.get().stop();
        }
    }

    protected static Path build(String[] args) {
        Path outputDir = null;
        List<IUiTextContributor> contributors = null;
        LinkedList<String> files = new LinkedList<String>();
        int i = 0;
        while (i < args.length) {
            switch (args[i]) {
                case "-outputDir": {
                    outputDir = Paths.get(args[++i], new String[0]);
                    break;
                }
                case "-contributors": {
                    contributors = ResourceBuilder.parseContributors(args[++i]);
                    break;
                }
                default: {
                    files.add(args[i]);
                }
            }
            ++i;
        }
        new ResourceBuilder(outputDir, contributors).build(files);
        return outputDir;
    }

    protected static List<IUiTextContributor> parseContributors(String contributors) {
        if ("all".equals(contributors)) {
            return BEANS.all(IUiTextContributor.class);
        }
        return Arrays.stream(contributors.split(",")).map(contributor -> {
            try {
                return (IUiTextContributor)BEANS.get(Class.forName(contributor));
            }
            catch (ClassNotFoundException e) {
                throw new ProcessingException("Invalid contributor", new Object[]{e});
            }
        }).collect(Collectors.toList());
    }

    public void build(List<String> files) {
        if (CollectionUtility.isEmpty(files)) {
            throw new IllegalArgumentException("No files specified");
        }
        for (String file : files) {
            LOG.info("Building resource '{}'", (Object)file);
            try {
                BinaryResource resource = this.loadResource(file);
                this.writeResource(resource);
            }
            catch (IOException e) {
                throw new Error("Failed to load file " + file, e);
            }
        }
    }

    public IResourceLoader getLoader(String file) {
        if (file.matches("^locales.json$")) {
            return new LocalesLoader();
        }
        if (file.matches("^texts.json$")) {
            TextsLoader textsLoader = new TextsLoader();
            if (this.m_contributors != null) {
                LOG.info("Using contributors {}", this.m_contributors);
                textsLoader.setEntryFilter(new UiTextContributionFilter(this.m_contributors));
            }
            return textsLoader;
        }
        return null;
    }

    public BinaryResource loadResource(String file) throws IOException {
        IResourceLoader loader = this.getLoader(file);
        if (loader == null) {
            throw new IOException("No loader found for " + file);
        }
        return loader.loadResource(file);
    }

    public void writeResource(BinaryResource resource) throws IOException {
        Path path = this.m_outputDir.resolve(resource.getFilename());
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Files.write(path, resource.getContent(), new OpenOption[0]);
        LOG.info("File written to {} ", (Object)path);
    }
}

