/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.res.loader;

import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.server.commons.servlet.UrlHints;
import org.eclipse.scout.rt.ui.html.UiThemeHelper;
import org.eclipse.scout.rt.ui.html.res.loader.BinaryRefResourceLoader;
import org.eclipse.scout.rt.ui.html.res.loader.DefaultValuesLoader;
import org.eclipse.scout.rt.ui.html.res.loader.DynamicResourceLoader;
import org.eclipse.scout.rt.ui.html.res.loader.HtmlFileLoader;
import org.eclipse.scout.rt.ui.html.res.loader.IResourceLoader;
import org.eclipse.scout.rt.ui.html.res.loader.IconLoader;
import org.eclipse.scout.rt.ui.html.res.loader.LegacyBrowserScriptLoader;
import org.eclipse.scout.rt.ui.html.res.loader.LocalesLoader;
import org.eclipse.scout.rt.ui.html.res.loader.TextsLoader;
import org.eclipse.scout.rt.ui.html.res.loader.WebResourceLoader;

@ApplicationScoped
public class ResourceLoaders {
    protected static final Pattern ICON_PATTERN = Pattern.compile("^/icon/(.*)");
    protected static final Pattern BINARY_REF_PATTERN = Pattern.compile("^/binref/(.*)");
    protected static final Pattern DYNAMIC_RESOURCES_PATTERN = Pattern.compile("^/dynamic/.*");
    protected static final Pattern DEFAULT_VALUES_PATTERN = Pattern.compile("^/defaultValues$");

    public IResourceLoader create(HttpServletRequest req, String resourcePath) {
        if (resourcePath == null) {
            return null;
        }
        if (ICON_PATTERN.matcher(resourcePath).matches()) {
            return new IconLoader();
        }
        if (BINARY_REF_PATTERN.matcher(resourcePath).matches()) {
            return new BinaryRefResourceLoader(req);
        }
        if (DYNAMIC_RESOURCES_PATTERN.matcher(resourcePath).matches()) {
            return new DynamicResourceLoader(req);
        }
        if (DEFAULT_VALUES_PATTERN.matcher(resourcePath).matches()) {
            return new DefaultValuesLoader();
        }
        if (resourcePath.endsWith("/locales.json")) {
            return new LocalesLoader();
        }
        if (resourcePath.endsWith("/texts.json")) {
            return new TextsLoader();
        }
        if (resourcePath.endsWith("/legacy-browsers.js")) {
            return new LegacyBrowserScriptLoader();
        }
        UiThemeHelper uiThemeHelper = UiThemeHelper.get();
        String theme = uiThemeHelper.getTheme(req);
        boolean minify = UrlHints.isMinifyHint((HttpServletRequest)req);
        boolean cacheEnabled = UrlHints.isCacheHint((HttpServletRequest)req);
        if (resourcePath.endsWith(".html")) {
            return new HtmlFileLoader(theme, minify, cacheEnabled);
        }
        WebResourceLoader loader = new WebResourceLoader(minify, cacheEnabled, uiThemeHelper.isDefaultTheme(theme) ? null : theme);
        if (loader.acceptFile(resourcePath)) {
            return loader;
        }
        return null;
    }
}

