/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.res.loader;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.nls.NlsResourceBundle;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.resource.BinaryResources;
import org.eclipse.scout.rt.platform.text.AbstractDynamicNlsTextProviderService;
import org.eclipse.scout.rt.platform.util.FileUtility;
import org.eclipse.scout.rt.ui.html.res.loader.AbstractResourceLoader;
import org.eclipse.scout.rt.ui.html.res.loader.LocalesLoader;
import org.json.JSONObject;

public class TextsLoader
extends AbstractResourceLoader {
    private Predicate<Map.Entry<String, String>> m_entryFilter;

    public void setEntryFilter(Predicate<Map.Entry<String, String>> entryFilter) {
        this.m_entryFilter = entryFilter;
    }

    public Predicate<Map.Entry<String, String>> getEntryFilter() {
        return this.m_entryFilter;
    }

    @Override
    public BinaryResource loadResource(String pathInfo) {
        List<Locale> languageLocales = this.getLanguageLocales();
        JSONObject jsonTexts = new JSONObject();
        LinkedHashMap<Locale, Map> textsByLanguageTag = new LinkedHashMap<Locale, Map>();
        for (AbstractDynamicNlsTextProviderService abstractDynamicNlsTextProviderService : BEANS.all(AbstractDynamicNlsTextProviderService.class)) {
            for (Locale locale : languageLocales) {
                NlsResourceBundle bundle = this.getResourceBundle(abstractDynamicNlsTextProviderService, locale);
                if (bundle == null) continue;
                Map map = textsByLanguageTag.computeIfAbsent(locale, k -> new TreeMap());
                for (Map.Entry<String, String> entry : bundle.getTextMap().entrySet()) {
                    if (!this.acceptEntry(entry)) continue;
                    map.putIfAbsent(entry.getKey(), entry.getValue());
                }
            }
        }
        for (Map.Entry entry : textsByLanguageTag.entrySet()) {
            Locale locale;
            locale = (Locale)entry.getKey();
            String languageTag = locale == null || locale == Locale.ROOT ? "default" : locale.toLanguageTag();
            JSONObject jsonTextMap = this.textsToJson(languageTag, (Map)entry.getValue());
            if (jsonTextMap.length() <= 0) continue;
            jsonTexts.put(languageTag, (Object)jsonTextMap);
        }
        byte[] byArray = jsonTexts.toString(2).getBytes(StandardCharsets.UTF_8);
        return BinaryResources.create().withFilename(pathInfo).withCharset(StandardCharsets.UTF_8).withContentType(FileUtility.getContentTypeForExtension((String)"json")).withContent(byArray).withCachingAllowed(true).build();
    }

    protected boolean acceptEntry(Map.Entry<String, String> entry) {
        if (this.m_entryFilter == null) {
            return true;
        }
        return this.m_entryFilter.test(entry);
    }

    protected JSONObject textsToJson(String languageTag, Map<String, String> textMap) {
        JSONObject texts = new JSONObject();
        for (Map.Entry<String, String> entry : textMap.entrySet()) {
            texts.put(entry.getKey(), (Object)entry.getValue());
        }
        return texts;
    }

    protected List<Locale> getLanguageLocales() {
        return this.processLanguageTags(LocalesLoader.getLanguageTags());
    }

    protected List<Locale> processLanguageTags(List<String> languageTags) {
        LinkedHashMap<String, LinkedHashSet<Locale>> languages = new LinkedHashMap<String, LinkedHashSet<Locale>>();
        for (String tag : languageTags) {
            Locale locale = Locale.forLanguageTag(tag);
            LinkedHashSet<Locale> localesForLanguage = (LinkedHashSet<Locale>)languages.get(locale.getLanguage());
            if (localesForLanguage == null) {
                localesForLanguage = new LinkedHashSet<Locale>();
                languages.put(locale.getLanguage(), localesForLanguage);
                localesForLanguage.add(new Locale(locale.getLanguage()));
            }
            localesForLanguage.add(locale);
        }
        List<Locale> locales = languages.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        locales.add(0, Locale.ROOT);
        return locales;
    }

    protected NlsResourceBundle getResourceBundle(AbstractDynamicNlsTextProviderService textService, Locale locale) {
        return NlsResourceBundle.getBundle(null, (String)textService.getDynamicNlsBaseName(), (Locale)locale, (ClassLoader)textService.getClass().getClassLoader());
    }
}

