/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.res.loader;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.eclipse.scout.rt.platform.Platform;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.resource.BinaryResources;
import org.eclipse.scout.rt.platform.util.IOUtility;
import org.eclipse.scout.rt.platform.util.ImmutablePair;
import org.eclipse.scout.rt.shared.ui.webresource.WebResourceDescriptor;
import org.eclipse.scout.rt.shared.ui.webresource.WebResources;
import org.eclipse.scout.rt.ui.html.res.loader.AbstractResourceLoader;

public class WebResourceLoader
extends AbstractResourceLoader {
    private final boolean m_minify;
    private final boolean m_cacheEnabled;
    private final String m_theme;

    public WebResourceLoader(boolean minify, boolean cacheEnabled, String theme) {
        this.m_minify = minify;
        this.m_cacheEnabled = cacheEnabled;
        this.m_theme = theme;
    }

    @Override
    public BinaryResource loadResource(String pathInfo) {
        return this.lookupResource(pathInfo).map(pair -> this.toBinaryResource((WebResourceDescriptor)pair.getLeft(), pathInfo, (Integer)pair.getRight())).orElse(null);
    }

    public boolean acceptFile(String file) {
        return this.lookupResource(file).isPresent();
    }

    public Optional<WebResourceDescriptor> resolveResource(String pathInfo) {
        return this.lookupResource(pathInfo).map(ImmutablePair::getLeft);
    }

    protected Optional<ImmutablePair<WebResourceDescriptor, Integer>> lookupResource(String file) {
        return WebResources.resolveScriptResource((String)file, (boolean)this.m_minify, (boolean)this.m_cacheEnabled, (String)this.m_theme).map(descriptor -> new ImmutablePair(descriptor, (Object)31536000)).or(() -> WebResources.resolveWebResource((String)file, (boolean)this.m_minify, (boolean)this.m_cacheEnabled).map(descriptor -> new ImmutablePair(descriptor, (Object)14400)));
    }

    protected BinaryResource toBinaryResource(WebResourceDescriptor descriptor, String pathInfo, int maxAge) {
        URL url = descriptor.getUrl();
        try {
            byte[] bytes = this.getContent(descriptor);
            BinaryResources resources = BinaryResources.create().withContent(bytes).withCharset(StandardCharsets.UTF_8).withCachingAllowed(this.m_cacheEnabled).withFilename(pathInfo).withCacheMaxAge(maxAge);
            if (!Platform.get().inDevelopmentMode()) {
                resources.withLastModified(url.openConnection().getLastModified());
            }
            return resources.build();
        }
        catch (IOException e) {
            throw new PlatformException("Unable to read from url '{}'.", new Object[]{url, e});
        }
    }

    protected byte[] getContent(WebResourceDescriptor descriptor) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedInputStream in = new BufferedInputStream(descriptor.getUrl().openConnection().getInputStream());){
            return IOUtility.readBytes((InputStream)in, (int)-1);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

