/*
 * Copyright (c) 2014-2017 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 */
package org.eclipse.scout.rt.ui.html.json.form.fields.tablefield;

import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.ITableField;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterProperty;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonFormField;

public class JsonTableField<TABLE_FIELD extends ITableField<? extends ITable>> extends JsonFormField<TABLE_FIELD> {

  public JsonTableField(TABLE_FIELD model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
    super(model, uiSession, id, parent);
  }

  @Override
  public String getObjectType() {
    return "TableField";
  }

  @Override
  protected void initJsonProperties(TABLE_FIELD model) {
    super.initJsonProperties(model);
    putJsonProperty(new JsonAdapterProperty<TABLE_FIELD>(ITableField.PROP_TABLE, model, getUiSession()) {
      @Override
      protected ITable modelValue() {
        return getModel().getTable();
      }
    });
  }
}
