/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.extras;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.eclipse.sisu.equinox.launching.internal.P2ApplicationLauncher;

@Mojo(name="publish-features-and-bundles")
public class PublishFeaturesAndBundlesMojo
extends AbstractMojo {
    private static String CONTENT_PUBLISHER_APP_NAME = "org.eclipse.equinox.p2.publisher.FeaturesAndBundlesPublisher";
    @Parameter(defaultValue="${project.build.directory}/repository")
    private String metadataRepositoryLocation;
    @Parameter(defaultValue="${project.build.directory}/repository")
    private String artifactRepositoryLocation;
    @Parameter(defaultValue="${project.build.directory}/source")
    private String sourceLocation;
    @Parameter(defaultValue="true")
    private boolean compress;
    @Parameter(defaultValue="false")
    private boolean append;
    @Parameter(defaultValue="true")
    private boolean publishArtifacts;
    @Parameter(defaultValue="false")
    private boolean reusePack200Files;
    @Parameter(defaultValue="")
    private String additionalArgs;
    @Parameter(property="p2.timeout", defaultValue="0")
    private int forkedProcessTimeoutInSeconds;
    @Parameter(property="project")
    private MavenProject project;
    @Component
    private P2ApplicationLauncher launcher;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.publishContent();
    }

    private void publishContent() throws MojoExecutionException, MojoFailureException {
        try {
            File sourceRepositoryDir = new File(this.sourceLocation).getCanonicalFile();
            File artifactRepositoryDir = new File(this.artifactRepositoryLocation).getCanonicalFile();
            File metadataRepositoryDir = new File(this.metadataRepositoryLocation).getCanonicalFile();
            ArrayList<String> contentArgs = new ArrayList<String>();
            contentArgs.add("-source");
            contentArgs.add(sourceRepositoryDir.toString());
            this.launcher.setWorkingDirectory(this.project.getBasedir());
            this.launcher.setApplicationName(CONTENT_PUBLISHER_APP_NAME);
            this.launcher.addArguments(new String[]{"-artifactRepository", artifactRepositoryDir.toURL().toString(), "-metadataRepository", metadataRepositoryDir.toURL().toString()});
            this.launcher.addArguments(this.getPublishArtifactFlag());
            this.launcher.addArguments(this.getAppendFlag());
            this.launcher.addArguments(this.getCompressFlag());
            this.launcher.addArguments(this.getReusePack200FilesFlag());
            this.launcher.addArguments(this.getAdditionalArgs());
            this.launcher.addArguments(contentArgs.toArray(new String[contentArgs.size()]));
            int result = this.launcher.execute(this.forkedProcessTimeoutInSeconds);
            if (result != 0) {
                throw new MojoFailureException("P2 publisher return code was " + result);
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to execute the publisher", (Exception)ioe);
        }
    }

    private String[] getCompressFlag() {
        String[] stringArray;
        if (this.compress) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "-compress";
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    private String[] getAppendFlag() {
        String[] stringArray;
        if (this.append) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "-append";
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    private String[] getPublishArtifactFlag() {
        String[] stringArray;
        if (this.publishArtifacts) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "-publishArtifacts";
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    private String[] getReusePack200FilesFlag() {
        String[] stringArray;
        if (this.reusePack200Files) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "-reusePack200Files";
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    private String[] getAdditionalArgs() throws MojoExecutionException {
        if (this.additionalArgs == null || "".equals(this.additionalArgs)) {
            return new String[0];
        }
        try {
            return CommandLineUtils.translateCommandline((String)this.additionalArgs);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to translate additional arguments into command line array", e);
        }
    }
}

