/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.pomless;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputSource;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.model.io.ModelParseException;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.io.ModelWriter;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.pomless.PomReference;
import org.sonatype.maven.polyglot.PolyglotModelUtil;
import org.sonatype.maven.polyglot.mapping.Mapping;

public abstract class AbstractTychoMapping
implements Mapping,
ModelReader {
    private static final String TYCHO_POMLESS_PARENT = "tycho.pomless.parent";
    private static final String PARENT_POM_DEFAULT_VALUE = System.getProperty("tycho.pomless.parent", "..");
    private static final String QUALIFIER_SUFFIX = ".qualifier";
    private static final String MODEL_PARENT = "TychoMapping.model.parent";
    @Requirement
    protected PlexusContainer container;
    @Requirement
    protected Logger logger;
    private ModelWriter writer;

    public File locatePom(File dir) {
        File file = new File(dir, "pom.xml");
        if (file.exists()) {
            return null;
        }
        return this.getPrimaryArtifact(dir);
    }

    public boolean accept(Map<String, ?> options) {
        String location = PolyglotModelUtil.getLocation(options);
        if (location == null || location.endsWith("pom.xml")) {
            return false;
        }
        return this.isValidLocation(location);
    }

    public ModelReader getReader() {
        return this;
    }

    public ModelWriter getWriter() {
        if (this.writer == null) {
            try {
                assert (this.container != null);
                this.writer = (ModelWriter)this.container.lookup(ModelWriter.class, this.getFlavour());
            }
            catch (ComponentLookupException e) {
                throw new RuntimeException(e);
            }
        }
        return this.writer;
    }

    public Model read(InputStream input, Map<String, ?> options) throws IOException, ModelParseException {
        String location = PolyglotModelUtil.getLocation(options);
        File file = new File(location);
        try (InputStreamReader stream = new InputStreamReader(input, this.getPrimaryArtifactCharset());){
            Model model = this.read(stream, file, options);
            return model;
        }
    }

    public Model read(File input, Map<String, ?> options) throws IOException, ModelParseException {
        File artifactFile = this.getRealArtifactFile(input);
        if (artifactFile.exists()) {
            try (InputStreamReader stream = new InputStreamReader((InputStream)new FileInputStream(artifactFile), this.getPrimaryArtifactCharset());){
                Model model = this.read(stream, input, options);
                return model;
            }
        }
        return this.read(new StringReader(""), input, options);
    }

    public Model read(Reader input, Map<String, ?> options) throws IOException, ModelParseException {
        File file = new File(PolyglotModelUtil.getLocation(options));
        return this.read(input, file, options);
    }

    private Model read(Reader artifactReader, File artifactFile, Map<String, ?> options) throws ModelParseException, IOException {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setPackaging(this.getPackaging());
        this.initModel(model, artifactReader, artifactFile);
        if (model.getParent() == null) {
            model.setParent(this.findParent(artifactFile.getParentFile(), options));
        }
        if (model.getVersion() == null) {
            model.setVersion(model.getParent().getVersion());
        }
        if (model.getName() == null) {
            model.setName(model.getArtifactId());
        }
        AbstractTychoMapping.setLocation(model, this.getRealArtifactFile(artifactFile));
        return model;
    }

    protected File getRealArtifactFile(File polyglotArtifactFile) {
        return polyglotArtifactFile;
    }

    protected Parent findParent(File projectRoot, Map<String, ?> projectOptions) throws ModelParseException, IOException {
        PomReference parentPom;
        Parent parent = (Parent)projectOptions.get(MODEL_PARENT);
        if (parent != null) {
            return parent;
        }
        Properties buildProperties = AbstractTychoMapping.getBuildProperties(projectRoot);
        String parentRef = buildProperties.getProperty(TYCHO_POMLESS_PARENT, PARENT_POM_DEFAULT_VALUE);
        File fileOrFolder = new File(projectRoot, parentRef).getCanonicalFile();
        if (fileOrFolder.isFile()) {
            parentPom = this.locatePomReference(fileOrFolder.getParentFile(), fileOrFolder.getName());
        } else if (fileOrFolder.isDirectory()) {
            parentPom = this.locatePomReference(fileOrFolder, null);
        } else {
            throw new FileNotFoundException("parent pom file/folder " + fileOrFolder + " is not accessible");
        }
        if (parentPom == null) {
            throw new FileNotFoundException("No parent pom file found in " + fileOrFolder.getCanonicalPath());
        }
        HashMap<String, FileModelSource> options = new HashMap<String, FileModelSource>(1);
        options.put("org.apache.maven.model.building.source", new FileModelSource(parentPom.getPomFile()));
        Model parentModel = parentPom.getReader().read(parentPom.getPomFile(), options);
        Parent parentReference = new Parent();
        String groupId = parentModel.getGroupId();
        if (groupId == null) {
            groupId = parentModel.getParent().getGroupId();
        }
        parentReference.setGroupId(groupId);
        parentReference.setArtifactId(parentModel.getArtifactId());
        String version = parentModel.getVersion();
        if (version == null) {
            version = parentModel.getParent().getVersion();
        }
        parentReference.setVersion(version);
        parentReference.setRelativePath(projectRoot.getCanonicalFile().toPath().relativize(parentPom.getPomFile().toPath()).toString());
        this.logger.debug("Derived parent for path " + projectRoot + " is goupId: " + parentReference.getGroupId() + ", artifactId: " + parentReference.getArtifactId() + ", relativePath: " + parentReference.getRelativePath());
        return parentReference;
    }

    protected PomReference locatePomReference(File folder, String nameHint) {
        PomReference reference = null;
        try {
            List lookupList = this.container.lookupList(ModelProcessor.class);
            for (ModelProcessor processor : lookupList) {
                try {
                    File pom = processor.locatePom(folder);
                    if (pom == null || !pom.exists() || reference != null && !pom.getName().equals(nameHint)) continue;
                    reference = new PomReference(pom, (ModelReader)processor);
                }
                catch (AssertionError assertionError) {}
            }
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
        return reference;
    }

    public float getPriority() {
        return 0.0f;
    }

    public String getFlavour() {
        return this.getPackaging();
    }

    protected abstract boolean isValidLocation(String var1);

    protected abstract File getPrimaryArtifact(File var1);

    protected abstract String getPackaging();

    protected Charset getPrimaryArtifactCharset() {
        return StandardCharsets.UTF_8;
    }

    protected abstract void initModel(Model var1, Reader var2, File var3) throws ModelParseException, IOException;

    protected static Properties getBuildProperties(File dir) throws IOException {
        Properties properties = new Properties();
        File buildProperties = new File(dir, "build.properties");
        if (buildProperties.exists()) {
            try (FileInputStream stream = new FileInputStream(buildProperties);){
                properties.load(stream);
            }
        }
        return properties;
    }

    private static void setLocation(Model model, File modelSource) {
        InputSource inputSource = new InputSource();
        inputSource.setLocation(modelSource.toString());
        inputSource.setModelId(model.getParent().getGroupId() + ":" + model.getArtifactId() + ":" + model.getVersion());
        model.setLocation((Object)"", new InputLocation(0, 0, inputSource));
    }

    protected static String getPomVersion(String pdeVersion) {
        String pomVersion = pdeVersion;
        if (pdeVersion.endsWith(QUALIFIER_SUFFIX)) {
            pomVersion = pdeVersion.substring(0, pdeVersion.length() - QUALIFIER_SUFFIX.length()) + "-SNAPSHOT";
        }
        return pomVersion;
    }
}

