/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.pomless;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.ModelParseException;
import org.eclipse.tycho.pomless.AbstractTychoMapping;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractXMLTychoMapping
extends AbstractTychoMapping {
    private static final DocumentBuilderFactory FACTORY = DocumentBuilderFactory.newInstance();

    @Override
    protected void initModel(Model model, Reader artifactReader, File artifactFile) throws ModelParseException, IOException {
        try {
            DocumentBuilder parser = FACTORY.newDocumentBuilder();
            Document doc = parser.parse(new InputSource(artifactReader));
            doc.setDocumentURI(artifactFile.toURI().toASCIIString());
            Element element = doc.getDocumentElement();
            this.initModelFromXML(model, element, artifactFile);
        }
        catch (ParserConfigurationException e) {
            throw new IOException("parser failed", e);
        }
        catch (SAXException e) {
            int lineNumber = -1;
            int columnNumber = -1;
            if (e instanceof SAXParseException) {
                SAXParseException parseException = (SAXParseException)e;
                lineNumber = parseException.getLineNumber();
                columnNumber = parseException.getColumnNumber();
            }
            throw new ModelParseException(e.getMessage(), lineNumber, columnNumber, (Throwable)e);
        }
    }

    protected abstract void initModelFromXML(Model var1, Element var2, File var3) throws ModelParseException, IOException;

    protected static String getRequiredXMLAttributeValue(Element element, String attributeName) throws ModelParseException {
        String value = AbstractXMLTychoMapping.getXMLAttributeValue(element, attributeName);
        if (value == null) {
            throw new ModelParseException(String.format("missing or empty '%s' attribute in element '%s' (uri=%s)", attributeName, element.getNodeName(), element.getOwnerDocument().getDocumentURI()), -1, -1);
        }
        return value;
    }

    protected static String getXMLAttributeValue(Element element, String attributeName) {
        String value;
        Attr idNode = element.getAttributeNode(attributeName);
        if (idNode != null && (value = idNode.getValue()) != null && !value.isEmpty()) {
            return value;
        }
        return null;
    }

    @Override
    public float getPriority() {
        return -1.0f;
    }
}

