/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.publisher;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.equinox.internal.p2.publisher.eclipse.FeatureParser;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.p2.updatesite.CategoryParser;
import org.eclipse.equinox.internal.p2.updatesite.SiteModel;
import org.eclipse.equinox.internal.p2.updatesite.SiteXMLAction;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.actions.IFeatureRootAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.equinox.p2.publisher.eclipse.ProductAction;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.tycho.core.resolver.shared.OptionalResolutionAction;
import org.eclipse.tycho.core.shared.TargetEnvironment;
import org.eclipse.tycho.p2.impl.publisher.AbstractMetadataGenerator;
import org.eclipse.tycho.p2.impl.publisher.AuthoredIUAction;
import org.eclipse.tycho.p2.impl.publisher.BundleDependenciesAction;
import org.eclipse.tycho.p2.impl.publisher.CategoryDependenciesAction;
import org.eclipse.tycho.p2.impl.publisher.DependencyMetadata;
import org.eclipse.tycho.p2.impl.publisher.DownloadStatsAdvice;
import org.eclipse.tycho.p2.impl.publisher.FeatureDependenciesAction;
import org.eclipse.tycho.p2.impl.publisher.MavenPropertiesAdvice;
import org.eclipse.tycho.p2.impl.publisher.P2Artifact;
import org.eclipse.tycho.p2.impl.publisher.ProductDependenciesAction;
import org.eclipse.tycho.p2.impl.publisher.SiteDependenciesAction;
import org.eclipse.tycho.p2.impl.publisher.model.ProductFile2;
import org.eclipse.tycho.p2.impl.publisher.repo.FeatureRootfileArtifactRepository;
import org.eclipse.tycho.p2.impl.publisher.repo.TransientArtifactRepository;
import org.eclipse.tycho.p2.impl.publisher.rootfiles.FeatureRootAdvice;
import org.eclipse.tycho.p2.maven.repository.xmlio.ArtifactsIO;
import org.eclipse.tycho.p2.maven.repository.xmlio.MetadataIO;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.metadata.IP2Artifact;
import org.eclipse.tycho.p2.metadata.P2Generator;
import org.eclipse.tycho.p2.metadata.PublisherOptions;

public class P2GeneratorImpl
extends AbstractMetadataGenerator
implements P2Generator {
    private static final String[] SUPPORTED_TYPES = new String[]{"eclipse-plugin", "eclipse-test-plugin", "eclipse-feature", "eclipse-update-site", "eclipse-application", "eclipse-repository"};
    private boolean dependenciesOnly;

    public P2GeneratorImpl(boolean dependenciesOnly) {
        this.dependenciesOnly = dependenciesOnly;
    }

    public P2GeneratorImpl() {
        this(false);
    }

    public Map<String, IP2Artifact> generateMetadata(List<IArtifactFacade> artifacts, PublisherOptions options, final File targetDir) throws IOException {
        LinkedHashMap<String, IP2Artifact> result = new LinkedHashMap<String, IP2Artifact>();
        for (IArtifactFacade artifact : artifacts) {
            DependencyMetadata metadata;
            TransientArtifactRepository artifactsRepository;
            PublisherInfo publisherInfo = new PublisherInfo();
            if ("eclipse-feature".equals(artifact.getPackagingType())) {
                publisherInfo.setArtifactOptions(11);
                artifactsRepository = new FeatureRootfileArtifactRepository(publisherInfo, targetDir);
                publisherInfo.setArtifactRepository((IArtifactRepository)artifactsRepository);
                metadata = super.generateMetadata(artifact, null, publisherInfo, null, options);
                result.putAll(((FeatureRootfileArtifactRepository)artifactsRepository).getPublishedArtifacts());
            } else if ("p2-installable-unit".equals(artifact.getPackagingType())) {
                artifactsRepository = new TransientArtifactRepository();
                publisherInfo.setArtifactRepository((IArtifactRepository)artifactsRepository);
                final IArtifactFacade currentArtifact = artifact;
                IArtifactFacade targetDirAsArtifact = new IArtifactFacade(){

                    public String getVersion() {
                        return currentArtifact.getVersion();
                    }

                    public String getPackagingType() {
                        return currentArtifact.getPackagingType();
                    }

                    public File getLocation() {
                        return targetDir;
                    }

                    public String getGroupId() {
                        return currentArtifact.getGroupId();
                    }

                    public String getClassifier() {
                        return currentArtifact.getClassifier();
                    }

                    public String getArtifactId() {
                        return currentArtifact.getArtifactId();
                    }
                };
                metadata = super.generateMetadata(targetDirAsArtifact, null, publisherInfo, null, options);
            } else {
                publisherInfo.setArtifactOptions(10);
                artifactsRepository = new TransientArtifactRepository();
                publisherInfo.setArtifactRepository((IArtifactRepository)artifactsRepository);
                metadata = super.generateMetadata(artifact, null, publisherInfo, null, options);
            }
            P2Artifact p2artifact = new P2Artifact(artifact.getLocation(), metadata.getInstallableUnits(), this.getCanonicalArtifact(artifact.getClassifier(), metadata.getArtifactDescriptors()));
            result.put(artifact.getClassifier(), p2artifact);
            IArtifactDescriptor packed = this.getPackedArtifactDescriptor(metadata.getArtifactDescriptors());
            if (packed == null) continue;
            File packedLocation = new File(String.valueOf(artifact.getLocation().getAbsolutePath()) + ".pack.gz");
            if (!packedLocation.canRead()) {
                throw new IllegalArgumentException("Could not find packed artifact " + packed + " at " + packedLocation);
            }
            if (result.containsKey("pack200")) {
                throw new IllegalArgumentException();
            }
            HashMap<String, String> additionalProperties = new HashMap<String, String>(5);
            additionalProperties.put("maven-groupId", artifact.getGroupId());
            additionalProperties.put("maven-artifactId", artifact.getArtifactId());
            additionalProperties.put("maven-version", artifact.getVersion());
            additionalProperties.put("maven-classifier", "pack200");
            additionalProperties.put("maven-extension", "jar.pack.gz");
            if (options.generateDownloadStatsProperty) {
                Optional<IArtifactDescriptor> canonicalDescriptor = metadata.getArtifactDescriptors().stream().filter(canonical -> packed.getArtifactKey().equals(canonical.getArtifactKey()) && canonical.getProperty("format") == null).findFirst();
                canonicalDescriptor.ifPresent(canonical -> {
                    String string = additionalProperties.put("download.stats", canonical.getProperty("download.stats"));
                });
            }
            ((ArtifactDescriptor)packed).addProperties(additionalProperties);
            result.put("pack200", new P2Artifact(packedLocation, Collections.emptySet(), packed));
        }
        return result;
    }

    private IArtifactDescriptor getPackedArtifactDescriptor(Set<IArtifactDescriptor> artifactDescriptors) {
        for (IArtifactDescriptor descriptor : artifactDescriptors) {
            if (!"packed".equals(descriptor.getProperty("format"))) continue;
            return descriptor;
        }
        return null;
    }

    private IArtifactDescriptor getCanonicalArtifact(String classifier, Set<IArtifactDescriptor> artifactDescriptors) {
        for (IArtifactDescriptor descriptor : artifactDescriptors) {
            String _classifier = descriptor.getProperty("maven-classifier");
            if (!P2GeneratorImpl.eq(classifier, _classifier) || descriptor.getProperty("format") != null) continue;
            return descriptor;
        }
        throw new IllegalArgumentException();
    }

    private static <T> boolean eq(T a, T b) {
        return a != null ? a.equals(b) : b == null;
    }

    public void persistMetadata(Map<String, IP2Artifact> metadata, File unitsXml, File artifactsXml) throws IOException {
        LinkedHashSet<IInstallableUnit> units = new LinkedHashSet<IInstallableUnit>();
        LinkedHashSet<IArtifactDescriptor> artifactDescriptors = new LinkedHashSet<IArtifactDescriptor>();
        for (IP2Artifact artifact : metadata.values()) {
            for (Object unit : artifact.getInstallableUnits()) {
                units.add((IInstallableUnit)unit);
            }
            artifactDescriptors.add((IArtifactDescriptor)artifact.getArtifactDescriptor());
        }
        new MetadataIO().writeXML(units, unitsXml);
        new ArtifactsIO().writeXML(artifactDescriptors, artifactsXml);
    }

    public DependencyMetadata generateMetadata(IArtifactFacade artifact, List<TargetEnvironment> environments, PublisherOptions options) {
        PublisherInfo publisherInfo = new PublisherInfo();
        publisherInfo.setArtifactOptions(3);
        publisherInfo.setArtifactRepository((IArtifactRepository)new TransientArtifactRepository());
        return super.generateMetadata(artifact, environments, publisherInfo, null, options);
    }

    @Override
    protected List<IPublisherAction> getPublisherActions(IArtifactFacade artifact, List<TargetEnvironment> environments, OptionalResolutionAction optionalAction) {
        if (!this.dependenciesOnly && optionalAction != null) {
            throw new IllegalArgumentException();
        }
        ArrayList<IPublisherAction> actions = new ArrayList<IPublisherAction>();
        String packaging = artifact.getPackagingType();
        File location = artifact.getLocation();
        if ("eclipse-plugin".equals(packaging) || "eclipse-test-plugin".equals(packaging)) {
            if (this.dependenciesOnly && optionalAction != null) {
                actions.add((IPublisherAction)new BundleDependenciesAction(location, optionalAction));
            } else {
                actions.add((IPublisherAction)new BundlesAction(new File[]{location}));
            }
        } else if ("eclipse-feature".equals(packaging)) {
            Feature feature = new FeatureParser().parse(location);
            feature.setLocation(location.getAbsolutePath());
            if (this.dependenciesOnly) {
                actions.add((IPublisherAction)new FeatureDependenciesAction(feature));
            } else {
                actions.add((IPublisherAction)new FeaturesAction(new Feature[]{feature}));
            }
        } else if ("eclipse-application".equals(packaging)) {
            String product = new File(location, String.valueOf(artifact.getArtifactId()) + ".product").getAbsolutePath();
            try {
                ProductFile2 productDescriptor = new ProductFile2(product);
                if (this.dependenciesOnly) {
                    actions.add((IPublisherAction)new ProductDependenciesAction((IProductDescriptor)productDescriptor));
                }
                actions.add((IPublisherAction)new ProductAction(product, (IProductDescriptor)productDescriptor, null, null));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if ("eclipse-update-site".equals(packaging)) {
            if (this.dependenciesOnly) {
                actions.add((IPublisherAction)new SiteDependenciesAction(location, artifact.getArtifactId(), artifact.getVersion()));
            } else {
                actions.add((IPublisherAction)new SiteXMLAction(location.toURI(), null));
            }
        } else if ("eclipse-repository".equals(packaging)) {
            for (File productFile : this.getProductFiles(location)) {
                ProductFile2 productDescriptor;
                String product = productFile.getAbsolutePath();
                try {
                    productDescriptor = new ProductFile2(product);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to parse the product file " + product, e);
                }
                if (!this.dependenciesOnly) continue;
                actions.add((IPublisherAction)new ProductDependenciesAction((IProductDescriptor)productDescriptor));
            }
            for (File categoryFile : this.getCategoryFiles(location)) {
                CategoryParser cp = new CategoryParser(null);
                FileInputStream ins = null;
                try {
                    try {
                        ins = new FileInputStream(categoryFile);
                        SiteModel siteModel = cp.parse((InputStream)ins);
                        actions.add((IPublisherAction)new CategoryDependenciesAction(siteModel, artifact.getArtifactId(), artifact.getVersion()));
                    }
                    finally {
                        if (ins != null) {
                            ins.close();
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to read category File", e);
                }
            }
        } else if ("p2-installable-unit".equals(packaging)) {
            actions.add(new AuthoredIUAction(location));
        } else if (location.isFile() && location.getName().endsWith(".jar")) {
            actions.add((IPublisherAction)new BundlesAction(new File[]{location}));
        } else {
            throw new IllegalArgumentException("Unknown type of packaging " + packaging);
        }
        return actions;
    }

    public boolean isSupported(String type) {
        return Arrays.asList(SUPPORTED_TYPES).contains(type);
    }

    private List<File> getProductFiles(File projectLocation) {
        ArrayList<File> res = new ArrayList<File>();
        File[] fileArray = projectLocation.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isFile() && f.getName().endsWith(".product") && !f.getName().startsWith(".polyglot")) {
                res.add(f);
            }
            ++n2;
        }
        return res;
    }

    private List<File> getCategoryFiles(File projectLocation) {
        ArrayList<File> res = new ArrayList<File>();
        File categoryFile = new File(projectLocation, "category.xml");
        if (categoryFile.exists()) {
            res.add(categoryFile);
        }
        return res;
    }

    @Override
    protected List<IPublisherAdvice> getPublisherAdvice(IArtifactFacade artifact, PublisherOptions options) {
        IFeatureRootAdvice featureRootAdvice;
        ArrayList<IPublisherAdvice> advice = new ArrayList<IPublisherAdvice>();
        advice.add((IPublisherAdvice)new MavenPropertiesAdvice(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getClassifier()));
        advice.add((IPublisherAdvice)this.getExtraEntriesAdvice(artifact));
        if (options.generateDownloadStatsProperty) {
            advice.add((IPublisherAdvice)new DownloadStatsAdvice());
        }
        if ((featureRootAdvice = FeatureRootAdvice.createRootFileAdvice(artifact, this.getBuildPropertiesParser())) != null) {
            advice.add((IPublisherAdvice)featureRootAdvice);
        }
        return advice;
    }
}

