/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.surefire.api.booter.Command;
import org.apache.maven.surefire.api.provider.AbstractProvider;
import org.apache.maven.surefire.api.provider.CommandChainReader;
import org.apache.maven.surefire.api.provider.CommandListener;
import org.apache.maven.surefire.api.provider.ProviderParameters;
import org.apache.maven.surefire.api.report.ConsoleOutputCapture;
import org.apache.maven.surefire.api.report.ReporterFactory;
import org.apache.maven.surefire.api.report.RunMode;
import org.apache.maven.surefire.api.report.TestOutputReceiver;
import org.apache.maven.surefire.api.report.TestOutputReportEntry;
import org.apache.maven.surefire.api.report.TestReportListener;
import org.apache.maven.surefire.api.suite.RunResult;
import org.apache.maven.surefire.api.testset.TestListResolver;
import org.apache.maven.surefire.api.testset.TestSetFailedException;
import org.apache.maven.surefire.api.util.RunOrderCalculator;
import org.apache.maven.surefire.api.util.ScanResult;
import org.apache.maven.surefire.api.util.ScannerFilter;
import org.apache.maven.surefire.api.util.TestsToRun;
import org.apache.maven.surefire.common.junit4.JUnit4ProviderUtil;
import org.apache.maven.surefire.common.junit4.JUnit4RunListener;
import org.apache.maven.surefire.common.junit4.JUnit4RunListenerFactory;
import org.apache.maven.surefire.common.junit4.JUnitTestFailureListener;
import org.apache.maven.surefire.common.junit4.Notifier;
import org.apache.maven.surefire.common.junit48.FilterFactory;
import org.apache.maven.surefire.common.junit48.JUnit48Reflector;
import org.apache.maven.surefire.common.junit48.JUnit48TestChecker;
import org.apache.maven.surefire.junitcore.ConcurrentRunListener;
import org.apache.maven.surefire.junitcore.JUnitCoreParameters;
import org.apache.maven.surefire.junitcore.JUnitCoreRunListener;
import org.apache.maven.surefire.junitcore.JUnitCoreWrapper;
import org.apache.maven.surefire.junitcore.NonConcurrentRunListener;
import org.apache.maven.surefire.junitcore.TestSet;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

public class JUnitCoreProvider
extends AbstractProvider {
    private final ClassLoader testClassLoader;
    private final JUnitCoreParameters jUnitCoreParameters;
    private final ScannerFilter scannerFilter;
    private final String customRunListeners;
    private final ProviderParameters providerParameters;
    private final ScanResult scanResult;
    private final int rerunFailingTestsCount;
    private final JUnit48Reflector jUnit48Reflector;
    private final RunOrderCalculator runOrderCalculator;
    private final TestListResolver testResolver;
    private final CommandChainReader commandsReader;
    private TestsToRun testsToRun;

    public JUnitCoreProvider(ProviderParameters bootParams) {
        this.commandsReader = bootParams.isInsideFork() ? bootParams.getCommandReader() : null;
        this.providerParameters = bootParams;
        this.testClassLoader = bootParams.getTestClassLoader();
        this.scanResult = bootParams.getScanResult();
        this.runOrderCalculator = bootParams.getRunOrderCalculator();
        this.jUnitCoreParameters = new JUnitCoreParameters(bootParams.getProviderProperties());
        this.scannerFilter = new JUnit48TestChecker(this.testClassLoader);
        this.testResolver = bootParams.getTestRequest().getTestListResolver();
        this.rerunFailingTestsCount = bootParams.getTestRequest().getRerunFailingTestsCount();
        this.customRunListeners = (String)bootParams.getProviderProperties().get("listener");
        this.jUnit48Reflector = new JUnit48Reflector(this.testClassLoader);
    }

    public Iterable<Class<?>> getSuites() {
        this.testsToRun = this.scanClassPath();
        return this.testsToRun;
    }

    private boolean isSingleThreaded() {
        return this.jUnitCoreParameters.isNoThreading();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunResult invoke(Object forkTestSet) throws TestSetFailedException {
        RunResult runResult;
        Filter filter;
        ReporterFactory reporterFactory = this.providerParameters.getReporterFactory();
        JUnit4RunListener listener = this.createRunListener(reporterFactory);
        listener.setRunMode(RunMode.NORMAL_RUN);
        ConsoleLogger logger = listener.getConsoleLogger();
        Notifier notifier = new Notifier(listener, this.getSkipAfterFailureCount());
        Filter filter2 = filter = this.jUnit48Reflector.isJUnit48Available() ? this.createJUnit48Filter() : null;
        if (this.testsToRun == null) {
            this.setTestsToRun(forkTestSet);
        }
        JUnitTestFailureListener testFailureListener = new JUnitTestFailureListener();
        notifier.addListener(testFailureListener);
        if (this.isFailFast() && this.commandsReader != null) {
            this.registerPleaseStopJUnitListener(notifier);
        }
        try {
            JUnitCoreWrapper core = new JUnitCoreWrapper(notifier, this.jUnitCoreParameters, logger);
            if (this.commandsReader != null) {
                this.registerShutdownListener(this.testsToRun);
                this.commandsReader.awaitStarted();
            }
            notifier.asFailFast(this.isFailFast());
            core.execute(this.testsToRun, JUnit4RunListenerFactory.createCustomListeners(this.customRunListeners), filter);
            notifier.asFailFast(false);
            if (this.isRerunFailingTests()) {
                listener.setRunMode(RunMode.RERUN_TEST_AFTER_FAILURE);
                Notifier rerunNotifier = Notifier.pureNotifier();
                notifier.copyListenersTo(rerunNotifier);
                JUnitCoreWrapper rerunCore = new JUnitCoreWrapper(rerunNotifier, this.jUnitCoreParameters, logger);
                for (int i = 0; i < this.rerunFailingTestsCount && !testFailureListener.getAllFailures().isEmpty(); ++i) {
                    Set<Description> failures = JUnit4ProviderUtil.generateFailingTestDescriptions(testFailureListener.getAllFailures());
                    testFailureListener.reset();
                    FilterFactory filterFactory = new FilterFactory(this.testClassLoader);
                    Filter failureDescriptionFilter = filterFactory.createMatchAnyDescriptionFilter(failures);
                    rerunCore.execute(this.testsToRun, failureDescriptionFilter);
                }
            }
        }
        finally {
            runResult = reporterFactory.close();
            notifier.removeListeners();
        }
        return runResult;
    }

    private void setTestsToRun(Object forkTestSet) throws TestSetFailedException {
        if (forkTestSet instanceof TestsToRun) {
            this.testsToRun = (TestsToRun)forkTestSet;
        } else if (forkTestSet instanceof Class) {
            Class theClass = (Class)forkTestSet;
            this.testsToRun = TestsToRun.fromClass((Class)theClass);
        } else {
            this.testsToRun = this.scanClassPath();
        }
    }

    private boolean isRerunFailingTests() {
        return this.rerunFailingTestsCount > 0;
    }

    private boolean isFailFast() {
        return this.providerParameters.getSkipAfterFailureCount() > 0;
    }

    private int getSkipAfterFailureCount() {
        return this.isFailFast() ? this.providerParameters.getSkipAfterFailureCount() : 0;
    }

    private void registerShutdownListener(final TestsToRun testsToRun) {
        this.commandsReader.addShutdownListener(new CommandListener(){

            public void update(Command command) {
                testsToRun.markTestSetFinished();
            }
        });
    }

    private void registerPleaseStopJUnitListener(final Notifier stoppable) {
        this.commandsReader.addSkipNextTestsListener(new CommandListener(){

            public void update(Command command) {
                stoppable.pleaseStop();
            }
        });
    }

    private JUnit4RunListener createRunListener(ReporterFactory reporterFactory) {
        JUnit4RunListener listener;
        if (this.isSingleThreaded()) {
            listener = new NonConcurrentRunListener((TestReportListener<TestOutputReportEntry>)reporterFactory.createTestReportListener());
        } else {
            ConcurrentHashMap<String, TestSet> testSetMap = new ConcurrentHashMap<String, TestSet>();
            boolean parallelClasses = this.isParallelTypes();
            boolean parallelBoth = this.isParallelMethodsAndTypes();
            ConcurrentRunListener concurrentListener = ConcurrentRunListener.createInstance(testSetMap, reporterFactory, parallelClasses, parallelBoth);
            listener = new JUnitCoreRunListener(concurrentListener, testSetMap);
        }
        ConsoleOutputCapture.startCapture((TestOutputReceiver)listener);
        return listener;
    }

    private boolean isParallelMethodsAndTypes() {
        return this.jUnitCoreParameters.isParallelMethods() && this.isParallelTypes();
    }

    private boolean isParallelTypes() {
        return this.jUnitCoreParameters.isParallelClasses() || this.jUnitCoreParameters.isParallelSuites();
    }

    private Filter createJUnit48Filter() {
        boolean onlyGroups;
        FilterFactory factory = new FilterFactory(this.testClassLoader);
        Map props = this.providerParameters.getProviderProperties();
        Filter groupFilter = factory.canCreateGroupFilter(props) ? factory.createGroupFilter(props) : null;
        TestListResolver methodFilter = TestListResolver.optionallyWildcardFilter((TestListResolver)this.testResolver);
        boolean bl = onlyGroups = methodFilter.isEmpty() || methodFilter.isWildcard();
        if (onlyGroups) {
            return groupFilter;
        }
        Filter jUnitMethodFilter = factory.createMethodFilter(methodFilter);
        return groupFilter == null ? jUnitMethodFilter : factory.and(groupFilter, jUnitMethodFilter);
    }

    private TestsToRun scanClassPath() {
        TestsToRun scanned = this.scanResult.applyFilter(this.scannerFilter, this.testClassLoader);
        return this.runOrderCalculator.orderTestClasses(scanned);
    }
}

