/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.transport;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLConnection;
import java.net.http.HttpTimeoutException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import org.apache.commons.io.FileUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.repository.AuthenticationFailedException;
import org.eclipse.equinox.internal.p2.repository.DownloadStatus;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.provisional.p2.repository.IStateful;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.spi.IAgentServiceFactory;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.tycho.p2maven.transport.DownloadStatusOutputStream;
import org.eclipse.tycho.p2maven.transport.TransportCacheConfig;
import org.eclipse.tycho.transport.ArtifactDownloadProvider;
import org.eclipse.tycho.transport.TransportProtocolHandler;

@Component(role=Transport.class, hint="tycho")
public class TychoRepositoryTransport
extends Transport
implements IAgentServiceFactory {
    private static final int MAX_DOWNLOAD_THREADS = Integer.getInteger("tycho.p2.transport.max-download-threads", 4);
    private static final Executor DOWNLOAD_EXECUTOR = Executors.newFixedThreadPool(MAX_DOWNLOAD_THREADS, new ThreadFactory(){
        private AtomicInteger cnt = new AtomicInteger();

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("Tycho-Download-Thread-" + this.cnt.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    });
    private NumberFormat numberFormat = NumberFormat.getNumberInstance();
    @Requirement
    Logger logger;
    @Requirement
    TransportCacheConfig cacheConfig;
    @Requirement(role=TransportProtocolHandler.class)
    Map<String, TransportProtocolHandler> transportProtocolHandlers;
    @Requirement
    List<ArtifactDownloadProvider> artifactDownloadProvider;
    private LongAdder requests = new LongAdder();
    private LongAdder indexRequests = new LongAdder();

    public TychoRepositoryTransport() {
        this.numberFormat.setMaximumFractionDigits(2);
    }

    public IStatus downloadArtifact(URI source, OutputStream target, IArtifactDescriptor descriptor, IProgressMonitor monitor) {
        if (descriptor != null) {
            Iterator iterator = this.artifactDownloadProvider.stream().distinct().sorted(Comparator.comparingInt(ArtifactDownloadProvider::getPriority).reversed()).iterator();
            while (iterator.hasNext()) {
                ArtifactDownloadProvider provider = (ArtifactDownloadProvider)iterator.next();
                IStatus status = provider.downloadArtifact(source, target, descriptor);
                if (status.matches(8)) continue;
                return TychoRepositoryTransport.reportStatus(status, target);
            }
        }
        String id = "p2";
        if (this.cacheConfig.isInteractive()) {
            this.logger.info("Downloading from " + id + ": " + String.valueOf(source));
        }
        try {
            DownloadStatusOutputStream statusOutputStream = new DownloadStatusOutputStream(target, "Download of " + String.valueOf(source));
            this.stream(source, monitor).transferTo(statusOutputStream);
            DownloadStatus downloadStatus = statusOutputStream.getStatus();
            if (this.cacheConfig.isInteractive()) {
                this.logger.info("Downloaded from " + id + ": " + String.valueOf(source) + " (" + FileUtils.byteCountToDisplaySize((long)downloadStatus.getFileSize()) + " at " + FileUtils.byteCountToDisplaySize((long)downloadStatus.getTransferRate()) + "/s)");
            }
            return TychoRepositoryTransport.reportStatus((IStatus)downloadStatus, target);
        }
        catch (AuthenticationFailedException e) {
            return TychoRepositoryTransport.reportStatus((IStatus)TychoRepositoryTransport.statusWithCode("authentication failed for %s", 1007, source, (Exception)((Object)e)), target);
        }
        catch (IOException e) {
            if (e instanceof HttpTimeoutException) {
                return TychoRepositoryTransport.reportStatus((IStatus)TychoRepositoryTransport.statusWithCode("download from %s timed out", 1002, source, e), target);
            }
            return TychoRepositoryTransport.reportStatus(Status.error((String)("download from " + String.valueOf(source) + " failed"), (Throwable)e), target);
        }
        catch (CoreException e) {
            return TychoRepositoryTransport.reportStatus(e.getStatus(), target);
        }
    }

    public InputStream stream(URI toDownload, IProgressMonitor monitor) throws FileNotFoundException, CoreException, AuthenticationFailedException {
        boolean debug = this.cacheConfig.isDebug();
        if (debug) {
            this.logger.info("Request stream for " + String.valueOf(toDownload));
        }
        this.requests.increment();
        if (toDownload.toASCIIString().endsWith("p2.index")) {
            this.indexRequests.increment();
        }
        try {
            Object cachedFile;
            TransportProtocolHandler handler = this.getHandler(toDownload);
            if (handler != null && (cachedFile = handler.getFile(toDownload)) != null) {
                if (debug) {
                    this.logger.debug(" --> routed through handler " + handler.getClass().getSimpleName());
                }
                FileInputStream fileInputStream = new FileInputStream((File)cachedFile);
                return fileInputStream;
            }
            cachedFile = toDownload.toURL().openStream();
            return cachedFile;
        }
        catch (FileNotFoundException e) {
            if (debug) {
                this.logger.info(" --> not found! (" + String.valueOf(toDownload) + ")");
            }
            throw e;
        }
        catch (HttpTimeoutException timeout) {
            if (debug) {
                this.logger.info(" --> timeout while requesting (" + String.valueOf(toDownload) + "): " + String.valueOf(timeout));
            }
            throw new CoreException((IStatus)TychoRepositoryTransport.statusWithCode("download from %s timed out", 1002, toDownload, timeout));
        }
        catch (IOException e) {
            if (e instanceof AuthenticationFailedException) {
                AuthenticationFailedException afe = (AuthenticationFailedException)((Object)e);
                throw afe;
            }
            if (debug) {
                this.logger.info(" --> generic error (" + String.valueOf(toDownload) + "): " + String.valueOf(e));
            }
            throw new CoreException((IStatus)TychoRepositoryTransport.statusWithCode("download from %s failed", 1002, toDownload, e));
        }
        finally {
            if (debug) {
                this.logger.debug("Total number of requests: " + this.requests.longValue() + " (" + this.indexRequests.longValue() + " for p2.index)");
            }
        }
    }

    public IStatus download(URI toDownload, OutputStream target, IProgressMonitor monitor) {
        return this.downloadArtifact(toDownload, target, null, monitor);
    }

    public IStatus download(URI toDownload, OutputStream target, long startPos, IProgressMonitor monitor) {
        if (startPos > 0L) {
            return Status.error((String)"range downloads are not implemented");
        }
        return this.downloadArtifact(toDownload, target, null, monitor);
    }

    TransportProtocolHandler getHandler(URI uri) {
        String lc;
        TransportProtocolHandler handler;
        String scheme = uri.getScheme();
        if (scheme != null && (handler = this.transportProtocolHandlers.get(lc = scheme.toLowerCase())) != null) {
            return handler;
        }
        return null;
    }

    public long getLastModified(URI toDownload, IProgressMonitor monitor) throws CoreException, FileNotFoundException, AuthenticationFailedException {
        try {
            TransportProtocolHandler handler = this.getHandler(toDownload);
            if (handler != null) {
                return handler.getLastModified(toDownload);
            }
            URLConnection connection = toDownload.toURL().openConnection();
            long lastModified = connection.getLastModified();
            connection.getInputStream().close();
            return lastModified;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw new CoreException(Status.error((String)("download from " + String.valueOf(toDownload) + " failed"), (Throwable)e));
        }
    }

    public Object createService(IProvisioningAgent agent) {
        return this;
    }

    public static Executor getDownloadExecutor() {
        return DOWNLOAD_EXECUTOR;
    }

    public File downloadToFile(URI uri) throws IOException {
        File file;
        TransportProtocolHandler handler = this.getHandler(uri);
        if (handler != null && (file = handler.getFile(uri)) != null) {
            return file;
        }
        Path tempFile = Files.createTempFile("tycho", ".tmp", new FileAttribute[0]);
        tempFile.toFile().deleteOnExit();
        try {
            Files.copy(this.stream(uri, null), tempFile, new CopyOption[0]);
            return tempFile.toFile();
        }
        catch (CoreException e) {
            throw new IOException(e);
        }
    }

    TransportCacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    private static IStatus reportStatus(IStatus status, OutputStream target) {
        if (target instanceof IStateful) {
            IStateful stateful = (IStateful)target;
            stateful.setStatus(status);
        }
        return status;
    }

    private static Status statusWithCode(String message, int code, URI source, Exception causingException) {
        return new Status(4, TychoRepositoryTransport.class, code, String.format(message, source), (Throwable)causingException);
    }
}

