/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.ds;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Processor;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.maven.SessionScoped;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.ResolvedArtifactKey;
import org.eclipse.tycho.classpath.ClasspathContributor;
import org.eclipse.tycho.core.DeclarativeServicesConfiguration;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.maven.MavenDependenciesResolver;
import org.eclipse.tycho.core.osgitools.AbstractSpecificationClasspathContributor;
import org.eclipse.tycho.ds.DeclarativeServiceConfigurationReader;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

@Component(role=ClasspathContributor.class, hint="ds-annotations")
@SessionScoped
public class DeclarativeServicesClasspathContributor
extends AbstractSpecificationClasspathContributor
implements ClasspathContributor {
    private static final String DS_ANNOTATIONS_PACKAGE = "org.osgi.service.component.annotations";
    private static final String DS_ANNOTATIONS_GROUP_ID = "org.osgi";
    private static final String DS_ANNOTATIONS_ARTIFACT_ID = "org.osgi.service.component.annotations";
    private static final String DS_ANNOTATIONS_1_2_ARTIFACT_ID = "osgi.cmpn";
    private static final String DS_ANNOTATIONS_1_2_VERSION = "5.0.0";
    @Requirement
    DeclarativeServiceConfigurationReader configurationReader;
    @Requirement
    MavenDependenciesResolver dependenciesResolver;
    @Requirement
    TychoProjectManager projectManager;

    @Inject
    public DeclarativeServicesClasspathContributor(MavenSession session) {
        super(session, "org.osgi.service.component.annotations", DS_ANNOTATIONS_GROUP_ID, "org.osgi.service.component.annotations");
    }

    protected Optional<ResolvedArtifactKey> findBundle(MavenProject project, VersionRange specificationVersion) {
        return super.findBundle(project, specificationVersion).or(() -> {
            Version v = specificationVersion.getLeft();
            if (v.getMajor() == 1 && v.getMinor() == 2) {
                try {
                    Artifact artifact = this.dependenciesResolver.resolveArtifact(project, this.session, DS_ANNOTATIONS_GROUP_ID, DS_ANNOTATIONS_1_2_ARTIFACT_ID, DS_ANNOTATIONS_1_2_VERSION);
                    ArtifactKey artifactKey = this.projectManager.getArtifactKey(artifact);
                    return Optional.of(ResolvedArtifactKey.of((ArtifactKey)artifactKey, (File)artifact.getFile()));
                }
                catch (ArtifactResolutionException artifactResolutionException) {
                    // empty catch block
                }
            }
            return Optional.empty();
        });
    }

    protected VersionRange getSpecificationVersion(MavenProject project) {
        block12: {
            VersionRange versionRange;
            try {
                DeclarativeServicesConfiguration configuration = this.configurationReader.getConfiguration(project);
                if (configuration != null) {
                    Version lowerVersion = configuration.getSpecificationVersion();
                    Version upperVersion = new Version(lowerVersion.getMajor(), lowerVersion.getMinor() + 1, 0);
                    return new VersionRange('[', lowerVersion, upperVersion, ')');
                }
            }
            catch (IOException configuration) {
                // empty catch block
            }
            File bndFile = new File(project.getBasedir(), "pde.bnd");
            if (!bndFile.exists()) break block12;
            Processor processor = new Processor();
            try {
                processor.setProperties(bndFile);
                Version lowerVersion = new Version("1.3.0");
                Version upperVersion = null;
                String mergeProperties = processor.mergeProperties("-dsannotations-options");
                Parameters optionsHeader = OSGiHeader.parseHeader((String)mergeProperties);
                for (Map.Entry entry : optionsHeader.entrySet()) {
                    String max;
                    if (!"version".equals(entry.getKey())) continue;
                    Attrs attrs = (Attrs)entry.getValue();
                    String min = attrs.get("minimum");
                    if (min != null && min.length() > 0) {
                        lowerVersion = Version.valueOf((String)min);
                    }
                    if ((max = attrs.get("maximum")) == null || max.length() <= 0) continue;
                    Version version = Version.valueOf((String)max);
                    upperVersion = new Version(version.getMajor(), version.getMinor() + 1, 0);
                }
                versionRange = new VersionRange('[', lowerVersion, upperVersion, ')');
            }
            catch (Throwable throwable) {
                try {
                    try {
                        processor.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            processor.close();
            return versionRange;
        }
        return new VersionRange('[', Version.parseVersion((String)"1.4"), null, ')');
    }
}

