/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.model;

import aQute.bnd.header.Attrs;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.CapabilityBuilder;
import aQute.bnd.osgi.resource.RequirementBuilder;
import aQute.bnd.osgi.resource.ResourceBuilder;
import aQute.bnd.version.VersionRange;

class FeatureResourceBuilder
extends ResourceBuilder {
    static final String P2_FEATURE = "p2.feature";
    static final String FEATURE_JAR_SUFFIX = ".feature.jar";
    static final String P2_GROUP = "p2.group";

    FeatureResourceBuilder() {
    }

    public void addRequireFeature(String id, String versionRange) {
        RequirementBuilder feature = new RequirementBuilder("osgi.identity");
        Attrs featureAttrs = new Attrs();
        featureAttrs.put("type", P2_GROUP);
        feature.addFilter("osgi.identity", id, versionRange, featureAttrs);
        this.addRequirement((CapReqBuilder)feature);
    }

    public void addFeatureGroupCapability(String id, String version) {
        CapabilityBuilder identity = new CapabilityBuilder("osgi.identity");
        identity.addAttribute("osgi.identity", (Object)(id + ".feature.group"));
        identity.addAttribute("version", (Object)version);
        identity.addAttribute("type", (Object)P2_GROUP);
        this.addCapability((CapReqBuilder)identity);
    }

    public void addFeatureJarRequirement(String id, String version) {
        RequirementBuilder featureJar = new RequirementBuilder("osgi.identity");
        Attrs featureJarAttrs = new Attrs();
        featureJarAttrs.put("type", P2_FEATURE);
        featureJar.addFilter("osgi.identity", id + FEATURE_JAR_SUFFIX, "[" + version + "," + version + "]", featureJarAttrs);
        this.addRequirement((CapReqBuilder)featureJar);
    }

    public void addFeatureJarCapability(String id, String version) {
        CapabilityBuilder identity = new CapabilityBuilder("osgi.identity");
        identity.addAttribute("osgi.identity", (Object)(id + FEATURE_JAR_SUFFIX));
        identity.addAttribute("version", (Object)version);
        identity.addAttribute("type", (Object)P2_FEATURE);
        this.addCapability((CapReqBuilder)identity);
    }

    public void addRuntimeBundleRequirement(String bsn, VersionRange range) {
        Attrs attrs = new Attrs();
        attrs.put("bundle-version", range.toString());
        RequirementBuilder require = new RequirementBuilder("osgi.wiring.bundle");
        require.addDirective("effective", "active");
        require.addFilter("osgi.wiring.bundle", bsn, attrs.get("bundle-version"), attrs);
        this.addRequirement((CapReqBuilder)require);
    }

    public void addRuntimeFeature(String id, VersionRange range) {
        RequirementBuilder feature = new RequirementBuilder("osgi.identity");
        Attrs featureAttrs = new Attrs();
        featureAttrs.put("type", P2_GROUP);
        feature.addFilter("osgi.identity", id, range.toString(), featureAttrs);
        feature.addDirective("effective", "active");
        this.addRequirement((CapReqBuilder)feature);
    }
}

