/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.repository;

import java.net.URISyntaxException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.tycho.p2tools.copiedfromp2.Repo2Runnable;
import org.eclipse.tycho.p2tools.copiedfromp2.RepositoryDescriptor;

@Mojo(name="repo-to-runnable")
public class Repo2RunnableMojo
extends AbstractMojo {
    @Component
    private IProvisioningAgent agent;
    @Component
    private Logger logger;
    @Parameter
    private boolean createFragments;
    @Parameter
    private boolean flagAsRunnable;
    @Parameter
    private String source;
    @Parameter
    private String destination;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Repo2Runnable repo2Runnable = new Repo2Runnable(this.agent);
        repo2Runnable.setCreateFragments(this.createFragments);
        repo2Runnable.setFlagAsRunnable(this.flagAsRunnable);
        RepositoryDescriptor source = new RepositoryDescriptor();
        try {
            source.setLocation(URIUtil.fromString((String)this.source));
        }
        catch (URISyntaxException e) {
            throw new MojoExecutionException("Invalid source: " + this.source, (Exception)e);
        }
        repo2Runnable.addSource(source);
        RepositoryDescriptor destination = new RepositoryDescriptor();
        try {
            destination.setLocation(URIUtil.fromString((String)this.destination));
        }
        catch (URISyntaxException e) {
            throw new MojoExecutionException("Invalid destination: " + this.destination, (Exception)e);
        }
        repo2Runnable.addDestination(destination);
        this.logger.info("Create runnable repository at " + String.valueOf(destination.getRepoLocation()));
        this.logger.info("  from " + String.valueOf(source.getRepoLocation()));
        try {
            repo2Runnable.run(null);
        }
        catch (ProvisionException e) {
            throw new MojoFailureException((Throwable)e);
        }
    }
}

