/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.source;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.BuildProperties;
import org.eclipse.tycho.BuildPropertiesParser;
import org.eclipse.tycho.ReproducibleUtils;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.osgitools.OsgiManifest;
import org.eclipse.tycho.packaging.IncludeValidationHelper;
import org.eclipse.tycho.source.AbstractSourceJarMojo;
import org.osgi.framework.Version;

@Mojo(name="plugin-source", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true)
public class OsgiSourceMojo
extends AbstractSourceJarMojo {
    static final String GOAL = "plugin-source";
    static final String MANIFEST_HEADER_ECLIPSE_SOURCE_BUNDLE = "Eclipse-SourceBundle";
    private static final String MANIFEST_BUNDLE_LOCALIZATION_BASENAME = "OSGI-INF/l10n/bundle-src";
    static final String MANIFEST_BUNDLE_LOCALIZATION_FILENAME = "OSGI-INF/l10n/bundle-src.properties";
    private static final String I18N_KEY_PREFIX = "%";
    private static final String I18N_KEY_BUNDLE_VENDOR = "bundleVendor";
    private static final String I18N_KEY_BUNDLE_NAME = "bundleName";
    private static final String VERSION_QUALIFIER = "qualifier";
    @Parameter(defaultValue="true")
    private boolean sourceBundle;
    @Parameter(defaultValue="false")
    private boolean distinctSourceRoots;
    @Parameter(property="sourceBundleSuffix", defaultValue=".source")
    private String sourceBundleSuffix;
    @Parameter(property="buildQualifier")
    private String qualifier;
    @Parameter(defaultValue="true")
    protected boolean useDefaultSourceExcludes;
    @Parameter(defaultValue="false", readonly=true)
    protected boolean requireSourceRoots;
    @Parameter(defaultValue="true")
    protected boolean strictSrcIncludes;
    @Parameter
    private DefaultFileSet[] additionalFileSets;
    @Parameter(defaultValue="sources")
    private String classifier;
    @Component(role=TychoProject.class)
    private Map<String, TychoProject> projectTypes;
    @Component
    private IncludeValidationHelper includeValidationHelper;
    @Component
    private BundleReader bundleReader;
    @Component
    private BuildPropertiesParser buildPropertiesParser;
    private static final Set<String> RELEVANT_PACKAING_TYPES = Set.of("eclipse-plugin", "eclipse-test-plugin");

    public void setBuildPropertiesParser(BuildPropertiesParser buildPropertiesParser) {
        this.buildPropertiesParser = buildPropertiesParser;
    }

    @Override
    protected List<Resource> getSources(MavenProject p) throws MojoExecutionException {
        return this.getSources(this.project, this.requireSourceRoots, this.buildPropertiesParser.parse(DefaultReactorProject.adapt((MavenProject)this.project)));
    }

    protected List<Resource> getSources(MavenProject p, boolean requireSourceRoots, BuildProperties buildProperties) throws MojoExecutionException {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (Map.Entry entry : buildProperties.getJarToSourceFolderMap().entrySet()) {
            for (String sourceFolder : (List)entry.getValue()) {
                String jarName;
                Resource resource = new Resource();
                resource.setDirectory(new File(p.getBasedir(), sourceFolder).getAbsolutePath());
                if (this.distinctSourceRoots && !".".equals(jarName = (String)entry.getKey())) {
                    resource.setTargetPath(OsgiSourceMojo.getSourceRootTargetPath(jarName));
                }
                resources.add(resource);
            }
        }
        if (requireSourceRoots && resources.isEmpty()) {
            throw new MojoExecutionException("no source folders found in build.properties");
        }
        return resources;
    }

    @Override
    protected List<Resource> getResources(MavenProject p) throws MojoExecutionException {
        if (this.excludeResources) {
            return Collections.emptyList();
        }
        BuildProperties buildProperties = this.buildPropertiesParser.parse(DefaultReactorProject.adapt((MavenProject)p));
        List srcIncludesList = buildProperties.getSourceIncludes();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (!srcIncludesList.isEmpty()) {
            this.includeValidationHelper.checkSourceIncludesExist(p, buildProperties, this.strictSrcIncludes);
            resources.add(OsgiSourceMojo.createResource(this.project.getBasedir().getAbsolutePath(), srcIncludesList, buildProperties.getSourceExcludes()));
        }
        if (this.additionalFileSets != null) {
            for (DefaultFileSet fileSet : this.additionalFileSets) {
                if (fileSet.getIncludes() == null || fileSet.getIncludes().length <= 0) continue;
                resources.add(OsgiSourceMojo.createResource(fileSet.getDirectory().getAbsolutePath(), OsgiSourceMojo.asList(fileSet.getIncludes()), OsgiSourceMojo.asList(fileSet.getExcludes())));
            }
        }
        if (!srcIncludesList.contains(MANIFEST_BUNDLE_LOCALIZATION_FILENAME)) {
            OsgiManifest manifest = this.bundleReader.loadManifest(this.project.getBasedir());
            Path basedir = this.project.getBasedir().toPath();
            String bsn = manifest.getBundleSymbolicName();
            resources.add(OsgiSourceMojo.generateL10nFile(this.project, basedir, arg_0 -> ((OsgiManifest)manifest).getValue(arg_0), bsn, this.getLog()));
        }
        return resources;
    }

    private static List<String> asList(String[] patterns) {
        if (patterns == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(patterns);
    }

    private static Resource createResource(String directory, List<String> includes, List<String> excludes) {
        Resource resource = new Resource();
        resource.setDirectory(directory);
        resource.setExcludes(excludes);
        resource.setIncludes(includes);
        return resource;
    }

    static Resource generateL10nFile(MavenProject project, Path basedir, UnaryOperator<String> manifest, String bsn, Log log) throws MojoExecutionException {
        Properties l10nProps = OsgiSourceMojo.readL10nProps(manifest, basedir, log);
        String bundleName = OsgiSourceMojo.getL10nResolvedValue(manifest, "Bundle-Name", l10nProps);
        if (bundleName == null) {
            log.warn((CharSequence)("Bundle-Name header not found in " + String.valueOf(basedir.resolve("META-INF/MANIFEST.MF")) + ", fallback to Bundle-SymbolicName for source bundle"));
            bundleName = bsn;
        }
        String sourceBundleName = bundleName + " Source";
        String bundleVendor = OsgiSourceMojo.getL10nResolvedValue(manifest, "Bundle-Vendor", l10nProps);
        if (bundleVendor == null) {
            log.warn((CharSequence)("Bundle-Vendor header not found in " + String.valueOf(basedir.resolve("META-INF/MANIFEST.MF")) + ", fallback to 'unknown' for source bundle"));
            bundleVendor = "unknown";
        }
        File l10nOutputDir = new File(project.getBuild().getDirectory(), "sourcebundle-l10n-gen");
        Properties sourceL10nProps = new Properties();
        sourceL10nProps.setProperty(I18N_KEY_BUNDLE_NAME, sourceBundleName);
        sourceL10nProps.setProperty(I18N_KEY_BUNDLE_VENDOR, bundleVendor);
        File l10nPropsFile = new File(l10nOutputDir, MANIFEST_BUNDLE_LOCALIZATION_FILENAME);
        try {
            ReproducibleUtils.storeProperties((Properties)sourceL10nProps, (Path)l10nPropsFile.toPath());
        }
        catch (IOException e) {
            throw new MojoExecutionException("error while generating source bundle localization file", (Exception)e);
        }
        Resource l10nResource = new Resource();
        l10nResource.setDirectory(l10nOutputDir.getAbsolutePath());
        l10nResource.setIncludes(List.of(MANIFEST_BUNDLE_LOCALIZATION_FILENAME));
        return l10nResource;
    }

    protected Properties readL10nProps(OsgiManifest manifest) throws MojoExecutionException {
        return OsgiSourceMojo.readL10nProps(arg_0 -> ((OsgiManifest)manifest).getValue(arg_0), this.project.getBasedir().toPath(), this.getLog());
    }

    protected static Properties readL10nProps(UnaryOperator<String> getManifestHeaderValue, Path basedir, Log log) throws MojoExecutionException {
        Path l10nPropsFile;
        boolean hasL10nProperty;
        String bundleL10nBase = (String)getManifestHeaderValue.apply("Bundle-Localization");
        boolean bl = hasL10nProperty = bundleL10nBase != null;
        if (bundleL10nBase == null) {
            bundleL10nBase = "OSGI-INF/l10n/bundle";
        }
        if (!Files.isRegularFile(l10nPropsFile = basedir.resolve(bundleL10nBase + ".properties"), new LinkOption[0]) && !Files.isRegularFile(l10nPropsFile = basedir.resolve((bundleL10nBase = "plugin") + ".properties"), new LinkOption[0])) {
            if (hasL10nProperty) {
                log.warn((CharSequence)("Bundle localization file " + String.valueOf(l10nPropsFile) + " not found"));
            }
            return null;
        }
        Properties l10nProps = new Properties();
        try (InputStream in = Files.newInputStream(l10nPropsFile, new OpenOption[0]);){
            l10nProps.load(in);
        }
        catch (IOException e) {
            throw new MojoExecutionException("error loading " + String.valueOf(l10nPropsFile), (Exception)e);
        }
        return l10nProps;
    }

    private static String getL10nResolvedValue(UnaryOperator<String> getManifestHeaderValue, String manifestHeaderKey, Properties l10nProps) {
        String value = (String)getManifestHeaderValue.apply(manifestHeaderKey);
        if (value == null || !value.startsWith(I18N_KEY_PREFIX) || l10nProps == null) {
            return value;
        }
        String key = value.substring(1).trim();
        return l10nProps.getProperty(key);
    }

    @Override
    protected String getClassifier() {
        return this.classifier;
    }

    @Override
    protected void updateSourceManifest(MavenArchiveConfiguration mavenArchiveConfiguration) {
        super.updateSourceManifest(mavenArchiveConfiguration);
        if (this.sourceBundle) {
            this.addSourceBundleManifestEntries(mavenArchiveConfiguration);
        }
    }

    private void addSourceBundleManifestEntries(MavenArchiveConfiguration mavenArchiveConfiguration) {
        TychoProject projectType = this.projectTypes.get(this.project.getPackaging());
        ArtifactKey artifactKey = projectType.getArtifactKey(DefaultReactorProject.adapt((MavenProject)this.project));
        String symbolicName = artifactKey.getId();
        String version = artifactKey.getVersion();
        if (symbolicName != null && version != null) {
            mavenArchiveConfiguration.addManifestEntry("Bundle-ManifestVersion", "2");
            mavenArchiveConfiguration.addManifestEntry("Bundle-SymbolicName", symbolicName + this.sourceBundleSuffix);
            Version expandedVersion = this.getExpandedVersion(version);
            mavenArchiveConfiguration.addManifestEntry("Bundle-Version", expandedVersion.toString());
            mavenArchiveConfiguration.addManifestEntry(MANIFEST_HEADER_ECLIPSE_SOURCE_BUNDLE, symbolicName + ";version=\"" + String.valueOf(expandedVersion) + "\";roots:=\"" + this.getEclipseHeaderSourceRoots() + "\"");
            OsgiSourceMojo.addLocalicationHeaders((arg_0, arg_1) -> ((MavenArchiveConfiguration)mavenArchiveConfiguration).addManifestEntry(arg_0, arg_1));
        } else {
            this.getLog().info((CharSequence)"NOT adding source bundle MANIFEST.MF entries. Incomplete or absent bundle information");
        }
    }

    static void addLocalicationHeaders(BiConsumer<String, String> manifest) {
        manifest.accept("Bundle-Name", "%bundleName");
        manifest.accept("Bundle-Vendor", "%bundleVendor");
        manifest.accept("Bundle-Localization", MANIFEST_BUNDLE_LOCALIZATION_BASENAME);
    }

    private String getEclipseHeaderSourceRoots() {
        if (!this.distinctSourceRoots) {
            return ".";
        }
        BuildProperties buildProperties = this.buildPropertiesParser.parse(DefaultReactorProject.adapt((MavenProject)this.project));
        return buildProperties.getJarToSourceFolderMap().keySet().stream().map(jarName -> ".".equals(jarName) ? "." : OsgiSourceMojo.getSourceRootTargetPath(jarName)).collect(Collectors.joining(","));
    }

    private static String getSourceRootTargetPath(String jarName) {
        if (jarName.endsWith(".jar")) {
            jarName = jarName.substring(0, jarName.length() - ".jar".length());
        } else if (jarName.endsWith("/")) {
            jarName = jarName.substring(0, jarName.length() - 1);
        }
        return jarName + "src";
    }

    private Version getExpandedVersion(String versionStr) {
        Version version = Version.parseVersion((String)versionStr);
        if (VERSION_QUALIFIER.equals(version.getQualifier())) {
            return new Version(version.getMajor(), version.getMinor(), version.getMicro(), this.qualifier);
        }
        return version;
    }

    @Override
    protected boolean isRelevantProject(MavenProject project) {
        return OsgiSourceMojo.isRelevant(project, this.buildPropertiesParser);
    }

    public static boolean isRelevant(MavenProject project, BuildPropertiesParser buildPropertiesParser) {
        if (!RELEVANT_PACKAING_TYPES.contains(project.getPackaging())) {
            return false;
        }
        Plugin plugin = project.getPlugin("org.eclipse.tycho:tycho-source-plugin");
        if (plugin == null) {
            return false;
        }
        for (PluginExecution execution : plugin.getExecutions()) {
            if (!execution.getGoals().contains(GOAL)) continue;
            String requireSourceRoots = OsgiSourceMojo.getParameterValue(execution, "requireSourceRoots", "false");
            if (Boolean.parseBoolean(requireSourceRoots)) {
                return true;
            }
            Xpp3Dom configuration = (Xpp3Dom)execution.getConfiguration();
            if (OsgiSourceMojo.getConfigurationElement(configuration, "additionalFileSets") != null) {
                return true;
            }
            BuildProperties buildProps = buildPropertiesParser.parse(DefaultReactorProject.adapt((MavenProject)project));
            if (buildProps.getJarToSourceFolderMap().isEmpty() && buildProps.getSourceIncludes().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static String getParameterValue(PluginExecution execution, String name, String defaultValue) {
        String value = OsgiSourceMojo.getElementValue((Xpp3Dom)execution.getConfiguration(), name);
        return value != null ? value : defaultValue;
    }

    private static String getElementValue(Xpp3Dom config, String name) {
        Xpp3Dom child = OsgiSourceMojo.getConfigurationElement(config, name);
        return child == null ? null : child.getValue();
    }

    private static Xpp3Dom getConfigurationElement(Xpp3Dom config, String name) {
        return config == null ? null : config.getChild(name);
    }
}

