/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ITraceToBytecodeInstaller;
import org.eclipse.xtext.generator.trace.LineMappingProvider;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class TraceAsPrimarySourceInstaller
implements ITraceToBytecodeInstaller {
    private boolean hideSyntheticVariables;
    @Inject
    private LineMappingProvider lineMappingProvider;
    protected AbstractTraceRegion trace;

    protected int[] getTargetToSourceLineMapping(AbstractTraceRegion rootTraceRegion) {
        List<LineMappingProvider.LineMapping> lineInfo = this.lineMappingProvider.getLineMapping(rootTraceRegion);
        if (lineInfo == null) {
            return null;
        }
        int maxLineEnd = 0;
        for (LineMappingProvider.LineMapping lineMapping : lineInfo) {
            if (maxLineEnd >= lineMapping.targetEndLine) continue;
            maxLineEnd = lineMapping.targetEndLine;
        }
        int[] target2source = new int[maxLineEnd + 2];
        Arrays.fill(target2source, -1);
        for (LineMappingProvider.LineMapping lineMapping : lineInfo) {
            for (int targetLine = lineMapping.targetStartLine + 1; targetLine <= lineMapping.targetEndLine + 1; ++targetLine) {
                int startLine = lineMapping.sourceStartLine;
                if (target2source[targetLine] != -1 && startLine >= target2source[targetLine]) continue;
                target2source[targetLine] = startLine;
            }
        }
        return target2source;
    }

    @Override
    public byte[] installTrace(byte[] javaClassBytecode) throws IOException {
        if (this.trace == null) {
            return null;
        }
        SourceRelativeURI associatedPath = this.trace.getAssociatedSrcRelativePath();
        if (associatedPath == null) {
            return null;
        }
        ClassReader reader = new ClassReader(javaClassBytecode);
        ClassWriter writer = new ClassWriter(0);
        String sourceFileName = associatedPath.getURI().lastSegment();
        int[] target2source = this.getTargetToSourceLineMapping(this.trace);
        XtextClassAdapter adapter = new XtextClassAdapter((ClassVisitor)writer, sourceFileName, target2source, this.hideSyntheticVariables);
        reader.accept((ClassVisitor)adapter, 0);
        return writer.toByteArray();
    }

    public boolean isHideSyntheticVariables() {
        return this.hideSyntheticVariables;
    }

    public void setHideSyntheticVariables(boolean hideSyntheticVariables) {
        this.hideSyntheticVariables = hideSyntheticVariables;
    }

    @Override
    public void setTrace(String javaFileName, AbstractTraceRegion trace) {
        this.trace = trace;
    }

    public static class XtextMethodAdapter
    extends MethodVisitor {
        private XtextClassAdapter context;

        public XtextMethodAdapter(XtextClassAdapter context, MethodVisitor delegate) {
            super(327680, delegate);
            this.context = context;
        }

        public XtextClassAdapter getContext() {
            return this.context;
        }

        public void visitLineNumber(int line, Label start) {
            int[] target2source = this.context.getTarget2source();
            if (target2source == null || line < 0 || line >= target2source.length) {
                return;
            }
            int sourceLine = target2source[line];
            if (sourceLine >= 0) {
                super.visitLineNumber(sourceLine, start);
            }
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            if (this.context.isHideSyntheticVariables()) {
                boolean isMethodParameter = start.getOffset() == 0;
                boolean isSynthetic = name.startsWith("_");
                if (isMethodParameter || !isSynthetic) {
                    super.visitLocalVariable(name, desc, signature, start, end, index);
                }
            } else {
                super.visitLocalVariable(name, desc, signature, start, end, index);
            }
        }
    }

    public static class XtextClassAdapter
    extends ClassVisitor {
        private final boolean hideSyntheticVariables;
        private final String sourceFile;
        private final int[] target2source;

        public XtextClassAdapter(ClassVisitor cv, String sourceFile, int[] target2source, boolean hideSyntheticVariables) {
            super(327680, cv);
            this.sourceFile = sourceFile;
            this.target2source = target2source;
            this.hideSyntheticVariables = hideSyntheticVariables;
        }

        public String getSourceFile() {
            return this.sourceFile;
        }

        public int[] getTarget2source() {
            return this.target2source;
        }

        public boolean isHideSyntheticVariables() {
            return this.hideSyntheticVariables;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new XtextMethodAdapter(this, super.visitMethod(access, name, desc, signature, exceptions));
        }

        public void visitSource(String source, String debug) {
            super.visitSource(this.sourceFile, debug);
        }
    }
}

