/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsian.swt.internal.composer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipsian.swt.internal.composer.DOMSerializerHelper;
import org.eclipsian.swt.internal.composer.MozillaEnvironment;
import org.eclipsian.swt.internal.composer.NodeImpl;
import org.eclipsian.swt.internal.composer.PersonalDictionaryHelper;
import org.eclipsian.swt.internal.composer.TooltipTextProviderHelper;
import org.eclipsian.swt.internal.composer.URIResolveHelper;
import org.eclipsian.swt.internal.composer.Util;
import org.eclipsian.swt.internal.mozilla.XPCOM;
import org.eclipsian.swt.internal.mozilla.nsEmbedString;
import org.eclipsian.swt.internal.mozilla.nsIAppShell;
import org.eclipsian.swt.internal.mozilla.nsIComponentManager;
import org.eclipsian.swt.internal.mozilla.nsILocalFile;
import org.eclipsian.swt.internal.mozilla.nsIPrefBranch;
import org.eclipsian.swt.internal.mozilla.nsIPrefService;
import org.eclipsian.swt.internal.mozilla.nsIServiceManager;
import org.eclipsian.swt.internal.ws.WebStart;
import org.w3c.dom.Node;

final class MozillaEmbed {
    private static boolean DEBUG = false;
    private static boolean WEBSTART = true;
    protected static boolean ENABLE_HTML_MODIFICATIONS = true;
    private static final String UNPACK_REQUIRED_ENTRY = "components";
    private static final String PREF_SPELLCHECKER_ENABLEREALTIMESPELL = "spellchecker.enablerealtimespell";
    private static final String PREF_SPELLCHECKER_DICTIONARY = "spellchecker.dictionary";
    private static final String PREF_BIDI_DIRECTION = "bidi.direction";
    private static final String PREF_PRINT_SHOW_PROGRESS = "print.show_print_progress";
    private static nsIAppShell appShell;
    private static String mozillaPath;
    private static DOMSerializerHelper domSerializer;
    private static int loadCount;
    private static URI blankURI;

    static {
        mozillaPath = null;
        domSerializer = null;
        loadCount = 0;
        blankURI = null;
    }

    private MozillaEmbed() {
    }

    public static void load() {
        if (loadCount == 0) {
            MozillaEmbed.spinup();
        }
        ++loadCount;
    }

    public static void unload() {
        if (--loadCount == 0) {
            MozillaEmbed.spindown();
        }
    }

    public static URI getBlankURI() {
        if (blankURI == null) {
            blankURI = new File(mozillaPath, "blank.html").toURI();
        }
        return blankURI;
    }

    public static URI getSpellURI() {
        return new File(new File(mozillaPath, UNPACK_REQUIRED_ENTRY), "myspell").toURI();
    }

    public static void setBidi(int n) {
        int[] nArray = new int[1];
        nsIPrefService nsIPrefService2 = MozillaEmbed.getPrefService();
        int n2 = nsIPrefService2.GetBranch(null, nArray);
        if (n2 != 0) {
            MozillaEmbed.doError(n2);
        }
        if (nArray[0] != 0) {
            nsIPrefBranch nsIPrefBranch2 = new nsIPrefBranch(nArray[0]);
            n2 = nsIPrefBranch2.SetIntPref(Util.getNSString(PREF_BIDI_DIRECTION), (n & 0x2000000) != 0 ? 1 : 2);
            if (n2 != 0) {
                MozillaEmbed.doError(n2);
            }
            nsIPrefBranch2.Release();
        }
        nsIPrefService2.Release();
    }

    private static void spinup() {
        try {
            mozillaPath = MozillaEnvironment.getMozillaPath();
            if (mozillaPath == null) {
                throw new FileNotFoundException();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            SWT.error((int)2, null, (String)" [Unknown path]");
        }
        File file = new File(mozillaPath, "components/libwidget_gtk.so");
        if (file.exists()) {
            SWT.error((int)2, null, (String)" [Mozilla GTK2 required (GTK1.2 detected)]");
        }
        try {
            MozillaEnvironment.loadLibraries();
            System.loadLibrary("composer-mozilla");
            if (WEBSTART && WebStart.detect()) {
                if (!WebStart.unpack(mozillaPath)) {
                    MozillaEmbed.doError(0, " [WebStart unpack failed " + mozillaPath + "]");
                }
            } else if (!MozillaEmbed.unpack(mozillaPath)) {
                MozillaEmbed.doError(0, " [Unpack failed " + mozillaPath + "]");
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            SWT.error((int)2, (Throwable)unsatisfiedLinkError);
        }
        int[] nArray = new int[1];
        nsEmbedString nsEmbedString2 = new nsEmbedString(mozillaPath);
        int n = XPCOM.NS_NewLocalFile(nsEmbedString2.getAddress(), true, nArray);
        nsEmbedString2.dispose();
        if (n != 0) {
            MozillaEmbed.doError(n);
        }
        if (nArray[0] == 0) {
            MozillaEmbed.doError(-2147467261);
        }
        nsILocalFile nsILocalFile2 = new nsILocalFile(nArray[0]);
        n = XPCOM.NS_InitEmbedding(nsILocalFile2.getAddress(), 0);
        nsILocalFile2.Release();
        if (n != 0) {
            MozillaEmbed.doError(n, " [NS_InitEmbedding " + mozillaPath + " error " + n + "]");
        }
        if ((n = XPCOM.NS_GetComponentManager(nArray)) != 0) {
            MozillaEmbed.doError(n);
        }
        if (nArray[0] == 0) {
            MozillaEmbed.doError(-2147467262);
        }
        nsIComponentManager nsIComponentManager2 = new nsIComponentManager(nArray[0]);
        nArray[0] = 0;
        n = nsIComponentManager2.CreateInstance(XPCOM.NS_APPSHELL_CID, 0, nsIAppShell.NS_IAPPSHELL_IID, nArray);
        if (n != 0) {
            MozillaEmbed.doError(n);
        }
        if (nArray[0] == 0) {
            MozillaEmbed.doError(-2147467262);
        }
        nsIComponentManager2.Release();
        appShell = new nsIAppShell(nArray[0]);
        n = appShell.Create(0, null);
        if (n != 0) {
            MozillaEmbed.doError(n);
        }
        if ((n = appShell.Spinup()) != 0) {
            MozillaEmbed.doError(n);
        }
        URIResolveHelper.register(new File(mozillaPath, "res").toURI(), new File(mozillaPath).toURI());
        TooltipTextProviderHelper.register();
        PersonalDictionaryHelper.register();
        nsIPrefService nsIPrefService2 = MozillaEmbed.getPrefService();
        n = nsIPrefService2.GetBranch(null, nArray);
        if (n != 0) {
            MozillaEmbed.doError(n);
        }
        if (nArray[0] != 0) {
            nsIPrefBranch nsIPrefBranch2 = new nsIPrefBranch(nArray[0]);
            n = nsIPrefBranch2.SetBoolPref(Util.getNSString(PREF_SPELLCHECKER_ENABLEREALTIMESPELL), true);
            if (n != 0) {
                MozillaEmbed.doError(n);
            }
            if ((n = nsIPrefBranch2.SetCharPref(Util.getNSString(PREF_SPELLCHECKER_DICTIONARY), Util.getNSString("en_US"))) != 0) {
                MozillaEmbed.doError(n);
            }
            if ((n = nsIPrefBranch2.SetBoolPref(Util.getNSString(PREF_PRINT_SHOW_PROGRESS), false)) != 0) {
                MozillaEmbed.doError(n);
            }
            nsIPrefBranch2.Release();
        }
        nsIPrefService2.Release();
        ++loadCount;
    }

    private static void spindown() {
        TooltipTextProviderHelper.Release();
        PersonalDictionaryHelper.Release();
        URIResolveHelper.Release();
        if (domSerializer != null) {
            domSerializer.Release();
            domSerializer = null;
        }
    }

    private static boolean unpack(String string) {
        File file = new File(string);
        return new File(file, UNPACK_REQUIRED_ENTRY).exists();
    }

    protected static void extract(ZipFile zipFile, File file, String string) throws IOException {
        Object object;
        Object object2;
        Object object3 = zipFile.entries();
        while (object3.hasMoreElements()) {
            ZipEntry zipEntry = object3.nextElement();
            object2 = zipEntry.getName();
            if (!((String)object2).startsWith(string)) continue;
            object = new File(file, ((String)object2).substring(string.length()));
            if (!zipEntry.isDirectory() || ((File)object).exists()) continue;
            ((File)object).mkdirs();
        }
        object3 = new byte[65536];
        object2 = zipFile.entries();
        while (object2.hasMoreElements()) {
            int n;
            object = (ZipEntry)object2.nextElement();
            String string2 = ((ZipEntry)object).getName();
            if (!string2.startsWith(string)) continue;
            File file2 = new File(file, string2.substring(string.length()));
            if (((ZipEntry)object).isDirectory() || file2.exists() || !file2.createNewFile()) continue;
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            InputStream inputStream = zipFile.getInputStream((ZipEntry)object);
            while ((n = inputStream.read((byte[])object3)) > 0) {
                ((OutputStream)fileOutputStream).write((byte[])object3, 0, n);
            }
            inputStream.close();
            ((OutputStream)fileOutputStream).close();
        }
    }

    private static nsIPrefService getPrefService() {
        int[] nArray = new int[1];
        int n = XPCOM.NS_GetServiceManager(nArray);
        if (n != 0) {
            MozillaEmbed.doError(n);
        }
        if (nArray[0] == 0) {
            MozillaEmbed.doError(-2147467262);
        }
        nsIServiceManager nsIServiceManager2 = new nsIServiceManager(nArray[0]);
        nArray[0] = 0;
        n = nsIServiceManager2.GetService(XPCOM.NS_PREFSERVICE_CID, nsIPrefService.NS_IPREFSERVICE_IID, nArray);
        if (n != 0) {
            MozillaEmbed.doError(n);
        }
        if (nArray[0] == 0) {
            MozillaEmbed.doError(-2147467262);
        }
        nsIServiceManager2.Release();
        return new nsIPrefService(nArray[0]);
    }

    protected static String serializeNode(Node node) {
        if (domSerializer == null) {
            domSerializer = new DOMSerializerHelper();
        }
        return domSerializer.serializeToString(((NodeImpl)node).node);
    }

    public static void doError(int n) {
        MozillaEmbed.doError(n, null);
    }

    public static void doError(int n, boolean bl) {
        if (bl) {
            MozillaEmbed.doError(n, null);
        }
    }

    public static void doError(int n, String string) {
        try {
            SWT.error((int)2, null, (String)("XPCOM error #" + Long.toHexString((long)n << 32 >>> 32) + ":" + string));
        }
        catch (SWTError sWTError) {
            sWTError.printStackTrace();
            throw sWTError;
        }
    }

    public static void doWarning(String string) {
        if (DEBUG) {
            System.err.println(string);
        }
    }
}

