/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsian.swt.internal.composer;

import org.eclipsian.swt.internal.OS;
import org.eclipsian.swt.internal.composer.URIResolveHelper;
import org.eclipsian.swt.internal.mozilla.XPCOM;
import org.eclipsian.swt.internal.mozilla.XPCOMObject;
import org.eclipsian.swt.internal.mozilla.nsID;
import org.eclipsian.swt.internal.mozilla.nsIFileProtocolHandler;
import org.eclipsian.swt.internal.mozilla.nsIProtocolHandler;
import org.eclipsian.swt.internal.mozilla.nsISupportsWeakReference;
import org.eclipsian.swt.internal.mozilla.nsIURI;
import org.eclipsian.swt.internal.mozilla.nsIWeakReference;

public class ProtocolHandler {
    private XPCOMObject supportsWeakReference;
    private XPCOMObject weakReference;
    private XPCOMObject protocol;
    private int refCount = 0;
    private nsIProtocolHandler protocolHandler;
    private nsIFileProtocolHandler fileProtocolHandler;
    private boolean fileChecked;

    ProtocolHandler(nsIProtocolHandler nsIProtocolHandler2) {
        this.createCOMInterfaces();
        this.protocolHandler = nsIProtocolHandler2;
    }

    void createCOMInterfaces() {
        int[] nArray = new int[4];
        nArray[0] = 2;
        nArray[3] = 1;
        this.supportsWeakReference = new XPCOMObject(nArray){

            public int method0(int[] nArray) {
                return ProtocolHandler.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return ProtocolHandler.this.AddRef();
            }

            public int method2(int[] nArray) {
                return ProtocolHandler.this.Release();
            }

            public int method3(int[] nArray) {
                return ProtocolHandler.this.GetWeakReference(nArray[0]);
            }
        };
        int[] nArray2 = new int[4];
        nArray2[0] = 2;
        nArray2[3] = 2;
        this.weakReference = new XPCOMObject(nArray2){

            public int method0(int[] nArray) {
                return ProtocolHandler.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return ProtocolHandler.this.AddRef();
            }

            public int method2(int[] nArray) {
                return ProtocolHandler.this.Release();
            }

            public int method3(int[] nArray) {
                return ProtocolHandler.this.QueryReferent(nArray[0], nArray[1]);
            }
        };
        int[] nArray3 = new int[12];
        nArray3[0] = 2;
        nArray3[3] = 1;
        nArray3[4] = 1;
        nArray3[5] = 1;
        nArray3[6] = 4;
        nArray3[7] = 2;
        nArray3[8] = 3;
        nArray3[9] = 2;
        nArray3[10] = 2;
        nArray3[11] = 2;
        this.protocol = new XPCOMObject(nArray3){

            public int method0(int[] nArray) {
                return ProtocolHandler.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return ProtocolHandler.this.AddRef();
            }

            public int method2(int[] nArray) {
                return ProtocolHandler.this.Release();
            }

            public int method3(int[] nArray) {
                return ProtocolHandler.this.GetScheme(nArray[0]);
            }

            public int method4(int[] nArray) {
                return ProtocolHandler.this.GetDefaultPort(nArray[0]);
            }

            public int method5(int[] nArray) {
                return ProtocolHandler.this.GetProtocolFlags(nArray[0]);
            }

            public int method6(int[] nArray) {
                return ProtocolHandler.this.NewURI(nArray[0], nArray[1], nArray[2], nArray[3]);
            }

            public int method7(int[] nArray) {
                return ProtocolHandler.this.NewChannel(nArray[0], nArray[1]);
            }

            public int method8(int[] nArray) {
                return ProtocolHandler.this.AllowPort(nArray[0], nArray[1], nArray[2]);
            }

            public int method9(int[] nArray) {
                return ProtocolHandler.this.NewFileURI(nArray[0], nArray[1]);
            }

            public int method10(int[] nArray) {
                return ProtocolHandler.this.GetURLSpecFromFile(nArray[0], nArray[1]);
            }

            public int method11(int[] nArray) {
                return ProtocolHandler.this.GetFileFromURLSpec(nArray[0], nArray[1]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.protocol != null) {
            this.protocol.dispose();
            this.protocol = null;
        }
        if (this.weakReference != null) {
            this.weakReference.dispose();
            this.weakReference = null;
        }
        if (this.supportsWeakReference != null) {
            this.supportsWeakReference.dispose();
            this.supportsWeakReference = null;
        }
        if (this.fileProtocolHandler != null) {
            this.fileProtocolHandler.Release();
            this.fileProtocolHandler = null;
        }
    }

    int getAddress() {
        return this.protocol.getAddress();
    }

    int QueryInterface(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return -2147467262;
        }
        nsID nsID2 = new nsID();
        XPCOM.memmove(nsID2, n, 16);
        if (nsID2.Equals(nsISupportsWeakReference.NS_ISUPPORTSWEAKREFERENCE_IID)) {
            XPCOM.memmove(n2, new int[]{this.supportsWeakReference.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (nsID2.Equals(nsIWeakReference.NS_IWEAKREFERENCE_IID)) {
            XPCOM.memmove(n2, new int[]{this.weakReference.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (nsID2.Equals(nsIProtocolHandler.NS_IPROTOCOLHANDLER_IID)) {
            XPCOM.memmove(n2, new int[]{this.protocol.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (nsID2.Equals(nsIFileProtocolHandler.NS_IFILEPROTOCOLHANDLER_IID)) {
            if (!this.fileChecked) {
                this.fileChecked = true;
                int[] nArray = new int[1];
                int n3 = this.protocolHandler.QueryInterface(nsIFileProtocolHandler.NS_IFILEPROTOCOLHANDLER_IID, nArray);
                if (n3 == 0) {
                    this.fileProtocolHandler = new nsIFileProtocolHandler(nArray[0]);
                }
            }
            if (this.fileProtocolHandler != null) {
                XPCOM.memmove(n2, new int[]{this.protocol.getAddress()}, OS.PTR_SIZEOF);
                this.AddRef();
                return 0;
            }
        }
        XPCOM.memmove(n2, new int[1], OS.PTR_SIZEOF);
        return -2147467262;
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int QueryReferent(int n, int n2) {
        return this.QueryInterface(n, n2);
    }

    int GetWeakReference(int n) {
        XPCOM.memmove(n, new int[]{this.weakReference.getAddress()}, OS.PTR_SIZEOF);
        this.AddRef();
        return 0;
    }

    int GetScheme(int n) {
        return this.protocolHandler.getScheme(n);
    }

    int GetDefaultPort(int n) {
        int[] nArray = new int[1];
        int n2 = this.protocolHandler.getDefaultPort(nArray);
        XPCOM.memmove(n, nArray, 4);
        return n2;
    }

    int GetProtocolFlags(int n) {
        int[] nArray = new int[1];
        int n2 = this.protocolHandler.getProtocolFlags(nArray);
        XPCOM.memmove(n, nArray, 4);
        return n2;
    }

    int NewURI(int n, int n2, int n3, int n4) {
        byte[] byArray = null;
        if (n2 != 0) {
            byArray = new byte[XPCOM.strlen(n2) + 1];
            XPCOM.memmove(byArray, n2, byArray.length);
        }
        int[] nArray = new int[1];
        int n5 = this.protocolHandler.NewURI(n, byArray, n3, nArray);
        XPCOM.memmove(n4, nArray, OS.PTR_SIZEOF);
        return n5;
    }

    int NewChannel(int n, int n2) {
        int[] nArray = new int[1];
        int n3 = URIResolveHelper.newChannel(new nsIURI(n), nArray);
        if (n3 != 0) {
            n3 = this.protocolHandler.NewChannel(n, nArray);
        }
        XPCOM.memmove(n2, nArray, OS.PTR_SIZEOF);
        return n3;
    }

    int AllowPort(int n, int n2, int n3) {
        boolean[] blArray = new boolean[1];
        byte[] byArray = new byte[XPCOM.nsEmbedCString_Length(n2)];
        XPCOM.memmove(byArray, XPCOM.nsEmbedCString_get(n2), byArray.length);
        int n4 = this.protocolHandler.AllowPort(n, byArray, blArray);
        XPCOM.memmove(n3, new int[]{blArray[0] ? 1 : 0}, 4);
        return n4;
    }

    int NewFileURI(int n, int n2) {
        int[] nArray = new int[1];
        int n3 = this.fileProtocolHandler.NewFileURI(n, nArray);
        XPCOM.memmove(n2, nArray, OS.PTR_SIZEOF);
        return n3;
    }

    int GetURLSpecFromFile(int n, int n2) {
        int n3 = this.fileProtocolHandler.GetURLSpecFromFile(n, n2);
        return n3;
    }

    int GetFileFromURLSpec(int n, int n2) {
        int[] nArray = new int[1];
        int n3 = this.fileProtocolHandler.GetFileFromURLSpec(n, nArray);
        XPCOM.memmove(n2, nArray, OS.PTR_SIZEOF);
        return n3;
    }
}

