/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsian.swt.internal.composer;

import org.eclipsian.swt.composer.ISelection;
import org.eclipsian.swt.internal.composer.GeckoEditor;
import org.eclipsian.swt.internal.composer.MozillaEmbed;
import org.eclipsian.swt.internal.composer.NodeImpl;
import org.eclipsian.swt.internal.composer.RangeImpl;
import org.eclipsian.swt.internal.composer.Util;
import org.eclipsian.swt.internal.composer.dom.ElementCreator;
import org.eclipsian.swt.internal.mozilla.nsIDOMNode;
import org.eclipsian.swt.internal.mozilla.nsIDOMRange;
import org.eclipsian.swt.internal.mozilla.nsISelection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.Range;

final class SelectionImpl
implements ISelection {
    private GeckoEditor editor;
    private nsISelection selection;

    SelectionImpl(GeckoEditor geckoEditor, nsISelection nsISelection2) {
        this.selection = nsISelection2;
        this.editor = geckoEditor;
    }

    public boolean equals(Object object) {
        if (object instanceof SelectionImpl) {
            return this.selection.getAddress() == ((SelectionImpl)object).selection.getAddress();
        }
        return super.equals(object);
    }

    public int hashCode() {
        return this.selection.getAddress();
    }

    public String toString() {
        int[] nArray = new int[1];
        int n = this.selection.ToString(nArray);
        if (n != 0) {
            MozillaEmbed.doWarning("Selection:toString() error=" + n);
            return null;
        }
        if (nArray[0] == 0) {
            return null;
        }
        return Util.getWString(nArray[0]);
    }

    public Node getAnchorNode() {
        int[] nArray = new int[1];
        int n = this.selection.getAnchorNode(nArray);
        if (n != 0) {
            throw new DOMException(15, "call failed");
        }
        if (nArray[0] == 0) {
            return null;
        }
        return ElementCreator.createElement(new NodeImpl(this.editor, new nsIDOMNode(nArray[0])));
    }

    public int getAnchorOffset() {
        int[] nArray = new int[1];
        int n = this.selection.getAnchorOffset(nArray);
        if (n != 0) {
            throw new DOMException(15, "call failed");
        }
        return nArray[0];
    }

    public Node getFocusNode() {
        int[] nArray = new int[1];
        int n = this.selection.getFocusNode(nArray);
        if (n != 0) {
            throw new DOMException(15, "call failed");
        }
        if (nArray[0] == 0) {
            return null;
        }
        return ElementCreator.createElement(new NodeImpl(this.editor, new nsIDOMNode(nArray[0])));
    }

    public int getFocusOffset() {
        int[] nArray = new int[1];
        int n = this.selection.getFocusOffset(nArray);
        if (n != 0) {
            throw new DOMException(15, "call failed");
        }
        return nArray[0];
    }

    public boolean isCollapsed() {
        boolean[] blArray = new boolean[1];
        int n = this.selection.getIsCollapsed(blArray);
        if (n != 0) {
            throw new DOMException(15, "call failed");
        }
        return blArray[0];
    }

    public int rangeCount() {
        int[] nArray = new int[1];
        int n = this.selection.getRangeCount(nArray);
        if (n != 0) {
            throw new DOMException(15, "call failed");
        }
        return nArray[0];
    }

    public Range getRangeAt(int n) {
        int[] nArray = new int[1];
        int n2 = this.selection.GetRangeAt(n, nArray);
        if (n2 != 0 || nArray[0] == 0) {
            throw new DOMException(15, "call failed");
        }
        return new RangeImpl(this.editor, new nsIDOMRange(nArray[0]));
    }

    public void collapse(Node node, int n) {
        int n2 = this.selection.Collapse(((NodeImpl)node).node.getAddress(), n);
        if (n2 != 0) {
            throw new DOMException(15, "call failed");
        }
    }

    public void extend(Node node, int n) {
        int n2 = this.selection.Extend(((NodeImpl)node).node.getAddress(), n);
        if (n2 != 0) {
            throw new DOMException(15, "call failed");
        }
    }

    public void collapseToStart() {
        int n = this.selection.CollapseToStart();
        if (n != 0) {
            throw new DOMException(15, "call failed");
        }
    }

    public void collapseToEnd() {
        int n = this.selection.CollapseToEnd();
        if (n != 0) {
            throw new DOMException(15, "call failed");
        }
    }

    public boolean containsNode(Node node, boolean bl) {
        boolean[] blArray = new boolean[1];
        int n = this.selection.ContainsNode(((NodeImpl)node).node.getAddress(), bl, blArray);
        if (n != 0) {
            throw new DOMException(15, "call failed");
        }
        return blArray[0];
    }

    public void selectAllChildren(Node node) {
        int n = this.selection.SelectAllChildren(((NodeImpl)node).node.getAddress());
        if (n != 0) {
            throw new DOMException(15, "call failed");
        }
    }

    public void addRange(Range range) {
        int n = this.selection.AddRange(((RangeImpl)range).range.getAddress());
        if (n != 0) {
            throw new DOMException(15, "call failed");
        }
    }

    public void removeRange(Range range) {
        int n = this.selection.RemoveRange(((RangeImpl)range).range.getAddress());
        if (n != 0) {
            throw new DOMException(15, "call failed");
        }
    }

    public void removeAllRanges() {
        int n = this.selection.RemoveAllRanges();
        if (n != 0) {
            throw new DOMException(15, "call failed");
        }
    }

    public void deleteFromDocument() {
        int n = this.selection.DeleteFromDocument();
        if (n != 0) {
            throw new DOMException(15, "call failed");
        }
    }

    public void insertElement(Element element, boolean bl) {
        this.editor.insertElementAtSelection(element, bl);
    }

    public void selectElement(Element element) {
        this.editor.selectElement(element);
    }

    public void pasteHTML(String string) {
        this.editor.pasteHTML(string);
    }

    public Element getSelectionContainer() {
        return this.editor.getSelectionContainer();
    }

    public void setCaretAfterElement(Element element) {
        this.editor.setCaretAfterElement(element);
    }

    void Release() {
        this.selection.Release();
    }

    public void scrollSelectionIntoView(boolean bl) {
        this.editor.scrollSelectionIntoView(bl);
    }

    public void beginningOfDocument() {
        this.editor.beginningOfDocument();
    }

    public void endOfDocument() {
        this.editor.endOfDocument();
    }

    public Element getResizedElement() {
        return this.editor.getResizedElement();
    }

    public Element getSingleCellSelection() {
        return this.editor.getSingleCellSelection();
    }
}

