/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsian.composer.ui.viewers;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipsian.composer.ui.viewers.HTMLViewer;
import org.eclipsian.composer.ui.viewers.IDocument;
import org.eclipsian.composer.ui.viewers.IDocumentListener;

public class Document
implements IDocument {
    private String content;
    private boolean dirty;
    private ListenerList listeners = new ListenerList();
    private HTMLViewer viewer;

    public Document() {
        this("");
    }

    public Document(String string) {
        this.content = string;
    }

    public String get() {
        if (this.dirty && this.viewer != null) {
            this.dirty = false;
            this.content = this.viewer.getContentAndResetDirty();
        }
        return this.content;
    }

    public void set(String string) {
        this.dirty = false;
        this.content = string;
        if (this.viewer != null) {
            this.viewer.onDocumentContentChanged();
        }
    }

    public void addDocumentListener(IDocumentListener iDocumentListener) {
        this.listeners.add((Object)iDocumentListener);
    }

    public void removeDocumentListener(IDocumentListener iDocumentListener) {
        this.listeners.remove((Object)iDocumentListener);
    }

    public boolean isModified() {
        return this.dirty;
    }

    void setViewer(HTMLViewer hTMLViewer) {
        this.viewer = hTMLViewer;
    }

    void fireContentModified() {
        this.dirty = true;
        Object[] objectArray = this.listeners.getListeners();
        final Document document = this;
        int n = 0;
        while (n < objectArray.length) {
            final IDocumentListener iDocumentListener = (IDocumentListener)objectArray[n];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    iDocumentListener.documentChanged(document);
                }
            });
            ++n;
        }
    }

    String getContent() {
        return this.content;
    }
}

