/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsian.composer.ui.viewers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipsian.composer.internal.ui.spell.SpellCheckManager;
import org.eclipsian.composer.ui.spell.ISpellCheckManager;
import org.eclipsian.composer.ui.viewers.Document;
import org.eclipsian.composer.ui.viewers.HTMLSelection;
import org.eclipsian.composer.ui.viewers.IDocument;
import org.eclipsian.composer.ui.viewers.IHTMLEditor;
import org.eclipsian.composer.ui.viewers.IHTMLSelection;
import org.eclipsian.swt.composer.EditorCommand;
import org.eclipsian.swt.composer.HyperComposer;
import org.eclipsian.swt.composer.IDocumentStateListener;
import org.eclipsian.swt.composer.ISelection;
import org.eclipsian.swt.composer.ISelectionListener;
import org.w3c.dom.Element;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.html.HTMLAnchorElement;
import org.w3c.dom.html.HTMLDocument;

public class HTMLViewer
extends Viewer
implements IHTMLEditor {
    private static Map commands = new HashMap(32);
    private HyperComposer control;
    private Document document;
    private IHTMLSelection selection;
    private Map stylesheets = new HashMap();
    private ISpellCheckManager spellManager;

    static {
        commands.put("bold", HyperComposer.CMD_BOLD);
        commands.put("italic", HyperComposer.CMD_ITALIC);
        commands.put("underline", HyperComposer.CMD_UNDERLINE);
        commands.put("strikethrough", HyperComposer.CMD_STRIKETHROUGH);
        commands.put("undo", HyperComposer.CMD_UNDO);
        commands.put("redo", HyperComposer.CMD_REDO);
        commands.put("cut", HyperComposer.CMD_CUT);
        commands.put("copy", HyperComposer.CMD_COPY);
        commands.put("paste", HyperComposer.CMD_PASTE);
        commands.put("delete", HyperComposer.CMD_DELETE);
        commands.put("selectAll", HyperComposer.CMD_SELECTALL);
        commands.put("alignWidth", HyperComposer.CMD_JUSTIFYWIDTH);
        commands.put("alignRight", HyperComposer.CMD_JUSTIFYRIGHT);
        commands.put("alignCenter", HyperComposer.CMD_JUSTIFYCENTER);
        commands.put("alignLeft", HyperComposer.CMD_JUSTIFYLEFT);
        commands.put("indent", HyperComposer.CMD_INDENT);
        commands.put("outdent", HyperComposer.CMD_OUTDENT);
        commands.put("bullets", HyperComposer.CMD_UNORDERLIST);
        commands.put("numbering", HyperComposer.CMD_ORDERLIST);
        commands.put("subscript", HyperComposer.CMD_SUBSCRIPT);
        commands.put("superscript", HyperComposer.CMD_SUPERSCRIPT);
        commands.put("fontIncrease", HyperComposer.CMD_INCREASEFONT);
        commands.put("fontDecrease", HyperComposer.CMD_DECREASEFONT);
        commands.put("nextWord", HyperComposer.CMD_WORD_NEXT);
        commands.put("previousWord", HyperComposer.CMD_WORD_PREVIOUS);
        commands.put("selectNextWord", HyperComposer.CMD_SELECT_WORD_NEXT);
        commands.put("selectPreviousWord", HyperComposer.CMD_SELECT_WORD_PREVIOUS);
        commands.put("absPosition", HyperComposer.CMD_ABSPOS);
        commands.put("bringFront", HyperComposer.CMD_BRINGFRONT);
        commands.put("sendBack", HyperComposer.CMD_SENDBACK);
        commands.put("deleteWordBackward", HyperComposer.DELETE_WORD_BACKWARD);
        commands.put("deleteWordForward", HyperComposer.DELETE_WORD_FORWARD);
        commands.put("deleteToLineBeginning", HyperComposer.DELETE_TO_BEGINING_OF_LINE);
        commands.put("deleteToLineEnd", HyperComposer.DELETE_TO_END_OF_LINE);
        commands.put("moveTop", HyperComposer.MOVE_TOP);
        commands.put("moveBottom", HyperComposer.MOVE_BOTTOM);
        commands.put("selectTop", HyperComposer.SELECT_TOP);
        commands.put("selectBottom", HyperComposer.SELECT_BOTTOM);
        commands.put("lineNext", HyperComposer.LINE_NEXT);
        commands.put("linePrevious", HyperComposer.LINE_PREVIOUS);
        commands.put("selectLineNext", HyperComposer.SELECT_LINE_NEXT);
        commands.put("selectLinePrevious", HyperComposer.SELECT_LINE_PREVIOUS);
        commands.put("moveToLineBeginning", HyperComposer.MOVE_TO_BEGINING_OF_LINE);
        commands.put("moveToLineEnd", HyperComposer.MOVE_TO_END_OF_LINE);
        commands.put("selectToLineBeginning", HyperComposer.SELECT_TO_BEGINING_OF_LINE);
        commands.put("selectToLineEnd", HyperComposer.SELECT_TO_END_OF_LINE);
    }

    public HTMLViewer(Composite composite, int n) {
        this(new HyperComposer(composite, n));
    }

    public HTMLViewer(HyperComposer hyperComposer) {
        this.control = hyperComposer;
        hyperComposer.setFlavour("use_css");
        this.hookControl(hyperComposer);
    }

    protected void hookControl(HyperComposer hyperComposer) {
        hyperComposer.addDocumentStateListener(new IDocumentStateListener(){

            public void documentCreated() {
            }

            public void documentModified() {
                HTMLViewer.this.fireContentModified();
            }
        });
        hyperComposer.addSelectionListener(new ISelectionListener(){

            public void selectionChanged(ISelection iSelection) {
                HTMLViewer.this.handleSelectionChanged(iSelection);
            }
        });
    }

    public Control getControl() {
        return this.control;
    }

    public Object getInput() {
        return this.document;
    }

    public org.eclipse.jface.viewers.ISelection getSelection() {
        return this.getHTMLSelection();
    }

    public IHTMLSelection getHTMLSelection() {
        if (this.selection == null) {
            this.selection = new HTMLSelection(this.control.getSelection());
        }
        return this.selection;
    }

    public void refresh() {
        System.out.println("TODO: HTMLViewer.refresh");
        this.handleSelectionChanged(this.control.getSelection());
    }

    public void setInput(Object object) {
        IDocument iDocument = null;
        if (object instanceof IDocument) {
            iDocument = (IDocument)object;
        }
        this.setDocument(iDocument);
    }

    public void setSelection(org.eclipse.jface.viewers.ISelection iSelection, boolean bl) {
        if (iSelection instanceof HTMLSelection) {
            Element element = ((HTMLSelection)iSelection).getContainer();
            if (element != null) {
                this.control.getSelection().selectElement(element);
            } else {
                System.out.println("TODO: HTMLViewer.setSelection");
            }
        }
    }

    public IDocument getDocument() {
        return this.document;
    }

    public void setDocument(IDocument iDocument) {
        if (!(iDocument instanceof Document)) {
            throw new IllegalArgumentException("Invalid document");
        }
        Document document = this.document;
        Document document2 = (Document)iDocument;
        if (document != null) {
            document.setViewer(null);
        }
        this.document = document2;
        if (document2 != null) {
            document2.setViewer(this);
            this.control.setContent(document2.getContent());
        } else {
            this.control.setContent("");
        }
    }

    public void execCommand(String string) {
        EditorCommand editorCommand = (EditorCommand)commands.get(string);
        if (editorCommand != null) {
            this.control.execCommand(editorCommand);
        }
    }

    public String getBackgroundColor() {
        return this.control.getBackgroundColor();
    }

    public String getFontColor() {
        return this.control.getFontColor();
    }

    public String getHighlightColor() {
        return this.control.getHighlightColor();
    }

    public int queryCommandState(String string) {
        EditorCommand editorCommand = (EditorCommand)commands.get(string);
        if (editorCommand != null) {
            return this.control.queryCommandState(editorCommand);
        }
        return 0;
    }

    public void setBackgroundColor(String string) {
        this.control.setBackgroundColor(string);
    }

    public void setFontColor(String string) {
        this.control.setFontColor(string);
    }

    public void setHighlightColor(String string) {
        this.control.setHighlightColor(string);
    }

    public float getTextZoom() {
        return this.control.getTextZoom();
    }

    public void setTextZoom(float f) {
        this.control.setTextZoom(f);
    }

    public String getFontFace() {
        return this.control.getFontFace();
    }

    public String[] getFontList() {
        return this.control.getFontList();
    }

    public String getParagraphFormat() {
        return this.control.getParagraphFormat();
    }

    public void setFontFace(String string) {
        this.control.setFontFace(string);
    }

    public void setParagraphFormat(String string) {
        this.control.setParagraphFormat(string);
    }

    public void addOverrideStylesheet(String string, String string2) {
        this.stylesheets.put(string, string2);
        this.setOverrideStylesheets();
    }

    public void removeOverrideStylesheet(String string) {
        this.stylesheets.remove(string);
        this.setOverrideStylesheets();
    }

    private void setOverrideStylesheets() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.stylesheets.values().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next()).append('\n');
        }
        this.control.setOverrideStyleSheet(stringBuffer.toString());
    }

    public HTMLDocument getDOM() {
        return this.control.getDocument();
    }

    public void insertElementAtSelection(Element element) {
        this.control.getTransactionManager().insertElementAtSelection(element, true);
    }

    public void insertLinkAroundSelection(HTMLAnchorElement hTMLAnchorElement) {
        this.control.getTransactionManager().insertLinkAroundSelection(hTMLAnchorElement);
    }

    public Element createElement(String string) {
        String string2 = "";
        int n = string.indexOf(60);
        if (n >= 0 && (n = (string2 = string.substring(n + 1)).indexOf(32)) >= 0) {
            string2 = string2.substring(0, n);
        }
        return this.control.getTransactionManager().pasteHTMLAndReturnInsertedTag(string, string2.toUpperCase());
    }

    public void pasteHTML(String string) {
        this.control.getTransactionManager().pasteHTML(string);
    }

    public ISpellCheckManager getSpellCheckManager() {
        if (this.spellManager == null) {
            this.spellManager = new SpellCheckManager(this.control.getSpellCheck());
        }
        return this.spellManager;
    }

    public void addEventListener(EventListener eventListener) {
        this.control.addEventListener(eventListener);
    }

    public void removeEventListener(EventListener eventListener) {
        this.control.removeEventListener(eventListener);
    }

    private void fireContentModified() {
        if (this.document != null) {
            this.document.fireContentModified();
        }
    }

    String getContentAndResetDirty() {
        this.control.resetDirty();
        return this.control.getContent();
    }

    void onDocumentContentChanged() {
        this.control.setContent(this.document.getContent());
    }

    private void handleSelectionChanged(ISelection iSelection) {
        this.selection = new HTMLSelection(iSelection);
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, (org.eclipse.jface.viewers.ISelection)this.selection);
        this.fireSelectionChanged(selectionChangedEvent);
    }
}

