/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsian.swt.dnd;

import java.text.DecimalFormat;

public class HTMLClipboardFormat {
    private static final String VERSION = "Version:";
    private static final String START_HTML = "StartHTML:";
    private static final String END_HTML = "EndHTML:";
    private static final String START_FRAGMENT = "StartFragment:";
    private static final String END_FRAGMENT = "EndFragment:";
    private static final String SOURCE_URL = "SourceURL:";
    private static final String CRLF = "\r\n";
    private static final String REPLACE = "000000000";
    private static final String[] FORMAT;
    private static final DecimalFormat formater;
    private static final int HTML_START;
    private static final int FRAGMENT;
    private static final int HTML_END;
    private String begin;
    private String end;
    private String fragment;
    private String source;

    static {
        String[] stringArray = new String[11];
        stringArray[0] = "Version:1.0\r\n";
        stringArray[1] = "StartHTML:000000000\r\n";
        stringArray[2] = "EndHTML:000000000\r\n";
        stringArray[3] = "StartFragment:000000000\r\n";
        stringArray[4] = "EndFragment:000000000\r\n";
        stringArray[7] = "<!--StartFragment-->\r\n";
        stringArray[9] = "<!--EndFragment-->\r\n";
        FORMAT = stringArray;
        formater = new DecimalFormat(REPLACE);
        HTML_START = FORMAT[0].length() + FORMAT[1].length() + FORMAT[2].length() + FORMAT[3].length() + FORMAT[4].length();
        FRAGMENT = HTML_START + FORMAT[7].length();
        HTML_END = FRAGMENT + FORMAT[9].length();
    }

    public HTMLClipboardFormat(String string) {
        this(null, string, null, null);
    }

    public HTMLClipboardFormat(String string, String string2, String string3, String string4) {
        this.begin = string != null ? string : "";
        this.fragment = string2 != null ? string2 : "";
        this.end = string3 != null ? string3 : "";
        this.source = string4 != null ? string4 : "";
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = SOURCE_URL.length() + this.source.length() + CRLF.length();
        int n2 = 0;
        while (n2 < FORMAT.length) {
            switch (n2) {
                case 0: 
                case 7: 
                case 9: {
                    stringBuffer.append(FORMAT[n2]);
                    break;
                }
                case 1: {
                    stringBuffer.append(FORMAT[n2].replaceFirst(REPLACE, formater.format(HTML_START + n)));
                    break;
                }
                case 2: {
                    stringBuffer.append(FORMAT[n2].replaceFirst(REPLACE, formater.format(HTML_END + n + this.begin.length() + this.fragment.length() + this.end.length())));
                    break;
                }
                case 3: {
                    stringBuffer.append(FORMAT[n2].replaceFirst(REPLACE, formater.format(FRAGMENT + n + this.begin.length())));
                    break;
                }
                case 4: {
                    stringBuffer.append(FORMAT[n2].replaceFirst(REPLACE, formater.format(FRAGMENT + n + this.begin.length() + this.fragment.length())));
                    break;
                }
                case 5: {
                    stringBuffer.append(SOURCE_URL).append(this.source).append(CRLF);
                    break;
                }
                case 6: {
                    stringBuffer.append(this.begin);
                    break;
                }
                case 8: {
                    stringBuffer.append(this.fragment);
                    break;
                }
                case 10: {
                    stringBuffer.append(this.end);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String getBegin() {
        return this.begin;
    }

    public String getEnd() {
        return this.end;
    }

    public String getFragment() {
        return this.fragment;
    }

    public static HTMLClipboardFormat parse(String string) throws IllegalArgumentException {
        int n = HTMLClipboardFormat.readIntValue(string, START_HTML);
        int n2 = HTMLClipboardFormat.readIntValue(string, END_HTML);
        int n3 = HTMLClipboardFormat.readIntValue(string, START_FRAGMENT);
        int n4 = HTMLClipboardFormat.readIntValue(string, END_FRAGMENT);
        String string2 = string.substring(n, n3);
        String string3 = string.substring(n3, n4);
        String string4 = string.substring(n4, n2);
        String string5 = HTMLClipboardFormat.readStringValue(string, SOURCE_URL);
        return new HTMLClipboardFormat(string2, string3, string4, string5);
    }

    private static int readIntValue(String string, String string2) {
        int n = string.indexOf(string2);
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        int n2 = string.indexOf(CRLF, n);
        if (n2 == -1) {
            throw new IllegalArgumentException();
        }
        try {
            return Integer.parseInt(string.substring(n + string2.length(), n2));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException();
        }
    }

    private static String readStringValue(String string, String string2) {
        int n = string.indexOf(string2);
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        int n2 = string.indexOf(CRLF, n);
        if (n2 == -1) {
            throw new IllegalArgumentException();
        }
        return string.substring(n + string2.length(), n2);
    }
}

