/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsian.swt.internal.composer;

import org.eclipsian.swt.internal.composer.MozillaEmbed;
import org.eclipsian.swt.internal.composer.SpellCheckHelper;
import org.eclipsian.swt.internal.mozilla.XPCOMObject;
import org.eclipsian.swt.internal.mozilla.mozIRealTimeSpell;
import org.eclipsian.swt.internal.mozilla.nsEmbedString;
import org.eclipsian.swt.internal.mozilla.nsIDOMDocument;
import org.eclipsian.swt.internal.mozilla.nsIDOMElement;
import org.eclipsian.swt.internal.mozilla.nsIDOMNode;
import org.eclipsian.swt.internal.mozilla.nsIEditor;
import org.eclipsian.swt.internal.mozilla.nsISelection;
import org.eclipsian.swt.internal.mozilla.nsISelectionPrivate;
import org.eclipsian.swt.internal.mozilla.nsITransactionManager;

class EditorHelper {
    public static final String TEXT_NODE_TAG = "special text node tag";
    private nsIEditor editor;

    public EditorHelper(nsIEditor nsIEditor2) {
        this.editor = nsIEditor2;
    }

    public void Release() {
        this.editor.Release();
    }

    nsIEditor getEditor() {
        return this.editor;
    }

    public String outputToString(String string) {
        nsEmbedString nsEmbedString2 = new nsEmbedString(string);
        nsEmbedString nsEmbedString3 = new nsEmbedString();
        int n = this.editor.OutputToString(nsEmbedString2.getAddress(), 116480, nsEmbedString3.getAddress());
        if (n != 0) {
            this.doError(n);
        }
        String string2 = nsEmbedString3.toString();
        nsEmbedString2.dispose();
        nsEmbedString3.dispose();
        return string2;
    }

    public void scrollSelectionIntoView(boolean bl) {
        int n = this.editor.ScrollSelectionIntoView(bl);
        if (n != 0) {
            this.doError(n);
        }
    }

    public void resetModificationCount() {
        int n = this.editor.ResetModificationCount();
        if (n != 0) {
            this.doError(n);
        }
    }

    public void beginningOfDocument() {
        int n = this.editor.BeginningOfDocument();
        if (n != 0) {
            this.doError(n);
        }
    }

    public void endOfDocument() {
        int n = this.editor.EndOfDocument();
        if (n != 0) {
            this.doError(n);
        }
    }

    public void addDocumentStateListener(XPCOMObject xPCOMObject) {
        int n = this.editor.AddDocumentStateListener(xPCOMObject.getAddress());
        if (n != 0) {
            n = this.editor.AddDocumentStateListener(xPCOMObject.getAddress());
        }
        if (n != 0) {
            this.doError(n);
        }
    }

    public boolean getDocumentModified() {
        boolean[] blArray = new boolean[1];
        int n = this.editor.GetDocumentModified(blArray);
        if (n != 0) {
            this.doError(n);
        }
        return blArray[0];
    }

    public nsITransactionManager getTransactionManager() {
        int[] nArray = new int[1];
        int n = this.editor.GetTransactionManager(nArray);
        if (n != 0) {
            this.doError(n);
        }
        if (nArray[0] == 0) {
            this.doError(-2147467262);
        }
        return new nsITransactionManager(nArray[0]);
    }

    public void beginTransaction() {
        int n = this.editor.BeginTransaction();
        if (n != 0) {
            this.doError(n);
        }
    }

    public void endTransaction() {
        int n = this.editor.EndTransaction();
        if (n != 0) {
            this.doError(n);
        }
    }

    public void beginPlaceHolderTransaction() {
        int n = this.editor.BeginPlaceHolderTransaction(0);
        if (n != 0) {
            this.doError(n);
        }
    }

    public void endPlaceHolderTransaction() {
        int n = this.editor.EndPlaceHolderTransaction();
        if (n != 0) {
            this.doError(n);
        }
    }

    public nsISelection getSelection() {
        int[] nArray = new int[1];
        int n = this.editor.getSelection(nArray);
        if (n != 0) {
            this.doError(n);
        }
        if (nArray[0] == 0) {
            this.doError(-2147467262);
        }
        return new nsISelection(nArray[0]);
    }

    public void addSelectionListener(XPCOMObject xPCOMObject) {
        nsISelection nsISelection2;
        int[] nArray = new int[1];
        int n = this.editor.getSelection(nArray);
        if (n != 0) {
            this.doError(n);
        }
        if (nArray[0] == 0) {
            this.doError(-2147467262);
        }
        if ((n = (nsISelection2 = new nsISelection(nArray[0])).QueryInterface(nsISelectionPrivate.NS_ISELECTIONPRIVATE_IID, nArray)) != 0) {
            this.doError(n);
        }
        if (nArray[0] == 0) {
            this.doError(-2147467262);
        }
        nsISelection2.Release();
        nsISelectionPrivate nsISelectionPrivate2 = new nsISelectionPrivate(nArray[0]);
        n = nsISelectionPrivate2.AddSelectionListener(xPCOMObject.getAddress());
        if (n != 0) {
            this.doError(n);
        }
        nsISelectionPrivate2.Release();
    }

    public void removeSelectionListener(XPCOMObject xPCOMObject) {
        nsISelection nsISelection2;
        int[] nArray = new int[1];
        int n = this.editor.getSelection(nArray);
        if (n != 0) {
            this.doError(n);
        }
        if (nArray[0] == 0) {
            this.doError(-2147467262);
        }
        if ((n = (nsISelection2 = new nsISelection(nArray[0])).QueryInterface(nsISelectionPrivate.NS_ISELECTIONPRIVATE_IID, nArray)) != 0) {
            this.doError(n);
        }
        if (nArray[0] == 0) {
            this.doError(-2147467262);
        }
        nsISelection2.Release();
        nsISelectionPrivate nsISelectionPrivate2 = new nsISelectionPrivate(nArray[0]);
        n = nsISelectionPrivate2.RemoveSelectionListener(xPCOMObject.getAddress());
        if (n != 0) {
            this.doError(n);
        }
        nsISelectionPrivate2.Release();
    }

    public nsIDOMDocument getDocument() {
        int[] nArray = new int[1];
        int n = this.editor.getDocument(nArray);
        if (n != 0) {
            this.doError(n);
        }
        if (nArray[0] == 0) {
            this.doError(-2147467262);
        }
        return new nsIDOMDocument(nArray[0]);
    }

    public void insertNode(nsIDOMNode nsIDOMNode2, nsIDOMNode nsIDOMNode3, int n) {
        int n2 = this.editor.InsertNode(nsIDOMNode2.getAddress(), nsIDOMNode3.getAddress(), n);
        if (n2 != 0) {
            this.doError(n2);
        }
    }

    public void insertNodeAfter(nsIDOMNode nsIDOMNode2, nsIDOMNode nsIDOMNode3, nsIDOMNode nsIDOMNode4) {
        int n = this.editor.InsertNodeAfter(nsIDOMNode2.getAddress(), nsIDOMNode3.getAddress(), nsIDOMNode4.getAddress());
        if (n != 0) {
            this.doError(n);
        }
    }

    public nsIDOMNode createNode(String string, nsIDOMNode nsIDOMNode2, int n) {
        int[] nArray = new int[1];
        nsEmbedString nsEmbedString2 = new nsEmbedString(string);
        int n2 = this.editor.CreateNode(nsEmbedString2.getAddress(), nsIDOMNode2.getAddress(), n, nArray);
        nsEmbedString2.dispose();
        if (n2 != 0) {
            this.doError(n2);
        }
        if (nArray[0] == 0) {
            this.doError(-2147467262);
        }
        return new nsIDOMNode(nArray[0]);
    }

    public nsIDOMNode splitNode(nsIDOMNode nsIDOMNode2, int n) {
        int[] nArray = new int[1];
        int n2 = this.editor.SplitNode(nsIDOMNode2.getAddress(), n, nArray);
        if (n2 != 0) {
            this.doError(n2);
        }
        if (nArray[0] == 0) {
            this.doError(-2147467262);
        }
        return new nsIDOMNode(nArray[0]);
    }

    public void deleteNode(nsIDOMNode nsIDOMNode2) {
        int n = this.editor.DeleteNode(nsIDOMNode2.getAddress());
        if (n != 0) {
            this.doError(n);
        }
    }

    public void setAttribute(nsIDOMElement nsIDOMElement2, String string, String string2) {
        nsEmbedString nsEmbedString2 = new nsEmbedString(string);
        nsEmbedString nsEmbedString3 = new nsEmbedString(string2);
        int n = this.editor.SetAttribute(nsIDOMElement2.getAddress(), nsEmbedString2.getAddress(), nsEmbedString3.getAddress());
        nsEmbedString2.dispose();
        nsEmbedString3.dispose();
        if (n != 0) {
            this.doError(n);
        }
    }

    public void removeAttribute(nsIDOMElement nsIDOMElement2, String string) {
        nsEmbedString nsEmbedString2 = new nsEmbedString(string);
        int n = this.editor.RemoveAttribute(nsIDOMElement2.getAddress(), nsEmbedString2.getAddress());
        nsEmbedString2.dispose();
        if (n != 0) {
            this.doError(n);
        }
    }

    public void undo(int n) {
        int n2 = this.editor.Undo(n);
        if (n2 != 0) {
            this.doError(n2, false);
        }
    }

    public void redo(int n) {
        int n2 = this.editor.Redo(n);
        if (n2 != 0) {
            this.doError(n2, false);
        }
    }

    public SpellCheckHelper enableRealTimeSpell(boolean bl, boolean bl2) {
        int[] nArray = new int[1];
        int n = this.editor.EnableRealTimeSpell(bl, (int[])(bl2 ? nArray : null));
        if (n != 0) {
            this.doError(n);
        }
        if (bl2 && nArray[0] == 0) {
            this.doError(-2147467262);
        }
        return bl2 ? new SpellCheckHelper(new mozIRealTimeSpell(nArray[0])) : null;
    }

    protected void doError(int n) {
        MozillaEmbed.doError(n);
    }

    protected void doError(int n, boolean bl) {
        MozillaEmbed.doError(n, bl);
    }

    protected void doWarning(String string) {
        MozillaEmbed.doWarning(string);
    }
}

