/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsian.swt.internal.composer;

import java.util.ArrayList;
import org.eclipsian.swt.internal.composer.MozillaEmbed;
import org.eclipsian.swt.internal.composer.RangeImpl;
import org.eclipsian.swt.internal.composer.Util;
import org.eclipsian.swt.internal.mozilla.mozIRealTimeSpell;
import org.eclipsian.swt.internal.mozilla.nsEmbedString;
import org.eclipsian.swt.internal.mozilla.nsIDOMNode;
import org.eclipsian.swt.internal.mozilla.nsIDOMRange;
import org.eclipsian.swt.internal.mozilla.nsIEditorSpellCheck;

class SpellCheckHelper {
    private mozIRealTimeSpell rtSpell;
    private nsIEditorSpellCheck spell;

    public SpellCheckHelper(mozIRealTimeSpell mozIRealTimeSpell2) {
        this.rtSpell = mozIRealTimeSpell2;
    }

    public void Release() {
        if (this.spell != null) {
            this.spell.Release();
        }
        this.rtSpell.Release();
    }

    private nsIEditorSpellCheck getEditorSpellCheck() {
        if (this.spell == null) {
            int[] nArray = new int[1];
            int n = this.rtSpell.getSpellChecker(nArray);
            if (n != 0) {
                this.doError(n);
            }
            if (nArray[0] == 0) {
                this.doError(-2147467262);
            }
            this.spell = new nsIEditorSpellCheck(nArray[0]);
        }
        return this.spell;
    }

    public void spellCheckRange(nsIDOMRange nsIDOMRange2) {
        int n = this.rtSpell.SpellCheckRange(nsIDOMRange2.getAddress());
        if (n != 0) {
            this.doError(n);
        }
    }

    public String getMispelledWord(nsIDOMNode nsIDOMNode2, int n) {
        int[] nArray = new int[1];
        int n2 = this.rtSpell.GetMispelledWord(nsIDOMNode2.getAddress(), n, nArray);
        if (n2 != 0) {
            this.doError(n2);
        }
        if (nArray[0] == 0) {
            return null;
        }
        RangeImpl rangeImpl = new RangeImpl(null, new nsIDOMRange(nArray[0]));
        String string = rangeImpl.toString();
        rangeImpl.Release();
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    public void replaceWord(nsIDOMNode nsIDOMNode2, int n, String string) {
        nsEmbedString nsEmbedString2 = new nsEmbedString(string);
        int n2 = this.rtSpell.ReplaceWord(nsIDOMNode2.getAddress(), n, nsEmbedString2.getAddress());
        nsEmbedString2.dispose();
        if (n2 != 0) {
            this.doError(n2);
        }
    }

    public void addWordToDictionary(String string) {
        nsEmbedString nsEmbedString2 = new nsEmbedString(string);
        int n = this.rtSpell.AddWordToDictionary(nsEmbedString2.getAddress());
        nsEmbedString2.dispose();
        if (n != 0) {
            this.doError(n);
        }
    }

    public void removeWordFromDictionary(String string) {
        nsEmbedString nsEmbedString2 = new nsEmbedString(string);
        int n = this.getEditorSpellCheck().RemoveWordFromDictionary(nsEmbedString2.getAddress());
        nsEmbedString2.dispose();
        if (n != 0) {
            this.doError(n);
        }
    }

    public String[] getPersonalDictionary() {
        int[] nArray = new int[1];
        int n = this.getEditorSpellCheck().GetPersonalDictionary();
        if (n != 0) {
            this.doError(n);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while (true) {
            String string;
            if ((n = this.getEditorSpellCheck().GetPersonalDictionaryWord(nArray)) != 0) {
                this.doError(n);
            }
            if (nArray[0] == 0 || (string = Util.getWString(nArray[0])).length() == 0) break;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void ignoreWordAllOccurrences(String string) {
        nsEmbedString nsEmbedString2 = new nsEmbedString(string);
        int n = this.getEditorSpellCheck().IgnoreWordAllOccurrences(nsEmbedString2.getAddress());
        nsEmbedString2.dispose();
        if (n != 0) {
            this.doError(n);
        }
    }

    public boolean checkCurrentWordNoSuggest(String string) {
        boolean[] blArray = new boolean[1];
        int n = this.getEditorSpellCheck().CheckCurrentWordNoSuggest(Util.getNSWString(string), blArray);
        if (n != 0) {
            this.doError(n);
        }
        return blArray[0];
    }

    public boolean checkCurrentWord(String string) {
        boolean[] blArray = new boolean[1];
        int n = this.getEditorSpellCheck().CheckCurrentWord(Util.getNSWString(string), blArray);
        if (n != 0) {
            this.doError(n);
        }
        return blArray[0];
    }

    public String getSuggestedWord() {
        int[] nArray = new int[1];
        int n = this.getEditorSpellCheck().GetSuggestedWord(nArray);
        if (n != 0) {
            this.doError(n);
        }
        if (nArray[0] == 0) {
            return null;
        }
        return Util.getWString(nArray[0]);
    }

    public String getCurrentDictionary() {
        int[] nArray = new int[1];
        int n = this.getEditorSpellCheck().GetCurrentDictionary(nArray);
        if (n != 0) {
            this.doError(n);
        }
        if (nArray[0] == 0) {
            return null;
        }
        return Util.getWString(nArray[0]);
    }

    public void setCurrentDictionary(String string) {
        int n = this.getEditorSpellCheck().SetCurrentDictionary(Util.getNSWString(string));
        if (n != 0) {
            this.doError(n);
        }
    }

    protected void doError(int n) {
        MozillaEmbed.doError(n);
    }

    protected void doError(int n, boolean bl) {
        MozillaEmbed.doError(n, bl);
    }
}

