/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsian.swt.internal.composer;

import org.eclipsian.swt.internal.OS;
import org.eclipsian.swt.internal.composer.TooltipTextProviderHelper;
import org.eclipsian.swt.internal.mozilla.XPCOM;
import org.eclipsian.swt.internal.mozilla.XPCOMObject;
import org.eclipsian.swt.internal.mozilla.nsID;
import org.eclipsian.swt.internal.mozilla.nsIDOMNode;
import org.eclipsian.swt.internal.mozilla.nsISupportsWeakReference;
import org.eclipsian.swt.internal.mozilla.nsITooltipTextProvider;
import org.eclipsian.swt.internal.mozilla.nsIWeakReference;

public class TooltipTextProvider {
    private XPCOMObject supportsWeakReference;
    private XPCOMObject weakReference;
    private XPCOMObject tooltipTextProvider;
    private int refCount = 0;
    private int tooltipText = 0;

    TooltipTextProvider() {
        this.createCOMInterfaces();
    }

    void createCOMInterfaces() {
        int[] nArray = new int[4];
        nArray[0] = 2;
        nArray[3] = 1;
        this.supportsWeakReference = new XPCOMObject(nArray){

            public int method0(int[] nArray) {
                return TooltipTextProvider.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return TooltipTextProvider.this.AddRef();
            }

            public int method2(int[] nArray) {
                return TooltipTextProvider.this.Release();
            }

            public int method3(int[] nArray) {
                return TooltipTextProvider.this.GetWeakReference(nArray[0]);
            }
        };
        int[] nArray2 = new int[4];
        nArray2[0] = 2;
        nArray2[3] = 2;
        this.weakReference = new XPCOMObject(nArray2){

            public int method0(int[] nArray) {
                return TooltipTextProvider.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return TooltipTextProvider.this.AddRef();
            }

            public int method2(int[] nArray) {
                return TooltipTextProvider.this.Release();
            }

            public int method3(int[] nArray) {
                return TooltipTextProvider.this.QueryReferent(nArray[0], nArray[1]);
            }
        };
        int[] nArray3 = new int[4];
        nArray3[0] = 2;
        nArray3[3] = 3;
        this.tooltipTextProvider = new XPCOMObject(nArray3){

            public int method0(int[] nArray) {
                return TooltipTextProvider.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return TooltipTextProvider.this.AddRef();
            }

            public int method2(int[] nArray) {
                return TooltipTextProvider.this.Release();
            }

            public int method3(int[] nArray) {
                return TooltipTextProvider.this.GetNodeText(nArray[0], nArray[1], nArray[2]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.tooltipText != 0) {
            XPCOM.PR_Free(this.tooltipText);
            this.tooltipText = 0;
        }
        if (this.tooltipTextProvider != null) {
            this.tooltipTextProvider.dispose();
            this.tooltipTextProvider = null;
        }
        if (this.weakReference != null) {
            this.weakReference.dispose();
            this.weakReference = null;
        }
        if (this.supportsWeakReference != null) {
            this.supportsWeakReference.dispose();
            this.supportsWeakReference = null;
        }
    }

    int getAddress() {
        return this.tooltipTextProvider.getAddress();
    }

    int QueryInterface(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return -2147467262;
        }
        nsID nsID2 = new nsID();
        XPCOM.memmove(nsID2, n, 16);
        if (nsID2.Equals(nsISupportsWeakReference.NS_ISUPPORTSWEAKREFERENCE_IID)) {
            XPCOM.memmove(n2, new int[]{this.supportsWeakReference.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (nsID2.Equals(nsIWeakReference.NS_IWEAKREFERENCE_IID)) {
            XPCOM.memmove(n2, new int[]{this.weakReference.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (nsID2.Equals(nsITooltipTextProvider.NS_ITOOLTIPTEXTPROVIDER_IID)) {
            XPCOM.memmove(n2, new int[]{this.tooltipTextProvider.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        XPCOM.memmove(n2, new int[1], OS.PTR_SIZEOF);
        return -2147467262;
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int QueryReferent(int n, int n2) {
        return this.QueryInterface(n, n2);
    }

    int GetWeakReference(int n) {
        XPCOM.memmove(n, new int[]{this.weakReference.getAddress()}, OS.PTR_SIZEOF);
        this.AddRef();
        return 0;
    }

    int GetNodeText(int n, int n2, int n3) {
        String string;
        if (this.tooltipText != 0) {
            XPCOM.PR_Free(this.tooltipText);
            this.tooltipText = 0;
        }
        if ((string = TooltipTextProviderHelper.getNodeText(new nsIDOMNode(n))) != null) {
            char[] cArray = new char[string.length() + 1];
            string.getChars(0, string.length(), cArray, 0);
            this.tooltipText = XPCOM.PR_Malloc(cArray.length * 2);
            XPCOM.memmove(this.tooltipText, cArray, cArray.length * 2);
            XPCOM.memmove(n2, new int[]{this.tooltipText}, OS.PTR_SIZEOF);
        }
        XPCOM.memmove(n3, new int[]{string != null ? 1 : 0}, 4);
        return 0;
    }
}

