/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsian.swt.internal.composer;

import org.eclipsian.swt.internal.composer.EditorHelper;
import org.eclipsian.swt.internal.mozilla.XPCOMObject;
import org.eclipsian.swt.internal.mozilla.nsEmbedString;
import org.eclipsian.swt.internal.mozilla.nsICollection;
import org.eclipsian.swt.internal.mozilla.nsIDOMElement;
import org.eclipsian.swt.internal.mozilla.nsIDOMNode;
import org.eclipsian.swt.internal.mozilla.nsIEditor;
import org.eclipsian.swt.internal.mozilla.nsIEditorStyleSheets;
import org.eclipsian.swt.internal.mozilla.nsIHTMLAbsPosEditor;
import org.eclipsian.swt.internal.mozilla.nsIHTMLEditor;
import org.eclipsian.swt.internal.mozilla.nsIHTMLInlineTableEditor;
import org.eclipsian.swt.internal.mozilla.nsIHTMLObjectResizer;
import org.eclipsian.swt.internal.mozilla.nsIURIRefObject;

class HTMLEditorHelper
extends EditorHelper {
    private nsIHTMLEditor htmlEditor;
    private nsIEditorStyleSheets styleSheets;
    private nsIHTMLObjectResizer objectResizer;
    private nsIHTMLInlineTableEditor inlineTableEditor;
    private nsIHTMLAbsPosEditor absPosEditor;

    public HTMLEditorHelper(nsIEditor nsIEditor2) {
        super(nsIEditor2);
        long[] lArray = new long[1];
        int n = nsIEditor2.QueryInterface(nsIHTMLEditor.NS_IHTMLEDITOR_IID, lArray);
        if (n != 0) {
            this.doError(n);
        }
        if (lArray[0] == 0L) {
            this.doError(-2147467262);
        }
        this.htmlEditor = new nsIHTMLEditor(lArray[0]);
    }

    public void Release() {
        if (this.styleSheets != null) {
            this.styleSheets.Release();
        }
        if (this.objectResizer != null) {
            this.objectResizer.Release();
        }
        if (this.inlineTableEditor != null) {
            this.inlineTableEditor.Release();
        }
        if (this.absPosEditor != null) {
            this.absPosEditor.Release();
        }
        this.htmlEditor.Release();
        super.Release();
    }

    private nsIEditorStyleSheets getStyleSheets() {
        if (this.styleSheets == null) {
            long[] lArray = new long[1];
            int n = this.htmlEditor.QueryInterface(nsIEditorStyleSheets.NS_IEDITORSTYLESHEETS_IID, lArray);
            if (n != 0) {
                this.doError(n);
            }
            if (lArray[0] == 0L) {
                this.doError(-2147467262);
            }
            this.styleSheets = new nsIEditorStyleSheets(lArray[0]);
        }
        return this.styleSheets;
    }

    private nsIHTMLObjectResizer getObjectResizer() {
        if (this.objectResizer == null) {
            long[] lArray = new long[1];
            int n = this.htmlEditor.QueryInterface(nsIHTMLObjectResizer.NS_IHTMLOBJECTRESIZER_IID, lArray);
            if (n != 0) {
                this.doError(n);
            }
            if (lArray[0] == 0L) {
                this.doError(-2147467262);
            }
            this.objectResizer = new nsIHTMLObjectResizer(lArray[0]);
        }
        return this.objectResizer;
    }

    private nsIHTMLInlineTableEditor getInlineTableEditor() {
        if (this.inlineTableEditor == null) {
            long[] lArray = new long[1];
            int n = this.htmlEditor.QueryInterface(nsIHTMLInlineTableEditor.NS_IHTMLINLINETABLEEDITOR_IID, lArray);
            if (n != 0) {
                this.doError(n);
            }
            if (lArray[0] == 0L) {
                this.doError(-2147467262);
            }
            this.inlineTableEditor = new nsIHTMLInlineTableEditor(lArray[0]);
        }
        return this.inlineTableEditor;
    }

    private nsIHTMLAbsPosEditor getAbsPosEditor() {
        if (this.absPosEditor == null) {
            long[] lArray = new long[1];
            int n = this.htmlEditor.QueryInterface(nsIHTMLAbsPosEditor.NS_IHTMLABSPOSEDITOR_IID, lArray);
            if (n != 0) {
                this.doError(n);
            }
            if (lArray[0] == 0L) {
                this.doError(-2147467262);
            }
            this.absPosEditor = new nsIHTMLAbsPosEditor(lArray[0]);
        }
        return this.absPosEditor;
    }

    public void rebuildDocumentFromSource(String string) {
        nsEmbedString nsEmbedString2 = new nsEmbedString(string);
        int n = this.htmlEditor.RebuildDocumentFromSource(nsEmbedString2.getAddress());
        nsEmbedString2.dispose();
        if (n != 0) {
            this.doWarning("rebuildDocumentFromSource:XPCOM error #" + n);
            this.doWarning("Yep! Due mozilla editor bug change you <body></body> tag to lowercase!");
        }
    }

    public nsIDOMElement getSelectionContainer() {
        long[] lArray = new long[1];
        int n = this.htmlEditor.GetSelectionContainer(lArray);
        if (n != 0) {
            this.doError(n);
        }
        if (lArray[0] == 0L) {
            return null;
        }
        return new nsIDOMElement(lArray[0]);
    }

    public void insertHTML(String string) {
        nsEmbedString nsEmbedString2 = new nsEmbedString(string);
        int n = this.htmlEditor.InsertHTML(nsEmbedString2.getAddress());
        nsEmbedString2.dispose();
        if (n != 0) {
            this.doError(n);
        }
    }

    public void selectElement(nsIDOMElement nsIDOMElement2) {
        int n = this.htmlEditor.SelectElement(nsIDOMElement2.getAddress());
        if (n != 0) {
            this.doError(n);
        }
    }

    public void setCaretAfterElement(nsIDOMElement nsIDOMElement2) {
        int n = this.htmlEditor.SetCaretAfterElement(nsIDOMElement2.getAddress());
        if (n != 0) {
            this.doError(n);
        }
    }

    public boolean nodeIsBlock(nsIDOMNode nsIDOMNode2) {
        boolean[] blArray = new boolean[1];
        int n = this.htmlEditor.NodeIsBlock(nsIDOMNode2.getAddress(), blArray);
        if (n != 0) {
            this.doError(n);
        }
        return blArray[0];
    }

    public void setDocumentTitle(String string) {
        nsEmbedString nsEmbedString2 = new nsEmbedString(string);
        int n = this.htmlEditor.SetDocumentTitle(nsEmbedString2.getAddress());
        nsEmbedString2.dispose();
        if (n != 0) {
            this.doError(n);
        }
    }

    public nsIDOMElement getElementOrParentByTagName(String string, nsIDOMNode nsIDOMNode2) {
        long[] lArray = new long[1];
        nsEmbedString nsEmbedString2 = new nsEmbedString(string);
        int n = this.htmlEditor.GetElementOrParentByTagName(nsEmbedString2.getAddress(), nsIDOMNode2 != null ? nsIDOMNode2.getAddress() : 0L, lArray);
        nsEmbedString2.dispose();
        if (n != 0 && n != 5636097) {
            this.doError(n);
        }
        if (n == 5636097) {
            return null;
        }
        return new nsIDOMElement(lArray[0]);
    }

    public void insertElementAtSelection(nsIDOMElement nsIDOMElement2, boolean bl) {
        int n = this.htmlEditor.InsertElementAtSelection(nsIDOMElement2.getAddress(), bl);
        if (n != 0) {
            this.doError(n);
        }
    }

    public void insertLinkAroundSelection(nsIDOMElement nsIDOMElement2) {
        int n = this.htmlEditor.InsertLinkAroundSelection(nsIDOMElement2.getAddress());
        if (n != 0) {
            this.doError(n);
        }
    }

    public void addOverrideStyleSheet(String string) {
        nsEmbedString nsEmbedString2 = new nsEmbedString(string);
        int n = this.getStyleSheets().addOverrideStyleSheet(nsEmbedString2.getAddress());
        if (n != 0) {
            this.doError(n);
        }
        nsEmbedString2.dispose();
    }

    public void removeOverrideStyleSheet(String string) {
        nsEmbedString nsEmbedString2 = new nsEmbedString(string);
        int n = this.getStyleSheets().removeOverrideStyleSheet(nsEmbedString2.getAddress());
        if (n != 0) {
            this.doError(n);
        }
        nsEmbedString2.dispose();
    }

    public void enableStyleSheet(String string, boolean bl) {
        nsEmbedString nsEmbedString2 = new nsEmbedString(string);
        int n = this.getStyleSheets().enableStyleSheet(nsEmbedString2.getAddress(), bl ? 1 : 0);
        if (n != 0) {
            this.doError(n);
        }
        nsEmbedString2.dispose();
    }

    public void setObjectResizingEnabled(boolean bl) {
        int n = this.getObjectResizer().setObjectResizingEnabled(bl);
        if (n != 0) {
            this.doError(n);
        }
    }

    public boolean getObjectResizingEnabled() {
        boolean[] blArray = new boolean[1];
        int n = this.getObjectResizer().getObjectResizingEnabled(blArray);
        if (n != 0) {
            this.doError(n);
        }
        return blArray[0];
    }

    public nsIDOMElement getResizedObject() {
        long[] lArray = new long[1];
        int n = this.getObjectResizer().getResizedObject(lArray);
        if (n != 0) {
            this.doError(n);
        }
        if (lArray[0] == 0L) {
            return null;
        }
        return new nsIDOMElement(lArray[0]);
    }

    public void hideResizers() {
        int n = this.getObjectResizer().HideResizers();
        if (n != 0) {
            this.doError(n);
        }
    }

    public void showResizersOnElement(nsIDOMElement nsIDOMElement2) {
        int n = this.getObjectResizer().ShowResizers(nsIDOMElement2.getAddress());
        if (n != 0) {
            this.doError(n);
        }
    }

    public void refreshResizers() {
        int n = this.getObjectResizer().RefreshResizers();
        if (n != 0) {
            this.doError(n);
        }
    }

    public void refreshGrabber() {
        boolean[] blArray;
        nsIHTMLAbsPosEditor nsIHTMLAbsPosEditor2 = this.getAbsPosEditor();
        int n = nsIHTMLAbsPosEditor2.getSelectionContainerAbsolutelyPositioned(blArray = new boolean[1]);
        if (n != 0) {
            this.doError(n);
        }
        if (!blArray[0]) {
            return;
        }
        n = nsIHTMLAbsPosEditor2.RefreshGrabber();
        if (n != 0) {
            this.doError(n);
        }
    }

    public void hideGrabber() {
        boolean[] blArray;
        nsIHTMLAbsPosEditor nsIHTMLAbsPosEditor2 = this.getAbsPosEditor();
        int n = nsIHTMLAbsPosEditor2.getSelectionContainerAbsolutelyPositioned(blArray = new boolean[1]);
        if (n != 0) {
            this.doError(n);
        }
        if (!blArray[0]) {
            return;
        }
        n = nsIHTMLAbsPosEditor2.HideGrabber();
        if (n != 0) {
            this.doError(n);
        }
    }

    public void showGrabberOnElement(nsIDOMElement nsIDOMElement2) {
        nsIHTMLAbsPosEditor nsIHTMLAbsPosEditor2 = this.getAbsPosEditor();
        int n = nsIHTMLAbsPosEditor2.ShowGrabberOnElement(nsIDOMElement2.getAddress());
        if (n != 0) {
            this.doError(n);
        }
    }

    public void hideInlineTableEditingUI() {
        int n = this.getInlineTableEditor().HideInlineTableEditingUI();
        if (n != 0) {
            this.doError(n);
        }
    }

    public void addInsertionListener(XPCOMObject xPCOMObject) {
        int n = this.htmlEditor.AddInsertionListener(xPCOMObject.getAddress());
        if (n != 0) {
            this.doError(n);
        }
    }

    public void removeInsertionListener(XPCOMObject xPCOMObject) {
        int n = this.htmlEditor.RemoveInsertionListener(xPCOMObject.getAddress());
        if (n != 0) {
            this.doError(n);
        }
    }

    public void setParagraphFormat(String string) {
        nsEmbedString nsEmbedString2 = new nsEmbedString(string);
        int n = this.htmlEditor.SetParagraphFormat(nsEmbedString2.getAddress());
        nsEmbedString2.dispose();
        if (n != 0) {
            this.doWarning("setParagraphFormat failed");
        }
    }

    public String getParagraphFormat() {
        nsEmbedString nsEmbedString2 = new nsEmbedString();
        boolean[] blArray = new boolean[1];
        int n = this.htmlEditor.GetParagraphState(blArray, nsEmbedString2.getAddress());
        String string = nsEmbedString2.toString();
        nsEmbedString2.dispose();
        if (n != 0) {
            this.doWarning("getParagraphFormat failed");
        }
        return string;
    }

    public String getFontFace() {
        nsEmbedString nsEmbedString2 = new nsEmbedString();
        boolean[] blArray = new boolean[1];
        int n = this.htmlEditor.GetFontFaceState(blArray, nsEmbedString2.getAddress());
        String string = nsEmbedString2.toString();
        nsEmbedString2.dispose();
        if (n != 0) {
            this.doWarning("getFontFace failed");
        }
        return string;
    }

    public String getFontColor() {
        nsEmbedString nsEmbedString2 = new nsEmbedString();
        boolean[] blArray = new boolean[1];
        int n = this.htmlEditor.GetFontColorState(blArray, nsEmbedString2.getAddress());
        String string = nsEmbedString2.toString();
        nsEmbedString2.dispose();
        if (n != 0) {
            this.doWarning("getFontColor failed");
        }
        return string;
    }

    public String getBackgroundColor() {
        nsEmbedString nsEmbedString2 = new nsEmbedString();
        boolean[] blArray = new boolean[1];
        int n = this.htmlEditor.GetBackgroundColorState(blArray, nsEmbedString2.getAddress());
        String string = nsEmbedString2.toString();
        nsEmbedString2.dispose();
        if (n != 0) {
            this.doWarning("getBackgroundColor failed");
        }
        return string;
    }

    public String getHighlightColor() {
        nsEmbedString nsEmbedString2 = new nsEmbedString();
        boolean[] blArray = new boolean[1];
        int n = this.htmlEditor.GetHighlightColorState(blArray, nsEmbedString2.getAddress());
        String string = nsEmbedString2.toString();
        nsEmbedString2.dispose();
        if (n != 0) {
            this.doWarning("getHighlightColor failed");
        }
        return string;
    }

    public String getStyleClass() {
        nsEmbedString nsEmbedString2 = new nsEmbedString();
        boolean[] blArray = new boolean[1];
        int n = this.htmlEditor.GetClassState(blArray, nsEmbedString2.getAddress());
        String string = nsEmbedString2.toString();
        nsEmbedString2.dispose();
        if (n != 0) {
            this.doWarning("getStyleClass failed");
        }
        return string;
    }

    public void addOrRemoveStyleClass(String string, boolean bl) {
        nsEmbedString nsEmbedString2 = new nsEmbedString(string);
        int n = this.htmlEditor.AddOrRemoveClass(nsEmbedString2.getAddress(), bl);
        nsEmbedString2.dispose();
        if (n != 0) {
            this.doWarning("addStyleClass failed");
        }
    }

    public nsIURIRefObject[] getLinkedObjects() {
        int[] nArray;
        nsICollection nsICollection2;
        long[] lArray = new long[1];
        int n = this.htmlEditor.GetLinkedObjects(lArray);
        if (n != 0) {
            this.doError(n);
        }
        if (lArray[0] == 0L) {
            this.doError(-2147467262);
        }
        if ((n = (nsICollection2 = new nsICollection(lArray[0])).Count(nArray = new int[1])) != 0) {
            this.doError(n);
        }
        nsIURIRefObject[] nsIURIRefObjectArray = new nsIURIRefObject[nArray[0]];
        int n2 = 0;
        while (n2 < nArray[0]) {
            n = nsICollection2.GetElementAt(n2, lArray);
            if (n != 0) {
                this.doError(n);
            }
            if (lArray[0] == 0L) {
                this.doError(-2147467262);
            }
            nsIURIRefObjectArray[n2] = new nsIURIRefObject(lArray[0]);
            ++n2;
        }
        return nsIURIRefObjectArray;
    }

    public void updateBaseURL() {
        int n = this.htmlEditor.UpdateBaseURL();
        if (n != 0) {
            this.doError(n);
        }
    }

    public boolean isAnonymousElement(nsIDOMNode nsIDOMNode2) {
        boolean[] blArray = new boolean[1];
        int n = this.htmlEditor.IsAnonymousElement(nsIDOMNode2.getAddress(), blArray);
        if (n != 0) {
            this.doError(n);
        }
        return blArray[0];
    }

    public boolean isLocalDND() {
        boolean[] blArray = new boolean[1];
        int n = this.htmlEditor.getIsLocalDND(blArray);
        if (n != 0) {
            this.doError(n);
        }
        return blArray[0];
    }

    public nsIDOMElement createAnonymousElement(String string, nsIDOMNode nsIDOMNode2, String string2, boolean bl) {
        nsEmbedString nsEmbedString2 = new nsEmbedString(string);
        nsEmbedString nsEmbedString3 = new nsEmbedString(string2);
        long[] lArray = new long[1];
        int n = this.htmlEditor.CreateAnonymousElement(nsEmbedString2.getAddress(), nsIDOMNode2.getAddress(), nsEmbedString3.getAddress(), bl, lArray);
        nsEmbedString3.dispose();
        nsEmbedString2.dispose();
        if (n != 0) {
            this.doError(n);
        }
        if (lArray[0] == 0L) {
            return null;
        }
        return new nsIDOMElement(lArray[0]);
    }
}

