/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsian.swt.internal.composer;

import java.util.HashMap;
import java.util.Map;
import org.eclipsian.swt.internal.composer.GeckoEditor;
import org.eclipsian.swt.internal.composer.MozillaEmbed;
import org.eclipsian.swt.internal.composer.PersonalDictionaryFactory;
import org.eclipsian.swt.internal.composer.Util;
import org.eclipsian.swt.internal.mozilla.XPCOM;
import org.eclipsian.swt.internal.mozilla.mozIPersonalDictionary;
import org.eclipsian.swt.internal.mozilla.nsIComponentManager;
import org.eclipsian.swt.internal.mozilla.nsIComponentRegistrar;
import org.eclipsian.swt.internal.mozilla.nsIFactory;

public class PersonalDictionaryHelper {
    private static PersonalDictionaryFactory personalDictionaryFactory = null;
    private static nsIFactory originalDictionaryFactory = null;
    private static Map dictionaries = new HashMap();
    private static mozIPersonalDictionary activeDictionary = null;

    private PersonalDictionaryHelper() {
    }

    public static void setActiveEditor(GeckoEditor geckoEditor) {
        activeDictionary = null;
        if (geckoEditor != null && (activeDictionary = (mozIPersonalDictionary)dictionaries.get(new Long(geckoEditor.handle))) == null && (activeDictionary = PersonalDictionaryHelper.createPersonalDictionary()) != null) {
            dictionaries.put(new Long(geckoEditor.handle), activeDictionary);
        }
    }

    public static void disposeDictionaryForEditor(GeckoEditor geckoEditor) {
        mozIPersonalDictionary mozIPersonalDictionary2 = (mozIPersonalDictionary)dictionaries.remove(new Long(geckoEditor.handle));
        if (mozIPersonalDictionary2 != null) {
            mozIPersonalDictionary2.Release();
        }
    }

    static mozIPersonalDictionary getActiveDictionary() {
        return activeDictionary;
    }

    private static mozIPersonalDictionary createPersonalDictionary() {
        if (originalDictionaryFactory == null) {
            return null;
        }
        long[] lArray = new long[1];
        int n = originalDictionaryFactory.CreateInstance(0L, mozIPersonalDictionary.MOZ_PERSONALDICTIONARY_IID, lArray);
        if (n != 0) {
            PersonalDictionaryHelper.doError(n);
        }
        if (lArray[0] == 0L) {
            PersonalDictionaryHelper.doError(-2147467262);
        }
        return new mozIPersonalDictionary(lArray[0]);
    }

    public static void register() {
        personalDictionaryFactory = PersonalDictionaryHelper.registerPersonalDictionaryFactory();
    }

    private static PersonalDictionaryFactory registerPersonalDictionaryFactory() {
        nsIComponentManager nsIComponentManager2;
        long[] lArray = new long[1];
        int n = XPCOM.NS_GetComponentManager(lArray);
        if (n != 0) {
            PersonalDictionaryHelper.doError(n);
        }
        if (lArray[0] == 0L) {
            PersonalDictionaryHelper.doError(-2147467262);
        }
        if ((n = (nsIComponentManager2 = new nsIComponentManager(lArray[0])).GetClassObjectByContractID(Util.getNSString("@mozilla.org/spellchecker/personaldictionary;1"), nsIFactory.NS_IFACTORY_IID, lArray)) != 0) {
            PersonalDictionaryHelper.doError(n);
        }
        if (lArray[0] == 0L) {
            PersonalDictionaryHelper.doError(-2147467262);
        }
        originalDictionaryFactory = new nsIFactory(lArray[0]);
        n = nsIComponentManager2.QueryInterface(nsIComponentRegistrar.NS_ICOMPONENTREGISTRAR_IID, lArray);
        if (n != 0) {
            PersonalDictionaryHelper.doError(n);
        }
        if (lArray[0] == 0L) {
            PersonalDictionaryHelper.doError(-2147467262);
        }
        nsIComponentRegistrar nsIComponentRegistrar2 = new nsIComponentRegistrar(lArray[0]);
        PersonalDictionaryFactory personalDictionaryFactory = new PersonalDictionaryFactory();
        personalDictionaryFactory.AddRef();
        n = nsIComponentRegistrar2.RegisterFactory(mozIPersonalDictionary.MOZ_PERSONALDICTIONARY_IID, Util.getNSString("PersonalDictionary Factory"), Util.getNSString("@mozilla.org/spellchecker/personaldictionary;1"), personalDictionaryFactory.getAddress());
        if (n != 0) {
            PersonalDictionaryHelper.doError(n);
        }
        personalDictionaryFactory.Release();
        nsIComponentRegistrar2.Release();
        nsIComponentManager2.Release();
        return personalDictionaryFactory;
    }

    public static void Release() {
        if (personalDictionaryFactory != null) {
            personalDictionaryFactory.Release();
            personalDictionaryFactory = null;
        }
        if (originalDictionaryFactory != null) {
            originalDictionaryFactory.Release();
            originalDictionaryFactory = null;
        }
    }

    private static void doError(int n) {
        MozillaEmbed.doError(n);
    }
}

