/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsian.swt.internal.composer;

import org.eclipsian.swt.composer.ISelection;
import org.eclipsian.swt.internal.composer.GeckoEditor;
import org.eclipsian.swt.internal.composer.MozillaEmbed;
import org.eclipsian.swt.internal.composer.NodeImpl;
import org.eclipsian.swt.internal.composer.RangeImpl;
import org.eclipsian.swt.internal.composer.Util;
import org.eclipsian.swt.internal.composer.dom.ElementCreator;
import org.eclipsian.swt.internal.mozilla.nsIDOMNode;
import org.eclipsian.swt.internal.mozilla.nsIDOMRange;
import org.eclipsian.swt.internal.mozilla.nsISelection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.Range;

final class SelectionImpl
implements ISelection {
    private GeckoEditor editor;
    private nsISelection selection;

    SelectionImpl(GeckoEditor geckoEditor, nsISelection nsISelection2) {
        this.selection = nsISelection2;
        this.editor = geckoEditor;
    }

    public boolean equals(Object object) {
        if (object instanceof SelectionImpl) {
            return this.selection.getAddress() == ((SelectionImpl)object).selection.getAddress();
        }
        return super.equals(object);
    }

    public int hashCode() {
        return (int)this.selection.getAddress();
    }

    public String toString() {
        long[] lArray = new long[1];
        int n = this.selection.ToString(lArray);
        if (n != 0) {
            MozillaEmbed.doWarning("Selection:toString() error=" + n);
            return null;
        }
        if (lArray[0] == 0L) {
            return null;
        }
        return Util.getWString(lArray[0]);
    }

    public Node getAnchorNode() {
        long[] lArray = new long[1];
        int n = this.selection.getAnchorNode(lArray);
        if (n != 0) {
            throw new DOMException(15, "call failed");
        }
        if (lArray[0] == 0L) {
            return null;
        }
        return ElementCreator.createElement(new NodeImpl(this.editor, new nsIDOMNode(lArray[0])));
    }

    public int getAnchorOffset() {
        long[] lArray = new long[1];
        int n = this.selection.getAnchorOffset(lArray);
        if (n != 0) {
            throw new DOMException(15, "call failed");
        }
        return (int)lArray[0];
    }

    public Node getFocusNode() {
        long[] lArray = new long[1];
        int n = this.selection.getFocusNode(lArray);
        if (n != 0) {
            throw new DOMException(15, "call failed");
        }
        if (lArray[0] == 0L) {
            return null;
        }
        return ElementCreator.createElement(new NodeImpl(this.editor, new nsIDOMNode(lArray[0])));
    }

    public int getFocusOffset() {
        long[] lArray = new long[1];
        int n = this.selection.getFocusOffset(lArray);
        if (n != 0) {
            throw new DOMException(15, "call failed");
        }
        return (int)lArray[0];
    }

    public boolean isCollapsed() {
        boolean[] blArray = new boolean[1];
        int n = this.selection.getIsCollapsed(blArray);
        if (n != 0) {
            throw new DOMException(15, "call failed");
        }
        return blArray[0];
    }

    public int rangeCount() {
        long[] lArray = new long[1];
        int n = this.selection.getRangeCount(lArray);
        if (n != 0) {
            throw new DOMException(15, "call failed");
        }
        return (int)lArray[0];
    }

    public Range getRangeAt(int n) {
        long[] lArray = new long[1];
        int n2 = this.selection.GetRangeAt(n, lArray);
        if (n2 != 0 || lArray[0] == 0L) {
            throw new DOMException(15, "call failed");
        }
        return new RangeImpl(this.editor, new nsIDOMRange(lArray[0]));
    }

    public void collapse(Node node, int n) {
        int n2 = this.selection.Collapse(((NodeImpl)node).node.getAddress(), n);
        if (n2 != 0) {
            throw new DOMException(15, "call failed");
        }
    }

    public void extend(Node node, int n) {
        int n2 = this.selection.Extend(((NodeImpl)node).node.getAddress(), n);
        if (n2 != 0) {
            throw new DOMException(15, "call failed");
        }
    }

    public void collapseToStart() {
        int n = this.selection.CollapseToStart();
        if (n != 0) {
            throw new DOMException(15, "call failed");
        }
    }

    public void collapseToEnd() {
        int n = this.selection.CollapseToEnd();
        if (n != 0) {
            throw new DOMException(15, "call failed");
        }
    }

    public boolean containsNode(Node node, boolean bl) {
        boolean[] blArray = new boolean[1];
        int n = this.selection.ContainsNode(((NodeImpl)node).node.getAddress(), bl, blArray);
        if (n != 0) {
            throw new DOMException(15, "call failed");
        }
        return blArray[0];
    }

    public void selectAllChildren(Node node) {
        int n = this.selection.SelectAllChildren(((NodeImpl)node).node.getAddress());
        if (n != 0) {
            throw new DOMException(15, "call failed");
        }
    }

    public void addRange(Range range) {
        int n = this.selection.AddRange(((RangeImpl)range).range.getAddress());
        if (n != 0) {
            throw new DOMException(15, "call failed");
        }
    }

    public void removeRange(Range range) {
        int n = this.selection.RemoveRange(((RangeImpl)range).range.getAddress());
        if (n != 0) {
            throw new DOMException(15, "call failed");
        }
    }

    public void removeAllRanges() {
        int n = this.selection.RemoveAllRanges();
        if (n != 0) {
            throw new DOMException(15, "call failed");
        }
    }

    public void deleteFromDocument() {
        int n = this.selection.DeleteFromDocument();
        if (n != 0) {
            throw new DOMException(15, "call failed");
        }
    }

    public void insertElement(Element element, boolean bl) {
        this.editor.insertElementAtSelection(element, bl);
    }

    public void selectElement(Element element) {
        this.editor.selectElement(element);
    }

    public void pasteHTML(String string) {
        this.editor.pasteHTML(string);
    }

    public Element getSelectionContainer() {
        return this.editor.getSelectionContainer();
    }

    public void setCaretAfterElement(Element element) {
        this.editor.setCaretAfterElement(element);
    }

    void Release() {
        this.selection.Release();
    }

    public void scrollSelectionIntoView(boolean bl) {
        this.editor.scrollSelectionIntoView(bl);
    }

    public void beginningOfDocument() {
        this.editor.beginningOfDocument();
    }

    public void endOfDocument() {
        this.editor.endOfDocument();
    }

    public Element getResizedElement() {
        return this.editor.getResizedElement();
    }

    public Element getSingleCellSelection() {
        return this.editor.getSingleCellSelection();
    }
}

