/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsian.swt.internal.composer;

import org.eclipsian.swt.composer.ISelection;
import org.eclipsian.swt.internal.composer.CustomEditorCommand;
import org.eclipsian.swt.internal.composer.GeckoEditor;
import org.eclipsian.swt.internal.composer.NodeImpl;
import org.eclipsian.swt.internal.composer.TableEditorHelper;
import org.eclipsian.swt.internal.composer.dom.ElementCreator;
import org.eclipsian.swt.internal.mozilla.nsIDOMElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TableEditorCommand
extends CustomEditorCommand {
    private static final String TAG_TABLE = "table";
    public static final TableEditorCommand INSERT_ROW_ABOVE = new TableEditorCommand("insertRowBefore");
    public static final TableEditorCommand INSERT_ROW_BELOW = new TableEditorCommand("insertRowAfter");
    public static final TableEditorCommand INSERT_COLUMN_BEFORE = new TableEditorCommand("insertColumnBefore");
    public static final TableEditorCommand INSERT_COLUMN_AFTER = new TableEditorCommand("insertColumnAfter");
    public static final TableEditorCommand INSERT_CELL_BEFORE = new TableEditorCommand("insertCellBefore");
    public static final TableEditorCommand INSERT_CELL_AFTER = new TableEditorCommand("insertCellAfter");
    public static final TableEditorCommand DELETE_ROW = new TableEditorCommand("deleteRow");
    public static final TableEditorCommand DELETE_COLUMN = new TableEditorCommand("deleteColumn");
    public static final TableEditorCommand DELETE_CELL = new TableEditorCommand("deleteCell");
    public static final TableEditorCommand DELETE_TABLE = new TableEditorCommand("deleteTable");
    public static final TableEditorCommand SELECT_ROW = new TableEditorCommand("selectRow");
    public static final TableEditorCommand SELECT_COLUMN = new TableEditorCommand("selectColumn");
    public static final TableEditorCommand SELECT_CELL = new TableEditorCommand("selectCell");
    public static final TableEditorCommand SELECT_TABLE = new TableEditorCommand("selectTable");
    public static final TableEditorCommand JOIN_CELLS = new TableEditorCommand("joinCells");
    public static final TableEditorCommand SPLIT_CELL = new TableEditorCommand("splitCell");
    public static final TableEditorCommand IS_SINGLE_CELL = new TableEditorCommand("isSingleCell");
    private String command;

    private TableEditorCommand(String string) {
        this.command = string;
    }

    public int getCommandState(GeckoEditor geckoEditor) {
        if (geckoEditor.isEditorReady() && geckoEditor.getEditor().getElementOrParentByTagName(TAG_TABLE, null) != null) {
            if (this.command.equals("joinCells")) {
                if (this.isJoinCellsCommandEnabled(geckoEditor)) {
                    return 1;
                }
                return 0;
            }
            if (this.command.equals("splitCell")) {
                if (this.isSplitCellsCommandEnabled(geckoEditor)) {
                    return 1;
                }
                return 0;
            }
            if (this.command.equals("isSingleCell")) {
                if (this.isSingleCell(geckoEditor)) {
                    return 1;
                }
                return 0;
            }
            return 1;
        }
        return 0;
    }

    public void execCommand(GeckoEditor geckoEditor) {
        if (this.getCommandState(geckoEditor) != 1) {
            return;
        }
        TableEditorHelper tableEditorHelper = geckoEditor.getTableEditor();
        if (this.command.startsWith("insert")) {
            boolean bl = this.command.endsWith("After");
            if (this.command.indexOf("Row") != -1) {
                tableEditorHelper.insertTableRow(1, bl);
            } else if (this.command.indexOf("Column") != -1) {
                tableEditorHelper.insertTableColumn(1, bl);
            } else {
                tableEditorHelper.insertTableCell(1, bl);
            }
        } else if (this.command.startsWith("delete")) {
            if (this.command.indexOf("Table") != -1) {
                tableEditorHelper.deleteTable();
            } else if (this.command.indexOf("Row") != -1) {
                tableEditorHelper.deleteTableRow(1);
            } else if (this.command.indexOf("Column") != -1) {
                tableEditorHelper.deleteTableColumn(1);
            } else if (this.command.indexOf("Cell") != -1) {
                tableEditorHelper.deleteTableCell(1);
            }
        } else if (this.command.startsWith("select")) {
            if (this.command.indexOf("Table") != -1) {
                tableEditorHelper.selectTable();
            } else if (this.command.indexOf("Row") != -1) {
                tableEditorHelper.selectTableRow();
            } else if (this.command.indexOf("Column") != -1) {
                tableEditorHelper.selectTableColumn();
            } else if (this.command.indexOf("Cell") != -1) {
                tableEditorHelper.selectTableCell();
            }
        } else if (this.command.equals("joinCells")) {
            tableEditorHelper.joinTableCells(false);
        } else if (this.command.equals("splitCell")) {
            tableEditorHelper.splitTableCell();
        }
    }

    private boolean isSingleCell(GeckoEditor geckoEditor) {
        Object[] objectArray = geckoEditor.getTableEditor().getSelectedOrParentTableElement();
        Element element = objectArray[0] != null ? (Element)ElementCreator.createElement(new NodeImpl(geckoEditor, (nsIDOMElement)objectArray[0])) : null;
        String string = (String)objectArray[1];
        Integer n = (Integer)objectArray[2];
        return element != null && "td".equalsIgnoreCase(string) && n <= 1 && this.isSelectionInOneCell(geckoEditor);
    }

    private boolean isSplitCellsCommandEnabled(GeckoEditor geckoEditor) {
        Object[] objectArray = geckoEditor.getTableEditor().getSelectedOrParentTableElement();
        Element element = objectArray[0] != null ? (Element)ElementCreator.createElement(new NodeImpl(geckoEditor, (nsIDOMElement)objectArray[0])) : null;
        String string = (String)objectArray[1];
        Integer n = (Integer)objectArray[2];
        if (element != null && "td".equalsIgnoreCase(string) && n <= 1 && this.isSelectionInOneCell(geckoEditor)) {
            String string2 = element.getAttribute("colspan");
            int n2 = 1;
            if (string2 != null) {
                try {
                    n2 = Integer.parseInt(string2.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            }
            String string3 = element.getAttribute("rowspan");
            int n3 = 1;
            if (string3 != null) {
                try {
                    n3 = Integer.parseInt(string3.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return n2 > 1 || n3 > 1 || n2 == 0 || n3 == 0;
        }
        return false;
    }

    private boolean isSelectionInOneCell(GeckoEditor geckoEditor) {
        ISelection iSelection = geckoEditor.getSelection();
        if (iSelection.rangeCount() == 1) {
            Node node = iSelection.getAnchorNode();
            Node node2 = iSelection.getFocusNode();
            if (!iSelection.isCollapsed() && node != null && node2 != null && !node.equals(node2)) {
                Element element = geckoEditor.getElementOrParentByTagName("td", node);
                Element element2 = geckoEditor.getElementOrParentByTagName("td", node2);
                return element2 != null && element != null && element2.equals(element);
            }
            return true;
        }
        return false;
    }

    private boolean isJoinCellsCommandEnabled(GeckoEditor geckoEditor) {
        Object[] objectArray = geckoEditor.getTableEditor().getSelectedOrParentTableElement();
        Element element = objectArray[0] != null ? (Element)ElementCreator.createElement(new NodeImpl(geckoEditor, (nsIDOMElement)objectArray[0])) : null;
        String string = (String)objectArray[1];
        Integer n = (Integer)objectArray[2];
        if (element != null && "td".equalsIgnoreCase(string)) {
            if (n > 1) {
                return true;
            }
            String string2 = element.getAttribute("colspan");
            int n2 = 1;
            if (string2 != null) {
                try {
                    n2 = Integer.parseInt(string2.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return n2 != 0 && this.getCellAtAnotherColumn(element, n2) != null;
        }
        return false;
    }

    private Element getCellAtAnotherColumn(Element element, int n) {
        int n2 = 0;
        Node node = element.getNextSibling();
        while (node != null) {
            String string;
            if (node.getNodeType() == 1 && ("td".equalsIgnoreCase(string = node.getNodeName()) || "th".equalsIgnoreCase(string)) && ++n2 == n) {
                return (Element)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }
}

