/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsian.swt.internal.composer;

import org.eclipsian.swt.internal.OS;
import org.eclipsian.swt.internal.composer.TooltipTextProviderHelper;
import org.eclipsian.swt.internal.mozilla.XPCOM;
import org.eclipsian.swt.internal.mozilla.XPCOMObject;
import org.eclipsian.swt.internal.mozilla.nsID;
import org.eclipsian.swt.internal.mozilla.nsIDOMNode;
import org.eclipsian.swt.internal.mozilla.nsISupportsWeakReference;
import org.eclipsian.swt.internal.mozilla.nsITooltipTextProvider;
import org.eclipsian.swt.internal.mozilla.nsIWeakReference;

public class TooltipTextProvider {
    private XPCOMObject supportsWeakReference;
    private XPCOMObject weakReference;
    private XPCOMObject tooltipTextProvider;
    private int refCount = 0;
    private long tooltipText = 0L;

    TooltipTextProvider() {
        this.createCOMInterfaces();
    }

    void createCOMInterfaces() {
        int[] nArray = new int[4];
        nArray[0] = 2;
        nArray[3] = 1;
        this.supportsWeakReference = new XPCOMObject(nArray){

            public long method0(long[] lArray) {
                return TooltipTextProvider.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return TooltipTextProvider.this.AddRef();
            }

            public long method2(long[] lArray) {
                return TooltipTextProvider.this.Release();
            }

            public long method3(long[] lArray) {
                return TooltipTextProvider.this.GetWeakReference(lArray[0]);
            }
        };
        int[] nArray2 = new int[4];
        nArray2[0] = 2;
        nArray2[3] = 2;
        this.weakReference = new XPCOMObject(nArray2){

            public long method0(long[] lArray) {
                return TooltipTextProvider.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return TooltipTextProvider.this.AddRef();
            }

            public long method2(long[] lArray) {
                return TooltipTextProvider.this.Release();
            }

            public long method3(long[] lArray) {
                return TooltipTextProvider.this.QueryReferent(lArray[0], lArray[1]);
            }
        };
        int[] nArray3 = new int[4];
        nArray3[0] = 2;
        nArray3[3] = 3;
        this.tooltipTextProvider = new XPCOMObject(nArray3){

            public long method0(long[] lArray) {
                return TooltipTextProvider.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return TooltipTextProvider.this.AddRef();
            }

            public long method2(long[] lArray) {
                return TooltipTextProvider.this.Release();
            }

            public long method3(long[] lArray) {
                return TooltipTextProvider.this.GetNodeText(lArray[0], lArray[1], lArray[2]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.tooltipText != 0L) {
            XPCOM.PR_Free(this.tooltipText);
            this.tooltipText = 0L;
        }
        if (this.tooltipTextProvider != null) {
            this.tooltipTextProvider.dispose();
            this.tooltipTextProvider = null;
        }
        if (this.weakReference != null) {
            this.weakReference.dispose();
            this.weakReference = null;
        }
        if (this.supportsWeakReference != null) {
            this.supportsWeakReference.dispose();
            this.supportsWeakReference = null;
        }
    }

    long getAddress() {
        return this.tooltipTextProvider.getAddress();
    }

    long QueryInterface(long l, long l2) {
        if (l == 0L || l2 == 0L) {
            return -2147467262L;
        }
        nsID nsID2 = new nsID();
        XPCOM.memmove(nsID2, l, 16);
        if (nsID2.Equals(nsISupportsWeakReference.NS_ISUPPORTSWEAKREFERENCE_IID)) {
            XPCOM.memmove(l2, new long[]{this.supportsWeakReference.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        if (nsID2.Equals(nsIWeakReference.NS_IWEAKREFERENCE_IID)) {
            XPCOM.memmove(l2, new long[]{this.weakReference.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        if (nsID2.Equals(nsITooltipTextProvider.NS_ITOOLTIPTEXTPROVIDER_IID)) {
            XPCOM.memmove(l2, new long[]{this.tooltipTextProvider.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        XPCOM.memmove(l2, new long[1], OS.PTR_SIZEOF);
        return -2147467262L;
    }

    long AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    long Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    long QueryReferent(long l, long l2) {
        return this.QueryInterface(l, l2);
    }

    long GetWeakReference(long l) {
        XPCOM.memmove(l, new long[]{this.weakReference.getAddress()}, OS.PTR_SIZEOF);
        this.AddRef();
        return 0L;
    }

    long GetNodeText(long l, long l2, long l3) {
        String string;
        if (this.tooltipText != 0L) {
            XPCOM.PR_Free(this.tooltipText);
            this.tooltipText = 0L;
        }
        if ((string = TooltipTextProviderHelper.getNodeText(new nsIDOMNode(l))) != null) {
            char[] cArray = new char[string.length() + 1];
            string.getChars(0, string.length(), cArray, 0);
            this.tooltipText = XPCOM.PR_Malloc(cArray.length * 2);
            XPCOM.memmove(this.tooltipText, cArray, cArray.length * 2);
            XPCOM.memmove(l2, new long[]{this.tooltipText}, OS.PTR_SIZEOF);
        }
        XPCOM.memmove(l3, new long[]{string != null ? 1 : 0}, 4);
        return 0L;
    }
}

