/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.generator.commons.aql.condition;

import org.ehrbase.openehr.sdk.generator.commons.aql.condition.And;
import org.ehrbase.openehr.sdk.generator.commons.aql.condition.ComparisonOperator;
import org.ehrbase.openehr.sdk.generator.commons.aql.condition.ComparisonOperatorSymbol;
import org.ehrbase.openehr.sdk.generator.commons.aql.condition.Exists;
import org.ehrbase.openehr.sdk.generator.commons.aql.condition.Matches;
import org.ehrbase.openehr.sdk.generator.commons.aql.condition.Not;
import org.ehrbase.openehr.sdk.generator.commons.aql.condition.Or;
import org.ehrbase.openehr.sdk.generator.commons.aql.containment.Containment;
import org.ehrbase.openehr.sdk.generator.commons.aql.field.SelectAqlField;
import org.ehrbase.openehr.sdk.generator.commons.aql.parameter.Parameter;

public interface Condition {
    default public Condition and(Condition condition) {
        return Condition.and(this, condition);
    }

    default public Condition or(Condition condition) {
        return Condition.or(this, condition);
    }

    default public Condition not() {
        return Condition.not(this);
    }

    public static <T> Condition equal(SelectAqlField<T> field, T value) {
        return ComparisonOperator.valueComparison(field, ComparisonOperatorSymbol.EQ.getSymbol(), value);
    }

    public static <T> Condition equal(SelectAqlField<T> field, Parameter<T> parameter) {
        return ComparisonOperator.parameterComparison(field, ComparisonOperatorSymbol.EQ.getSymbol(), parameter);
    }

    public static <T> Condition equal(SelectAqlField<T> field, SelectAqlField<T> compareField) {
        return ComparisonOperator.fieldComparison(field, ComparisonOperatorSymbol.EQ.getSymbol(), compareField);
    }

    public static <T> Condition notEqual(SelectAqlField<T> field, T value) {
        return ComparisonOperator.valueComparison(field, ComparisonOperatorSymbol.NEQ.getSymbol(), value);
    }

    public static <T> Condition notEqual(SelectAqlField<T> field, Parameter<T> parameter) {
        return ComparisonOperator.parameterComparison(field, ComparisonOperatorSymbol.NEQ.getSymbol(), parameter);
    }

    public static <T> Condition notEqual(SelectAqlField<T> field, SelectAqlField<T> compareField) {
        return ComparisonOperator.fieldComparison(field, ComparisonOperatorSymbol.NEQ.getSymbol(), compareField);
    }

    public static <T> Condition greaterOrEqual(SelectAqlField<T> field, T value) {
        return ComparisonOperator.valueComparison(field, ComparisonOperatorSymbol.GT_EQ.getSymbol(), value);
    }

    public static <T> Condition greaterOrEqual(SelectAqlField<T> field, Parameter<T> parameter) {
        return ComparisonOperator.parameterComparison(field, ComparisonOperatorSymbol.GT_EQ.getSymbol(), parameter);
    }

    public static <T> Condition greaterOrEqual(SelectAqlField<T> field, SelectAqlField<T> compareField) {
        return ComparisonOperator.fieldComparison(field, ComparisonOperatorSymbol.GT_EQ.getSymbol(), compareField);
    }

    public static <T> Condition greaterThan(SelectAqlField<T> field, T value) {
        return ComparisonOperator.valueComparison(field, ComparisonOperatorSymbol.GT.getSymbol(), value);
    }

    public static <T> Condition greaterThan(SelectAqlField<T> field, Parameter<T> parameter) {
        return ComparisonOperator.parameterComparison(field, ComparisonOperatorSymbol.GT.getSymbol(), parameter);
    }

    public static <T> Condition greaterThan(SelectAqlField<T> field, SelectAqlField<T> compareField) {
        return ComparisonOperator.fieldComparison(field, ComparisonOperatorSymbol.GT.getSymbol(), compareField);
    }

    public static <T> Condition lessOrEqual(SelectAqlField<T> field, T value) {
        return ComparisonOperator.valueComparison(field, ComparisonOperatorSymbol.LT_EQ.getSymbol(), value);
    }

    public static <T> Condition lessOrEqual(SelectAqlField<T> field, Parameter<T> parameter) {
        return ComparisonOperator.parameterComparison(field, ComparisonOperatorSymbol.LT_EQ.getSymbol(), parameter);
    }

    public static <T> Condition lessOrEqual(SelectAqlField<T> field, SelectAqlField<T> compareField) {
        return ComparisonOperator.fieldComparison(field, ComparisonOperatorSymbol.LT_EQ.getSymbol(), compareField);
    }

    public static <T> Condition lessThan(SelectAqlField<T> field, T value) {
        return ComparisonOperator.valueComparison(field, ComparisonOperatorSymbol.LT.getSymbol(), value);
    }

    public static <T> Condition lessThCan(SelectAqlField<T> field, Parameter<T> parameter) {
        return ComparisonOperator.parameterComparison(field, ComparisonOperatorSymbol.LT.getSymbol(), parameter);
    }

    public static <T> Condition lessThan(SelectAqlField<T> field, SelectAqlField<T> compareField) {
        return ComparisonOperator.fieldComparison(field, ComparisonOperatorSymbol.LT.getSymbol(), compareField);
    }

    public static <T> Condition matches(SelectAqlField<T> field, T ... value) {
        return new Matches<T>(field, value);
    }

    @SafeVarargs
    public static <T> Condition matches(SelectAqlField<T> field, Parameter<T> ... parameter) {
        return new Matches<T>(field, parameter);
    }

    public static Condition and(Condition condition1, Condition condition2) {
        return new And(condition1, condition2);
    }

    public static Condition or(Condition condition1, Condition condition2) {
        return new Or(condition1, condition2);
    }

    public static Condition not(Condition condition) {
        return new Not(condition);
    }

    public static Condition exists(SelectAqlField<?> field) {
        return new Exists(field);
    }

    public static <T> Condition like(SelectAqlField<T> field, T value) {
        return ComparisonOperator.valueComparison(field, "like", value);
    }

    public static <T> Condition like(SelectAqlField<T> field, Parameter<T> parameter) {
        return ComparisonOperator.parameterComparison(field, "like", parameter);
    }

    public String buildAql(Containment var1);
}

