/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.generator.commons.aql.parameter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.nedap.archie.json.JacksonUtil;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.openehr.sdk.util.exception.SdkException;

public class AqlValue {
    private final Object value;

    public AqlValue(Object value) {
        Objects.requireNonNull(value);
        this.value = value;
    }

    public String buildAql() {
        if (Long.class.isAssignableFrom(this.value.getClass()) || Integer.class.isAssignableFrom(this.value.getClass())) {
            return this.value.toString();
        }
        if (Double.class.isAssignableFrom(this.value.getClass()) || Float.class.isAssignableFrom(this.value.getClass())) {
            return this.value.toString();
        }
        if (Boolean.class.isAssignableFrom(this.value.getClass())) {
            return this.value.toString();
        }
        if (String.class.isAssignableFrom(this.value.getClass()) || UUID.class.isAssignableFrom(this.value.getClass())) {
            return StringUtils.wrap((String)this.value.toString(), (String)"'");
        }
        if (TemporalAccessor.class.isAssignableFrom(this.value.getClass())) {
            String valueAsString;
            try {
                valueAsString = JacksonUtil.getObjectMapper().writeValueAsString(this.value);
            }
            catch (JsonProcessingException e) {
                throw new SdkException(e.getMessage(), (Throwable)e);
            }
            return StringUtils.wrap((String)valueAsString.replace("\"", ""), (String)"'");
        }
        throw new SdkException(String.format("%s is not an valid AQL Value", this.value.getClass()));
    }
}

