/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.webtemplate.parser.config;

import com.nedap.archie.rm.composition.Composition;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ehrbase.openehr.sdk.terminology.TerminologyProvider;
import org.ehrbase.openehr.sdk.terminology.ValueSet;
import org.ehrbase.openehr.sdk.webtemplate.parser.config.RmIntrospectConfig;

public class CompositionIntrospectConfig
implements RmIntrospectConfig {
    private static final Set<String> FIELDS = Stream.of("language", "territory", "composer", "category", "feederAudit").collect(Collectors.toSet());

    public Class getAssociatedClass() {
        return Composition.class;
    }

    @Override
    public Set<String> getNonTemplateFields() {
        return FIELDS;
    }

    @Override
    public ValueSet findExternalValueSet(String fieldName) {
        switch (fieldName) {
            case "language": {
                return TerminologyProvider.findOpenEhrValueSet((String)"ISO_639-1", (String)"", (String)"en");
            }
            case "territory": {
                return TerminologyProvider.findOpenEhrValueSet((String)"ISO_3166-1", (String)"", (String)"en");
            }
            case "category": {
                return TerminologyProvider.findOpenEhrValueSet((String)"openehr", (String)"composition category", (String)"en");
            }
        }
        return ValueSet.EMPTY_VALUE_SET;
    }
}

