/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.webtemplate.webtemplateskeletonbuilder;

import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.creation.RMObjectCreator;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Archetyped;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.archetyped.TemplateId;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.composition.Entry;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.datavalues.quantity.DvInterval;
import com.nedap.archie.rm.generic.PartyIdentified;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.generic.PartyRelated;
import com.nedap.archie.rm.support.identification.ArchetypeID;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.TerminologyId;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rminfo.RMAttributeInfo;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.ehrbase.openehr.sdk.util.exception.SdkException;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplate;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;

public class WebTemplateSkeletonBuilder {
    private static final ArchieRMInfoLookup ARCHIE_RM_INFO_LOOKUP = ArchieRMInfoLookup.getInstance();
    private static final RMObjectCreator RM_OBJECT_CREATOR = new RMObjectCreator((ModelInfoLookup)ARCHIE_RM_INFO_LOOKUP);

    private WebTemplateSkeletonBuilder() {
    }

    public static Composition build(WebTemplate template, boolean withChildren) {
        Composition composition = WebTemplateSkeletonBuilder.build(template.getTree(), withChildren, Composition.class);
        Archetyped archetypeDetails = new Archetyped();
        composition.setArchetypeDetails(archetypeDetails);
        archetypeDetails.setTemplateId(new TemplateId());
        archetypeDetails.getTemplateId().setValue(template.getTemplateId());
        archetypeDetails.setRmVersion("1.0.4");
        archetypeDetails.setArchetypeId(new ArchetypeID(composition.getArchetypeNodeId()));
        return composition;
    }

    public static <T> T build(WebTemplateNode node, boolean withChildren, Class<T> clazz) {
        String rmClass = node.getRmType();
        CComplexObject elementConstraint = new CComplexObject();
        elementConstraint.setRmTypeName(rmClass);
        Object skeleton = switch (rmClass) {
            case "UID_BASED_ID" -> new HierObjectId();
            case "PARTY_PROXY" -> new PartyIdentified();
            case "STRING", "LONG" -> null;
            case "BOOLEAN" -> false;
            default -> RM_OBJECT_CREATOR.create((CObject)elementConstraint);
        };
        if (withChildren) {
            node.getChildren().stream().filter(n -> !Set.of("name", "archetype_node_id", "offset").contains(n.getId())).forEach(c -> {
                Object childObject = WebTemplateSkeletonBuilder.build(c, true, Object.class);
                WebTemplateSkeletonBuilder.insert(node, (RMObject)skeleton, c, childObject);
            });
        }
        if (skeleton instanceof Locatable) {
            Optional<WebTemplateNode> name = node.findChildById("name");
            if (name.isPresent()) {
                if (name.get().getRmType().equals("DV_CODED_TEXT")) {
                    ((Locatable)skeleton).setName((DvText)WebTemplateSkeletonBuilder.extractDefault(name.get(), DvCodedText.class).orElseThrow());
                } else {
                    ((Locatable)skeleton).setName(WebTemplateSkeletonBuilder.extractDefault(name.get(), DvText.class).orElse(new DvText(node.getName())));
                }
            } else {
                ((Locatable)skeleton).setName(new DvText(node.getName()));
            }
            ((Locatable)skeleton).setArchetypeNodeId(node.getNodeId());
        }
        if (skeleton instanceof Entry) {
            ((Entry)skeleton).setEncoding(new CodePhrase(new TerminologyId("IANA_character-sets"), "UTF-8"));
            node.findChildById("subject").map(n -> WebTemplateSkeletonBuilder.build(n, false, PartyProxy.class)).ifPresent(arg_0 -> ((Entry)((Entry)skeleton)).setSubject(arg_0));
        }
        if (skeleton instanceof Composition) {
            node.findChildById("category").flatMap(n -> WebTemplateSkeletonBuilder.extractDefault(n, DvCodedText.class)).ifPresent(arg_0 -> ((Composition)((Composition)skeleton)).setCategory(arg_0));
        }
        if (skeleton instanceof DvInterval) {
            ((DvInterval)skeleton).setLowerIncluded(true);
            ((DvInterval)skeleton).setUpperIncluded(true);
        }
        if (skeleton instanceof PartyRelated) {
            node.findChildById("relationship").flatMap(n -> WebTemplateSkeletonBuilder.extractDefault(n, DvCodedText.class)).ifPresent(arg_0 -> ((PartyRelated)((PartyRelated)skeleton)).setRelationship(arg_0));
        }
        if (skeleton == null || clazz.isAssignableFrom(skeleton.getClass())) {
            return (T)skeleton;
        }
        throw new SdkException(String.format("%s not assignable from %s", skeleton.getClass(), clazz));
    }

    public static void insert(WebTemplateNode parentNode, RMObject parentObject, WebTemplateNode childNode, Object childObject) {
        String attributeName = childNode.getAqlPathDto().removeStart(parentNode.getAqlPathDto()).getLastNode().getName();
        RM_OBJECT_CREATOR.addElementToListOrSetSingleValues((Object)parentObject, attributeName, Collections.singletonList(childObject));
    }

    public static void remove(WebTemplateNode parentNode, RMObject parentObject, WebTemplateNode childNode, Object removeChildObject) {
        String attributeName = childNode.getAqlPathDto().removeStart(parentNode.getAqlPathDto()).getLastNode().getName();
        RMAttributeInfo attributeInfo = ARCHIE_RM_INFO_LOOKUP.getAttributeInfo(parentObject.getClass(), attributeName);
        try {
            Object actualChild = attributeInfo.getGetMethod().invoke((Object)parentObject, new Object[0]);
            if (actualChild instanceof Collection) {
                ((Collection)actualChild).remove(removeChildObject);
            } else if (Objects.equals(actualChild, removeChildObject)) {
                attributeInfo.getSetMethod().invoke((Object)parentObject, new Object[]{null});
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new SdkException(e.getMessage());
        }
    }

    public static <T> Optional<T> extractDefault(WebTemplateNode node, Class<T> clazz) {
        if (node.getRmType().equals("DV_CODED_TEXT") && node.getMin() > 0) {
            return node.getInputs().stream().filter(i -> i.getSuffix().equals("code")).filter(i -> i.getList().size() == 1).findAny().map(code -> new DvCodedText(code.getList().get(0).getLabel(), new CodePhrase(new TerminologyId(code.getTerminology()), code.getList().get(0).getValue()))).map(clazz::cast);
        }
        return Optional.empty();
    }
}

