/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.reindex.AbstractAsyncBulkIndexByScrollAction;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.index.reindex.BulkIndexByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.ScrollableHitSource;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteByQueryAction
extends HandledTransportAction<DeleteByQueryRequest, BulkIndexByScrollResponse> {
    private final Client client;
    private final ScriptService scriptService;
    private final ClusterService clusterService;

    @Inject
    public TransportDeleteByQueryAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver resolver, Client client, TransportService transportService, ScriptService scriptService, ClusterService clusterService) {
        super(settings, "indices:data/write/delete/byquery", threadPool, transportService, actionFilters, resolver, DeleteByQueryRequest::new);
        this.client = client;
        this.scriptService = scriptService;
        this.clusterService = clusterService;
    }

    protected void doExecute(Task task, DeleteByQueryRequest request, ActionListener<BulkIndexByScrollResponse> listener) {
        ClusterState state = this.clusterService.state();
        ParentTaskAssigningClient client = new ParentTaskAssigningClient(this.client, this.clusterService.localNode(), task);
        new AsyncDeleteBySearchAction((BulkByScrollTask)task, this.logger, client, this.threadPool, request, listener, this.scriptService, state).start();
    }

    protected void doExecute(DeleteByQueryRequest request, ActionListener<BulkIndexByScrollResponse> listener) {
        throw new UnsupportedOperationException("task required");
    }

    static class AsyncDeleteBySearchAction
    extends AbstractAsyncBulkIndexByScrollAction<DeleteByQueryRequest> {
        public AsyncDeleteBySearchAction(BulkByScrollTask task, Logger logger, ParentTaskAssigningClient client, ThreadPool threadPool, DeleteByQueryRequest request, ActionListener<BulkIndexByScrollResponse> listener, ScriptService scriptService, ClusterState clusterState) {
            super(task, logger, client, threadPool, request, listener, scriptService, clusterState);
        }

        @Override
        protected boolean needsSourceDocumentVersions() {
            return true;
        }

        @Override
        protected boolean accept(ScrollableHitSource.Hit doc) {
            return true;
        }

        @Override
        protected AbstractAsyncBulkIndexByScrollAction.RequestWrapper<DeleteRequest> buildRequest(ScrollableHitSource.Hit doc) {
            DeleteRequest delete = new DeleteRequest();
            delete.index(doc.getIndex());
            delete.type(doc.getType());
            delete.id(doc.getId());
            delete.version(doc.getVersion());
            return AsyncDeleteBySearchAction.wrap(delete);
        }

        @Override
        protected AbstractAsyncBulkIndexByScrollAction.RequestWrapper<?> copyMetadata(AbstractAsyncBulkIndexByScrollAction.RequestWrapper<?> request, ScrollableHitSource.Hit doc) {
            request.setParent(doc.getParent());
            request.setRouting(doc.getRouting());
            return request;
        }
    }
}

