/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty3;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.network.NetworkUtils;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportServiceAdapter;
import org.elasticsearch.transport.TransportSettings;
import org.elasticsearch.transport.netty3.Netty3MessageChannelHandler;
import org.elasticsearch.transport.netty3.Netty3OpenChannelsHandler;
import org.elasticsearch.transport.netty3.Netty3SizeHeaderFrameDecoder;
import org.elasticsearch.transport.netty3.Netty3Utils;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.AdaptiveReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.FixedReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.ReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.channel.socket.oio.OioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.oio.OioServerSocketChannelFactory;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;

public class Netty3Transport
extends TcpTransport<Channel> {
    public static final Setting<Integer> WORKER_COUNT;
    public static final Setting<ByteSizeValue> NETTY_MAX_CUMULATION_BUFFER_CAPACITY;
    public static final Setting<Integer> NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS;
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_SIZE;
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_MIN;
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_MAX;
    public static final Setting<Integer> NETTY_BOSS_COUNT;
    protected final ByteSizeValue maxCumulationBufferCapacity;
    protected final int maxCompositeBufferComponents;
    protected final ReceiveBufferSizePredictorFactory receiveBufferSizePredictorFactory;
    protected final int workerCount;
    protected final ByteSizeValue receivePredictorMin;
    protected final ByteSizeValue receivePredictorMax;
    volatile Netty3OpenChannelsHandler serverOpenChannels;
    protected volatile ClientBootstrap clientBootstrap;
    protected final Map<String, ServerBootstrap> serverBootstraps = ConcurrentCollections.newConcurrentMap();

    public Netty3Transport(Settings settings, ThreadPool threadPool, NetworkService networkService, BigArrays bigArrays, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService) {
        super("netty3", settings, threadPool, bigArrays, circuitBreakerService, namedWriteableRegistry, networkService);
        this.deprecationLogger.deprecated(this.deprecationMessage(), new Object[0]);
        this.workerCount = (Integer)WORKER_COUNT.get(settings);
        this.maxCumulationBufferCapacity = (ByteSizeValue)NETTY_MAX_CUMULATION_BUFFER_CAPACITY.get(settings);
        this.maxCompositeBufferComponents = (Integer)NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS.get(settings);
        this.receivePredictorMin = (ByteSizeValue)NETTY_RECEIVE_PREDICTOR_MIN.get(settings);
        this.receivePredictorMax = (ByteSizeValue)NETTY_RECEIVE_PREDICTOR_MAX.get(settings);
        this.receiveBufferSizePredictorFactory = this.receivePredictorMax.getBytes() == this.receivePredictorMin.getBytes() ? new FixedReceiveBufferSizePredictorFactory((int)this.receivePredictorMax.getBytes()) : new AdaptiveReceiveBufferSizePredictorFactory((int)this.receivePredictorMin.getBytes(), (int)this.receivePredictorMin.getBytes(), (int)this.receivePredictorMax.getBytes());
    }

    protected String deprecationMessage() {
        return "transport type [netty3] is deprecated";
    }

    TransportServiceAdapter transportServiceAdapter() {
        return this.transportServiceAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() {
        boolean success = false;
        try {
            this.clientBootstrap = this.createClientBootstrap();
            if (((Boolean)NetworkService.NETWORK_SERVER.get(this.settings)).booleanValue()) {
                Netty3OpenChannelsHandler openChannels;
                this.serverOpenChannels = openChannels = new Netty3OpenChannelsHandler(this.logger);
                for (Map.Entry entry : this.buildProfileSettings().entrySet()) {
                    Settings settings = Settings.builder().put(this.createFallbackSettings()).put((Settings)entry.getValue()).build();
                    this.createServerBootstrap((String)entry.getKey(), settings);
                    this.bindServer((String)entry.getKey(), settings);
                }
            }
            super.doStart();
            success = true;
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    private ClientBootstrap createClientBootstrap() {
        ByteSizeValue tcpReceiveBufferSize;
        if (this.blockingClient) {
            this.clientBootstrap = new ClientBootstrap((ChannelFactory)new OioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory((Settings)this.settings, (String)"transport_client_worker"))));
        } else {
            int bossCount = (Integer)NETTY_BOSS_COUNT.get(this.settings);
            this.clientBootstrap = new ClientBootstrap((ChannelFactory)new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory((Settings)this.settings, (String)"transport_client_boss")), bossCount, (WorkerPool)new NioWorkerPool((Executor)Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory((Settings)this.settings, (String)"transport_client_worker")), this.workerCount), (Timer)new HashedWheelTimer(EsExecutors.daemonThreadFactory((Settings)this.settings, (String)"transport_client_timer"))));
        }
        this.clientBootstrap.setPipelineFactory(this.configureClientChannelPipelineFactory());
        this.clientBootstrap.setOption("connectTimeoutMillis", (Object)this.defaultConnectionProfile.getConnectTimeout().millis());
        boolean tcpNoDelay = (Boolean)TCP_NO_DELAY.get(this.settings);
        this.clientBootstrap.setOption("tcpNoDelay", (Object)tcpNoDelay);
        boolean tcpKeepAlive = (Boolean)TCP_KEEP_ALIVE.get(this.settings);
        this.clientBootstrap.setOption("keepAlive", (Object)tcpKeepAlive);
        ByteSizeValue tcpSendBufferSize = (ByteSizeValue)TCP_SEND_BUFFER_SIZE.get(this.settings);
        if (tcpSendBufferSize.getBytes() > 0L) {
            this.clientBootstrap.setOption("sendBufferSize", (Object)tcpSendBufferSize.getBytes());
        }
        if ((tcpReceiveBufferSize = (ByteSizeValue)TCP_RECEIVE_BUFFER_SIZE.get(this.settings)).getBytes() > 0L) {
            this.clientBootstrap.setOption("receiveBufferSize", (Object)tcpReceiveBufferSize.getBytes());
        }
        this.clientBootstrap.setOption("receiveBufferSizePredictorFactory", (Object)this.receiveBufferSizePredictorFactory);
        boolean reuseAddress = (Boolean)TCP_REUSE_ADDRESS.get(this.settings);
        this.clientBootstrap.setOption("reuseAddress", (Object)reuseAddress);
        return this.clientBootstrap;
    }

    private Settings createFallbackSettings() {
        ByteSizeValue fallbackTcpBufferSize;
        List fallbackPublishHost;
        Settings.Builder fallbackSettingsBuilder = Settings.builder();
        List fallbackBindHost = (List)TransportSettings.BIND_HOST.get(this.settings);
        if (!fallbackBindHost.isEmpty()) {
            fallbackSettingsBuilder.putArray("bind_host", fallbackBindHost);
        }
        if (!(fallbackPublishHost = (List)TransportSettings.PUBLISH_HOST.get(this.settings)).isEmpty()) {
            fallbackSettingsBuilder.putArray("publish_host", fallbackPublishHost);
        }
        boolean fallbackTcpNoDelay = this.settings.getAsBoolean("transport.netty.tcp_no_delay", (Boolean)NetworkService.TcpSettings.TCP_NO_DELAY.get(this.settings));
        fallbackSettingsBuilder.put("tcp_no_delay", fallbackTcpNoDelay);
        boolean fallbackTcpKeepAlive = this.settings.getAsBoolean("transport.netty.tcp_keep_alive", (Boolean)NetworkService.TcpSettings.TCP_KEEP_ALIVE.get(this.settings));
        fallbackSettingsBuilder.put("tcp_keep_alive", fallbackTcpKeepAlive);
        boolean fallbackReuseAddress = this.settings.getAsBoolean("transport.netty.reuse_address", (Boolean)NetworkService.TcpSettings.TCP_REUSE_ADDRESS.get(this.settings));
        fallbackSettingsBuilder.put("reuse_address", fallbackReuseAddress);
        ByteSizeValue fallbackTcpSendBufferSize = this.settings.getAsBytesSize("transport.netty.tcp_send_buffer_size", (ByteSizeValue)TCP_SEND_BUFFER_SIZE.get(this.settings));
        if (fallbackTcpSendBufferSize.getBytes() >= 0L) {
            fallbackSettingsBuilder.put(new Object[]{"tcp_send_buffer_size", fallbackTcpSendBufferSize});
        }
        if ((fallbackTcpBufferSize = this.settings.getAsBytesSize("transport.netty.tcp_receive_buffer_size", (ByteSizeValue)TCP_RECEIVE_BUFFER_SIZE.get(this.settings))).getBytes() >= 0L) {
            fallbackSettingsBuilder.put(new Object[]{"tcp_receive_buffer_size", fallbackTcpBufferSize});
        }
        return fallbackSettingsBuilder.build();
    }

    private void createServerBootstrap(String name, Settings settings) {
        boolean blockingServer = (Boolean)TCP_BLOCKING_SERVER.get(settings);
        String port = settings.get("port");
        String bindHost = settings.get("bind_host");
        String publishHost = settings.get("publish_host");
        String tcpNoDelay = settings.get("tcp_no_delay");
        String tcpKeepAlive = settings.get("tcp_keep_alive");
        boolean reuseAddress = settings.getAsBoolean("reuse_address", Boolean.valueOf(NetworkUtils.defaultReuseAddress()));
        ByteSizeValue tcpSendBufferSize = (ByteSizeValue)TCP_SEND_BUFFER_SIZE.getDefault(settings);
        ByteSizeValue tcpReceiveBufferSize = (ByteSizeValue)TCP_RECEIVE_BUFFER_SIZE.getDefault(settings);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("using profile[{}], worker_count[{}], port[{}], bind_host[{}], publish_host[{}], compress[{}], connect_timeout[{}], connections_per_node[{}/{}/{}/{}/{}], receive_predictor[{}->{}]", new Object[]{name, this.workerCount, port, bindHost, publishHost, this.compress, this.defaultConnectionProfile.getConnectTimeout(), this.defaultConnectionProfile.getNumConnectionsPerType(TransportRequestOptions.Type.RECOVERY), this.defaultConnectionProfile.getNumConnectionsPerType(TransportRequestOptions.Type.BULK), this.defaultConnectionProfile.getNumConnectionsPerType(TransportRequestOptions.Type.REG), this.defaultConnectionProfile.getNumConnectionsPerType(TransportRequestOptions.Type.STATE), this.defaultConnectionProfile.getNumConnectionsPerType(TransportRequestOptions.Type.PING), this.receivePredictorMin, this.receivePredictorMax});
        }
        ThreadFactory bossFactory = EsExecutors.daemonThreadFactory((Settings)this.settings, (String[])new String[]{"transport_server_boss", name});
        ThreadFactory workerFactory = EsExecutors.daemonThreadFactory((Settings)this.settings, (String[])new String[]{"transport_server_worker", name});
        ServerBootstrap serverBootstrap = blockingServer ? new ServerBootstrap((ChannelFactory)new OioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(bossFactory), (Executor)Executors.newCachedThreadPool(workerFactory))) : new ServerBootstrap((ChannelFactory)new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(bossFactory), (Executor)Executors.newCachedThreadPool(workerFactory), this.workerCount));
        serverBootstrap.setPipelineFactory(this.configureServerChannelPipelineFactory(name, settings));
        if (!"default".equals(tcpNoDelay)) {
            serverBootstrap.setOption("child.tcpNoDelay", (Object)Booleans.parseBoolean((String)tcpNoDelay, null));
        }
        if (!"default".equals(tcpKeepAlive)) {
            serverBootstrap.setOption("child.keepAlive", (Object)Booleans.parseBoolean((String)tcpKeepAlive, null));
        }
        if (tcpSendBufferSize != null && tcpSendBufferSize.getBytes() > 0L) {
            serverBootstrap.setOption("child.sendBufferSize", (Object)tcpSendBufferSize.getBytes());
        }
        if (tcpReceiveBufferSize != null && tcpReceiveBufferSize.getBytes() > 0L) {
            serverBootstrap.setOption("child.receiveBufferSize", (Object)tcpReceiveBufferSize.getBytes());
        }
        serverBootstrap.setOption("receiveBufferSizePredictorFactory", (Object)this.receiveBufferSizePredictorFactory);
        serverBootstrap.setOption("child.receiveBufferSizePredictorFactory", (Object)this.receiveBufferSizePredictorFactory);
        serverBootstrap.setOption("reuseAddress", (Object)reuseAddress);
        serverBootstrap.setOption("child.reuseAddress", (Object)reuseAddress);
        this.serverBootstraps.put(name, serverBootstrap);
    }

    protected final void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        this.onException(ctx.getChannel(), e.getCause() == null || e.getCause() instanceof Exception ? (Exception)e.getCause() : new ElasticsearchException(e.getCause()));
    }

    public long serverOpen() {
        Netty3OpenChannelsHandler channels = this.serverOpenChannels;
        return channels == null ? 0L : channels.numberOfOpenChannels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TcpTransport.NodeChannels connectToChannels(DiscoveryNode node, ConnectionProfile profile, Consumer<Channel> onChannelClose) {
        Object[] channels = new Channel[profile.getNumConnections()];
        TcpTransport.NodeChannels nodeChannels = new TcpTransport.NodeChannels((TcpTransport)this, node, channels, profile);
        boolean success = false;
        try {
            TimeValue connectTimeout;
            ClientBootstrap clientBootstrap;
            TimeValue defaultConnectTimeout = this.defaultConnectionProfile.getConnectTimeout();
            if (profile.getConnectTimeout() != null && !profile.getConnectTimeout().equals((Object)defaultConnectTimeout)) {
                clientBootstrap = new ClientBootstrap(this.clientBootstrap.getFactory());
                clientBootstrap.setPipelineFactory(this.clientBootstrap.getPipelineFactory());
                clientBootstrap.setOptions(this.clientBootstrap.getOptions());
                clientBootstrap.setOption("connectTimeoutMillis", (Object)Math.toIntExact(profile.getConnectTimeout().millis()));
                connectTimeout = profile.getConnectTimeout();
            } else {
                connectTimeout = defaultConnectTimeout;
                clientBootstrap = this.clientBootstrap;
            }
            ArrayList<ChannelFuture> connections = new ArrayList<ChannelFuture>(channels.length);
            InetSocketAddress address = ((InetSocketTransportAddress)node.getAddress()).address();
            for (int i = 0; i < channels.length; ++i) {
                connections.add(clientBootstrap.connect((SocketAddress)address));
            }
            ChannelFutureListener listener = future -> onChannelClose.accept(future.getChannel());
            Iterator iterator = connections.iterator();
            try {
                for (int i = 0; i < channels.length; ++i) {
                    assert (iterator.hasNext());
                    ChannelFuture future2 = (ChannelFuture)iterator.next();
                    future2.awaitUninterruptibly((long)((double)connectTimeout.millis() * 1.5));
                    if (!future2.isSuccess()) {
                        throw new ConnectTransportException(node, "connect_timeout[" + connectTimeout + "]", future2.getCause());
                    }
                    channels[i] = future2.getChannel();
                    channels[i].getCloseFuture().addListener(listener);
                }
                assert (!iterator.hasNext()) : "not all created connection have been consumed";
            }
            catch (RuntimeException e) {
                for (ChannelFuture future3 : Collections.unmodifiableList(connections)) {
                    future3.cancel();
                    if (future3.getChannel() == null || !future3.getChannel().isOpen()) continue;
                    try {
                        future3.getChannel().close();
                    }
                    catch (Exception exception) {}
                }
                throw e;
            }
            success = true;
        }
        finally {
            if (!success) {
                try {
                    nodeChannels.close();
                }
                catch (IOException e) {
                    this.logger.trace("exception while closing channels", (Throwable)e);
                }
            }
        }
        return nodeChannels;
    }

    public ChannelPipelineFactory configureClientChannelPipelineFactory() {
        return new ClientChannelPipelineFactory(this);
    }

    public ChannelPipelineFactory configureServerChannelPipelineFactory(String name, Settings settings) {
        return new ServerChannelPipelineFactory(this, name, settings);
    }

    protected void sendMessage(Channel channel, BytesReference reference, Runnable sendListener) {
        ChannelFuture future = channel.write((Object)Netty3Utils.toChannelBuffer(reference));
        future.addListener(future1 -> sendListener.run());
    }

    protected void closeChannels(List<Channel> channels, boolean blocking) throws IOException {
        if (blocking) {
            Netty3Utils.closeChannels(channels);
        } else {
            for (Channel channel : channels) {
                if (channel == null || !channel.isOpen()) continue;
                ChannelFuture closeFuture = channel.close();
                closeFuture.addListener(f -> {
                    if (!f.isSuccess()) {
                        this.logger.warn("failed to close channel", f.getCause());
                    }
                });
            }
        }
    }

    protected InetSocketAddress getLocalAddress(Channel channel) {
        return (InetSocketAddress)channel.getLocalAddress();
    }

    protected Channel bind(String name, InetSocketAddress address) {
        return this.serverBootstraps.get(name).bind((SocketAddress)address);
    }

    TcpTransport.ScheduledPing getPing() {
        return this.scheduledPing;
    }

    protected boolean isOpen(Channel channel) {
        return channel.isOpen();
    }

    protected void stopInternal() {
        Releasables.close((Releasable[])new Releasable[]{this.serverOpenChannels, () -> {
            for (Map.Entry<String, ServerBootstrap> entry : this.serverBootstraps.entrySet()) {
                String name = entry.getKey();
                ServerBootstrap serverBootstrap = entry.getValue();
                try {
                    serverBootstrap.releaseExternalResources();
                }
                catch (Exception e) {
                    this.logger.debug(() -> new ParameterizedMessage("Error closing serverBootstrap for profile [{}]", (Object)name), (Throwable)e);
                }
            }
            this.serverBootstraps.clear();
            if (this.clientBootstrap != null) {
                this.clientBootstrap.releaseExternalResources();
                this.clientBootstrap = null;
            }
        }});
    }

    static {
        Netty3Utils.setup();
        WORKER_COUNT = new Setting("transport.netty.worker_count", s -> Integer.toString(EsExecutors.boundedNumberOfProcessors((Settings)s) * 2), s -> Setting.parseInt((String)s, (int)1, (String)"transport.netty.worker_count"), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
        NETTY_MAX_CUMULATION_BUFFER_CAPACITY = Setting.byteSizeSetting((String)"transport.netty.max_cumulation_buffer_capacity", (ByteSizeValue)new ByteSizeValue(-1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
        NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS = Setting.intSetting((String)"transport.netty.max_composite_buffer_components", (int)-1, (int)-1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
        NETTY_RECEIVE_PREDICTOR_SIZE = Setting.byteSizeSetting((String)"transport.netty.receive_predictor_size", settings -> {
            long defaultReceiverPredictor = 524288L;
            if (JvmInfo.jvmInfo().getMem().getDirectMemoryMax().getBytes() > 0L) {
                long l = (long)(0.3 * (double)JvmInfo.jvmInfo().getMem().getDirectMemoryMax().getBytes() / (double)((Integer)WORKER_COUNT.get(settings)).intValue());
                defaultReceiverPredictor = Math.min(defaultReceiverPredictor, Math.max(l, 65536L));
            }
            return new ByteSizeValue(defaultReceiverPredictor).toString();
        }, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
        NETTY_RECEIVE_PREDICTOR_MIN = Setting.byteSizeSetting((String)"transport.netty.receive_predictor_min", NETTY_RECEIVE_PREDICTOR_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
        NETTY_RECEIVE_PREDICTOR_MAX = Setting.byteSizeSetting((String)"transport.netty.receive_predictor_max", NETTY_RECEIVE_PREDICTOR_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
        NETTY_BOSS_COUNT = Setting.intSetting((String)"transport.netty.boss_count", (int)1, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Shared});
    }

    protected static class ServerChannelPipelineFactory
    implements ChannelPipelineFactory {
        protected final Netty3Transport nettyTransport;
        protected final String name;
        protected final Settings settings;

        public ServerChannelPipelineFactory(Netty3Transport nettyTransport, String name, Settings settings) {
            this.nettyTransport = nettyTransport;
            this.name = name;
            this.settings = settings;
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline channelPipeline = Channels.pipeline();
            channelPipeline.addLast("openChannels", (ChannelHandler)this.nettyTransport.serverOpenChannels);
            Netty3SizeHeaderFrameDecoder sizeHeader = new Netty3SizeHeaderFrameDecoder();
            if (this.nettyTransport.maxCumulationBufferCapacity.getBytes() > 0L) {
                if (this.nettyTransport.maxCumulationBufferCapacity.getBytes() > Integer.MAX_VALUE) {
                    sizeHeader.setMaxCumulationBufferCapacity(Integer.MAX_VALUE);
                } else {
                    sizeHeader.setMaxCumulationBufferCapacity((int)this.nettyTransport.maxCumulationBufferCapacity.getBytes());
                }
            }
            if (this.nettyTransport.maxCompositeBufferComponents != -1) {
                sizeHeader.setMaxCumulationBufferComponents(this.nettyTransport.maxCompositeBufferComponents);
            }
            channelPipeline.addLast("size", (ChannelHandler)sizeHeader);
            channelPipeline.addLast("dispatcher", (ChannelHandler)new Netty3MessageChannelHandler(this.nettyTransport, this.name));
            return channelPipeline;
        }
    }

    protected static class ClientChannelPipelineFactory
    implements ChannelPipelineFactory {
        protected final Netty3Transport nettyTransport;

        public ClientChannelPipelineFactory(Netty3Transport nettyTransport) {
            this.nettyTransport = nettyTransport;
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline channelPipeline = Channels.pipeline();
            Netty3SizeHeaderFrameDecoder sizeHeader = new Netty3SizeHeaderFrameDecoder();
            if (this.nettyTransport.maxCumulationBufferCapacity.getBytes() >= 0L) {
                if (this.nettyTransport.maxCumulationBufferCapacity.getBytes() > Integer.MAX_VALUE) {
                    sizeHeader.setMaxCumulationBufferCapacity(Integer.MAX_VALUE);
                } else {
                    sizeHeader.setMaxCumulationBufferCapacity((int)this.nettyTransport.maxCumulationBufferCapacity.getBytes());
                }
            }
            if (this.nettyTransport.maxCompositeBufferComponents != -1) {
                sizeHeader.setMaxCumulationBufferComponents(this.nettyTransport.maxCompositeBufferComponents);
            }
            channelPipeline.addLast("size", (ChannelHandler)sizeHeader);
            channelPipeline.addLast("dispatcher", (ChannelHandler)new Netty3MessageChannelHandler(this.nettyTransport, ".client"));
            return channelPipeline;
        }
    }
}

