/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.routing.allocation.decider.ThrottlingAllocationDecider;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.test.ESTestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;

public class OldIndexUtils {
    public static List<String> loadDataFilesList(String prefix, Path bwcIndicesPath) throws IOException {
        ArrayList<String> indexes = new ArrayList<String>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(bwcIndicesPath, prefix + "-*.zip");){
            for (Path path : stream) {
                indexes.add(path.getFileName().toString());
            }
        }
        Collections.sort(indexes);
        return indexes;
    }

    public static Settings getSettings() {
        return Settings.builder().put("index.merge.enabled", false).put(ThrottlingAllocationDecider.CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_INCOMING_RECOVERIES_SETTING.getKey(), 30).put(ThrottlingAllocationDecider.CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_OUTGOING_RECOVERIES_SETTING.getKey(), 30).build();
    }

    public static Path getIndexDir(Logger logger, String indexName, String indexFile, Path dataDir) throws IOException {
        Version version = Version.fromString((String)indexName.substring("index-".length()));
        if (version.before(Version.V_5_0_0_alpha1)) {
            Path src = dataDir.resolve("nodes/0/indices/" + indexName);
            TestCase.assertTrue((String)("[" + indexFile + "] missing index dir: " + src.toString()), (boolean)Files.exists(src, new LinkOption[0]));
            return src;
        }
        ArrayList<Path> indexFolders = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dataDir.resolve("0/indices"), p -> !p.getFileName().toString().startsWith("extra"));){
            for (Path path : stream) {
                indexFolders.add(path);
            }
        }
        MatcherAssert.assertThat((String)((Object)indexFolders).toString(), (Object)indexFolders.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        IndexMetaData indexMetaData = (IndexMetaData)IndexMetaData.FORMAT.loadLatestState(logger, NamedXContentRegistry.EMPTY, new Path[]{(Path)indexFolders.get(0)});
        Assert.assertNotNull((Object)indexMetaData);
        MatcherAssert.assertThat((Object)((Path)indexFolders.get(0)).getFileName().toString(), (Matcher)CoreMatchers.equalTo((Object)indexMetaData.getIndexUUID()));
        MatcherAssert.assertThat((Object)indexMetaData.getCreationVersion(), (Matcher)CoreMatchers.equalTo((Object)version));
        return (Path)indexFolders.get(0);
    }

    public static void copyIndex(final Logger logger, final Path src, final String folderName, final Path ... dests) throws IOException {
        final Path destinationDataPath = dests[ESTestCase.randomInt(dests.length - 1)];
        for (Path dest : dests) {
            Path indexDir = dest.resolve(folderName);
            TestCase.assertFalse((boolean)Files.exists(indexDir, new LinkOption[0]));
            Files.createDirectories(indexDir, new FileAttribute[0]);
        }
        Files.walkFileTree(src, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path relativeDir = src.relativize(dir);
                for (Path dest : dests) {
                    Path destDir = dest.resolve(folderName).resolve(relativeDir);
                    Files.createDirectories(destDir, new FileAttribute[0]);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.getFileName().toString().equals("write.lock")) {
                    logger.trace("Skipping lock file: {}", (Object)file);
                    return FileVisitResult.CONTINUE;
                }
                Path relativeFile = src.relativize(file);
                Path destFile = destinationDataPath.resolve(folderName).resolve(relativeFile);
                logger.trace("--> Moving {} to {}", (Object)relativeFile, (Object)destFile);
                Files.move(file, destFile, new CopyOption[0]);
                TestCase.assertFalse((boolean)Files.exists(file, new LinkOption[0]));
                TestCase.assertTrue((boolean)Files.exists(destFile, new LinkOption[0]));
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

