/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest;

import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestRequest;

public class FakeRestRequest
extends RestRequest {
    private final BytesReference content;
    private final RestRequest.Method method;
    private final SocketAddress remoteAddress;

    public FakeRestRequest() {
        this(NamedXContentRegistry.EMPTY, new HashMap<String, List<String>>(), new HashMap<String, String>(), (BytesReference)BytesArray.EMPTY, RestRequest.Method.GET, "/", null);
    }

    private FakeRestRequest(NamedXContentRegistry xContentRegistry, Map<String, List<String>> headers, Map<String, String> params, BytesReference content, RestRequest.Method method, String path, SocketAddress remoteAddress) {
        super(xContentRegistry, params, path, headers);
        this.content = Objects.requireNonNull(content);
        this.method = method;
        this.remoteAddress = remoteAddress;
    }

    public RestRequest.Method method() {
        return this.method;
    }

    public String uri() {
        return this.rawPath();
    }

    public boolean hasContent() {
        return this.content.length() > 0;
    }

    public BytesReference innerContent() {
        return this.content;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public static class Builder {
        private final NamedXContentRegistry xContentRegistry;
        private Map<String, List<String>> headers = new HashMap<String, List<String>>();
        private Map<String, String> params = new HashMap<String, String>();
        private BytesReference content = BytesArray.EMPTY;
        private String path = "/";
        private RestRequest.Method method = RestRequest.Method.GET;
        private SocketAddress address = null;

        public Builder(NamedXContentRegistry xContentRegistry) {
            this.xContentRegistry = xContentRegistry;
        }

        public Builder withHeaders(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder withParams(Map<String, String> params) {
            this.params = params;
            return this;
        }

        public Builder withContent(BytesReference content, XContentType xContentType) {
            this.content = Objects.requireNonNull(content);
            if (xContentType != null) {
                this.headers.put("Content-Type", Collections.singletonList(xContentType.mediaType()));
            }
            return this;
        }

        public Builder withPath(String path) {
            this.path = path;
            return this;
        }

        public Builder withMethod(RestRequest.Method method) {
            this.method = method;
            return this;
        }

        public Builder withRemoteAddress(SocketAddress address) {
            this.address = address;
            return this;
        }

        public FakeRestRequest build() {
            return new FakeRestRequest(this.xContentRegistry, this.headers, this.params, this.content, this.method, this.path, this.address);
        }
    }
}

