/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.restspec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClientYamlSuiteRestPath {
    private final List<PathPart> parts;
    private final List<String> placeholders;

    public ClientYamlSuiteRestPath(List<String> parts) {
        ArrayList<PathPart> pathParts = new ArrayList<PathPart>(parts.size());
        for (String part : parts) {
            pathParts.add(new PathPart(part, false));
        }
        this.parts = pathParts;
        this.placeholders = Collections.emptyList();
    }

    public ClientYamlSuiteRestPath(String path) {
        String[] pathParts = path.split("/");
        ArrayList<String> placeholders = new ArrayList<String>();
        ArrayList<PathPart> parts = new ArrayList<PathPart>();
        for (String pathPart : pathParts) {
            if (pathPart.length() <= 0) continue;
            if (pathPart.startsWith("{")) {
                if (pathPart.indexOf(125) != pathPart.length() - 1) {
                    throw new IllegalArgumentException("more than one parameter found in the same path part: [" + pathPart + "]");
                }
                String placeholder = pathPart.substring(1, pathPart.length() - 1);
                parts.add(new PathPart(placeholder, true));
                placeholders.add(placeholder);
                continue;
            }
            parts.add(new PathPart(pathPart, false));
        }
        this.placeholders = placeholders;
        this.parts = parts;
    }

    public String[] getPathParts() {
        String[] parts = new String[this.parts.size()];
        int i = 0;
        for (PathPart part : this.parts) {
            parts[i++] = part.pathPart;
        }
        return parts;
    }

    public boolean matches(Set<String> params) {
        return this.placeholders.size() == params.size() && this.placeholders.containsAll(params);
    }

    public ClientYamlSuiteRestPath replacePlaceholders(Map<String, String> params) {
        ArrayList<String> finalPathParts = new ArrayList<String>(this.parts.size());
        for (PathPart pathPart : this.parts) {
            if (pathPart.isPlaceholder) {
                String value = params.get(pathPart.pathPart);
                if (value == null) {
                    throw new IllegalArgumentException("parameter [" + pathPart.pathPart + "] missing");
                }
                finalPathParts.add(value);
                continue;
            }
            finalPathParts.add(pathPart.pathPart);
        }
        return new ClientYamlSuiteRestPath(finalPathParts);
    }

    private static class PathPart {
        private final boolean isPlaceholder;
        private final String pathPart;

        private PathPart(String pathPart, boolean isPlaceholder) {
            this.isPlaceholder = isPlaceholder;
            this.pathPart = pathPart;
        }
    }
}

