/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.similarities.BM25Similarity;
import org.apache.lucene.search.similarities.Similarity;
import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.TermBasedFieldType;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.similarity.SimilarityProvider;
import org.elasticsearch.test.ESTestCase;

public abstract class FieldTypeTestCase
extends ESTestCase {
    private static final Settings INDEX_SETTINGS = Settings.builder().put("index.version.created", Version.CURRENT).build();
    private final List<Modifier> modifiers = new ArrayList<Modifier>(Arrays.asList(new Modifier("boost", true){

        @Override
        public void modify(MappedFieldType ft) {
            ft.setBoost(1.1f);
        }
    }, new Modifier("doc_values", false){

        @Override
        public void modify(MappedFieldType ft) {
            ft.setHasDocValues(!ft.hasDocValues());
        }
    }, new Modifier("analyzer", false){

        @Override
        public void modify(MappedFieldType ft) {
            ft.setIndexAnalyzer(new NamedAnalyzer("bar", AnalyzerScope.INDEX, (Analyzer)new StandardAnalyzer()));
        }
    }, new Modifier("analyzer", false){

        @Override
        public void modify(MappedFieldType ft) {
            ft.setIndexAnalyzer(new NamedAnalyzer("bar", AnalyzerScope.INDEX, (Analyzer)new StandardAnalyzer()));
        }

        @Override
        public void normalizeOther(MappedFieldType other) {
            other.setIndexAnalyzer(new NamedAnalyzer("foo", AnalyzerScope.INDEX, (Analyzer)new StandardAnalyzer()));
        }
    }, new Modifier("analyzer", true){

        @Override
        public void modify(MappedFieldType ft) {
            ft.setIndexAnalyzer(new NamedAnalyzer("foo", AnalyzerScope.INDEX, (Analyzer)new StandardAnalyzer()));
        }

        @Override
        public void normalizeOther(MappedFieldType other) {
            other.setIndexAnalyzer(new NamedAnalyzer("foo", AnalyzerScope.INDEX, (Analyzer)new StandardAnalyzer()));
        }
    }, new Modifier("search_analyzer", true){

        @Override
        public void modify(MappedFieldType ft) {
            ft.setSearchAnalyzer(new NamedAnalyzer("bar", AnalyzerScope.INDEX, (Analyzer)new StandardAnalyzer()));
        }
    }, new Modifier("search_analyzer", true){

        @Override
        public void modify(MappedFieldType ft) {
            ft.setSearchAnalyzer(new NamedAnalyzer("bar", AnalyzerScope.INDEX, (Analyzer)new StandardAnalyzer()));
        }

        @Override
        public void normalizeOther(MappedFieldType other) {
            other.setSearchAnalyzer(new NamedAnalyzer("foo", AnalyzerScope.INDEX, (Analyzer)new StandardAnalyzer()));
        }
    }, new Modifier("search_quote_analyzer", true){

        @Override
        public void modify(MappedFieldType ft) {
            ft.setSearchQuoteAnalyzer(new NamedAnalyzer("bar", AnalyzerScope.INDEX, (Analyzer)new StandardAnalyzer()));
        }
    }, new Modifier("search_quote_analyzer", true){

        @Override
        public void modify(MappedFieldType ft) {
            ft.setSearchQuoteAnalyzer(new NamedAnalyzer("bar", AnalyzerScope.INDEX, (Analyzer)new StandardAnalyzer()));
        }

        @Override
        public void normalizeOther(MappedFieldType other) {
            other.setSearchQuoteAnalyzer(new NamedAnalyzer("foo", AnalyzerScope.INDEX, (Analyzer)new StandardAnalyzer()));
        }
    }, new Modifier("similarity", false){

        @Override
        public void modify(MappedFieldType ft) {
            ft.setSimilarity(new SimilarityProvider("foo", (Similarity)new BM25Similarity()));
        }
    }, new Modifier("similarity", false){

        @Override
        public void modify(MappedFieldType ft) {
            ft.setSimilarity(new SimilarityProvider("foo", (Similarity)new BM25Similarity()));
        }

        @Override
        public void normalizeOther(MappedFieldType other) {
            other.setSimilarity(new SimilarityProvider("bar", (Similarity)new BM25Similarity()));
        }
    }, new Modifier("similarity", true){

        @Override
        public void modify(MappedFieldType ft) {
            ft.setSimilarity(new SimilarityProvider("foo", (Similarity)new BM25Similarity()));
        }

        @Override
        public void normalizeOther(MappedFieldType other) {
            other.setSimilarity(new SimilarityProvider("foo", (Similarity)new BM25Similarity()));
        }
    }, new Modifier("eager_global_ordinals", true){

        @Override
        public void modify(MappedFieldType ft) {
            ft.setEagerGlobalOrdinals(!ft.eagerGlobalOrdinals());
        }
    }, new Modifier("null_value", true){

        @Override
        public void modify(MappedFieldType ft) {
            ft.setNullValue(FieldTypeTestCase.this.dummyNullValue);
        }
    }));
    private Object dummyNullValue = "dummyvalue";

    protected void addModifier(Modifier modifier) {
        this.modifiers.add(modifier);
    }

    protected void setDummyNullValue(Object value) {
        this.dummyNullValue = value;
    }

    protected abstract MappedFieldType createDefaultFieldType();

    MappedFieldType createNamedDefaultFieldType() {
        MappedFieldType fieldType = this.createDefaultFieldType();
        fieldType.setName("foo");
        return fieldType;
    }

    protected void assertFieldTypeEquals(String property, MappedFieldType ft1, MappedFieldType ft2) {
        if (!ft1.equals((Object)ft2)) {
            FieldTypeTestCase.fail((String)("Expected equality, testing property " + property + "\nexpected: " + this.toString(ft1) + "; \nactual:   " + this.toString(ft2) + "\n"));
        }
    }

    protected void assertFieldTypeNotEquals(String property, MappedFieldType ft1, MappedFieldType ft2) {
        if (ft1.equals((Object)ft2)) {
            FieldTypeTestCase.fail((String)("Expected inequality, testing property " + property + "\nfirst:  " + this.toString(ft1) + "; \nsecond: " + this.toString(ft2) + "\n"));
        }
    }

    protected void assertCompatible(String msg, MappedFieldType ft1, MappedFieldType ft2, boolean strict) {
        ArrayList conflicts = new ArrayList();
        ft1.checkCompatibility(ft2, conflicts, strict);
        FieldTypeTestCase.assertTrue((String)("Found conflicts for " + msg + ": " + conflicts), (boolean)conflicts.isEmpty());
    }

    protected void assertNotCompatible(String msg, MappedFieldType ft1, MappedFieldType ft2, boolean strict, String ... messages) {
        assert (messages.length != 0);
        ArrayList conflicts = new ArrayList();
        ft1.checkCompatibility(ft2, conflicts, strict);
        for (String message : messages) {
            boolean found = false;
            for (String conflict : conflicts) {
                if (!conflict.contains(message)) continue;
                found = true;
            }
            FieldTypeTestCase.assertTrue((String)("Missing conflict for " + msg + ": [" + message + "] in conflicts " + conflicts), (boolean)found);
        }
    }

    protected String toString(MappedFieldType ft) {
        return "MappedFieldType{name=" + ft.name() + ", boost=" + ft.boost() + ", docValues=" + ft.hasDocValues() + ", indexAnalyzer=" + ft.indexAnalyzer() + ", searchAnalyzer=" + ft.searchAnalyzer() + ", searchQuoteAnalyzer=" + ft.searchQuoteAnalyzer() + ", similarity=" + ft.similarity() + ", eagerGlobalOrdinals=" + ft.eagerGlobalOrdinals() + ", nullValue=" + ft.nullValue() + ", nullValueAsString='" + ft.nullValueAsString() + "'} " + super.toString();
    }

    public void testClone() {
        MappedFieldType fieldType = this.createNamedDefaultFieldType();
        MappedFieldType clone = fieldType.clone();
        FieldTypeTestCase.assertNotSame((Object)clone, (Object)fieldType);
        FieldTypeTestCase.assertEquals(clone.getClass(), fieldType.getClass());
        FieldTypeTestCase.assertEquals((Object)clone, (Object)fieldType);
        FieldTypeTestCase.assertEquals((Object)clone, (Object)clone.clone());
        for (Modifier modifier : this.modifiers) {
            fieldType = this.createNamedDefaultFieldType();
            modifier.modify(fieldType);
            clone = fieldType.clone();
            FieldTypeTestCase.assertNotSame((Object)clone, (Object)fieldType);
            this.assertFieldTypeEquals(modifier.property, clone, fieldType);
        }
    }

    public void testEquals() {
        MappedFieldType ft1 = this.createNamedDefaultFieldType();
        MappedFieldType ft2 = this.createNamedDefaultFieldType();
        FieldTypeTestCase.assertEquals((Object)ft1, (Object)ft1);
        FieldTypeTestCase.assertEquals((Object)ft1, (Object)ft2);
        FieldTypeTestCase.assertEquals((Object)ft2, (Object)ft1);
        FieldTypeTestCase.assertEquals((long)ft1.hashCode(), (long)ft2.hashCode());
        for (Modifier modifier : this.modifiers) {
            ft1 = this.createNamedDefaultFieldType();
            ft2 = this.createNamedDefaultFieldType();
            modifier.modify(ft2);
            this.assertFieldTypeNotEquals(modifier.property, ft1, ft2);
            FieldTypeTestCase.assertNotEquals((String)("hash code for modified property " + modifier.property), (long)ft1.hashCode(), (long)ft2.hashCode());
            modifier.modify(ft1);
            this.assertFieldTypeEquals(modifier.property, ft1, ft2);
            FieldTypeTestCase.assertEquals((String)("hash code for modified property " + modifier.property), (long)ft1.hashCode(), (long)ft2.hashCode());
        }
    }

    public void testFreeze() {
        for (Modifier modifier : this.modifiers) {
            MappedFieldType fieldType = this.createNamedDefaultFieldType();
            fieldType.freeze();
            try {
                modifier.modify(fieldType);
                FieldTypeTestCase.fail((String)("expected already frozen exception for property " + modifier.property));
            }
            catch (IllegalStateException e) {
                FieldTypeTestCase.assertTrue((boolean)e.getMessage().contains("already frozen"));
            }
        }
    }

    public void testCheckTypeName() {
        final MappedFieldType fieldType = this.createNamedDefaultFieldType();
        ArrayList conflicts = new ArrayList();
        fieldType.checkCompatibility(fieldType, conflicts, FieldTypeTestCase.random().nextBoolean());
        FieldTypeTestCase.assertTrue((String)((Object)conflicts).toString(), (boolean)conflicts.isEmpty());
        TermBasedFieldType bogus = new TermBasedFieldType(){

            public MappedFieldType clone() {
                return null;
            }

            public String typeName() {
                return fieldType.typeName();
            }

            public Query existsQuery(QueryShardContext context) {
                return null;
            }
        };
        try {
            fieldType.checkCompatibility((MappedFieldType)bogus, conflicts, FieldTypeTestCase.random().nextBoolean());
            FieldTypeTestCase.fail((String)"expected bad types exception");
        }
        catch (IllegalStateException e) {
            FieldTypeTestCase.assertTrue((boolean)e.getMessage().contains("Type names equal"));
        }
        FieldTypeTestCase.assertTrue((String)((Object)conflicts).toString(), (boolean)conflicts.isEmpty());
        TermBasedFieldType other = new TermBasedFieldType(){

            public MappedFieldType clone() {
                return null;
            }

            public String typeName() {
                return "othertype";
            }

            public Query existsQuery(QueryShardContext context) {
                return null;
            }
        };
        try {
            fieldType.checkCompatibility((MappedFieldType)other, conflicts, FieldTypeTestCase.random().nextBoolean());
            FieldTypeTestCase.fail();
        }
        catch (IllegalArgumentException e) {
            FieldTypeTestCase.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("cannot be changed from type"));
        }
        FieldTypeTestCase.assertTrue((String)((Object)conflicts).toString(), (boolean)conflicts.isEmpty());
    }

    public void testCheckCompatibility() {
        MappedFieldType ft1 = this.createNamedDefaultFieldType();
        MappedFieldType ft2 = this.createNamedDefaultFieldType();
        this.assertCompatible("default", ft1, ft2, true);
        this.assertCompatible("default", ft1, ft2, false);
        this.assertCompatible("default", ft2, ft1, true);
        this.assertCompatible("default", ft2, ft1, false);
        for (Modifier modifier : this.modifiers) {
            ft1 = this.createNamedDefaultFieldType();
            ft2 = this.createNamedDefaultFieldType();
            modifier.normalizeOther(ft1);
            modifier.modify(ft2);
            if (modifier.strictOnly) {
                this.assertCompatible(modifier.property, ft1, ft2, false);
                this.assertCompatible(modifier.property, ft2, ft1, false);
                if (!ft1.equals((Object)ft2)) {
                    String[] conflicts = new String[]{"mapper [foo] is used by multiple types", "update [" + modifier.property + "]"};
                    this.assertNotCompatible(modifier.property, ft2, ft1, true, conflicts);
                    this.assertNotCompatible(modifier.property, ft1, ft2, true, conflicts);
                    continue;
                }
                this.assertCompatible(modifier.property, ft1, ft2, true);
                this.assertCompatible(modifier.property, ft2, ft1, true);
                continue;
            }
            String conflict = "different [" + modifier.property + "]";
            this.assertNotCompatible(modifier.property, ft1, ft2, true, conflict);
            this.assertNotCompatible(modifier.property, ft1, ft2, false, conflict);
            this.assertNotCompatible(modifier.property, ft2, ft1, true, conflict);
            this.assertNotCompatible(modifier.property, ft2, ft1, false, conflict);
        }
    }

    public static abstract class Modifier {
        public final String property;
        public final boolean strictOnly;

        public Modifier(String property, boolean strictOnly) {
            this.property = property;
            this.strictOnly = strictOnly;
        }

        public abstract void modify(MappedFieldType var1);

        public void normalizeOther(MappedFieldType other) {
        }
    }
}

