/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentMapperParser;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.test.ESSingleNodeTestCase;
import org.elasticsearch.test.InternalSettingsPlugin;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;

public abstract class AbstractNumericFieldMapperTestCase
extends ESSingleNodeTestCase {
    protected Set<String> TYPES;
    protected Set<String> WHOLE_TYPES;
    protected IndexService indexService;
    protected DocumentMapperParser parser;

    @Before
    public void setup() {
        this.indexService = this.createIndex("test");
        this.parser = this.indexService.mapperService().documentMapperParser();
        this.setTypeList();
    }

    @Override
    protected Collection<Class<? extends Plugin>> getPlugins() {
        return this.pluginList(InternalSettingsPlugin.class);
    }

    protected abstract void setTypeList();

    public void testDefaults() throws Exception {
        for (String type : this.TYPES) {
            this.doTestDefaults(type);
        }
    }

    protected abstract void doTestDefaults(String var1) throws Exception;

    public void testNotIndexed() throws Exception {
        for (String type : this.TYPES) {
            this.doTestNotIndexed(type);
        }
    }

    protected abstract void doTestNotIndexed(String var1) throws Exception;

    public void testNoDocValues() throws Exception {
        for (String type : this.TYPES) {
            this.doTestNoDocValues(type);
        }
    }

    protected abstract void doTestNoDocValues(String var1) throws Exception;

    public void testStore() throws Exception {
        for (String type : this.TYPES) {
            this.doTestStore(type);
        }
    }

    protected abstract void doTestStore(String var1) throws Exception;

    public void testCoerce() throws Exception {
        for (String type : this.TYPES) {
            this.doTestCoerce(type);
        }
    }

    protected abstract void doTestCoerce(String var1) throws IOException;

    public void testDecimalCoerce() throws Exception {
        for (String type : this.WHOLE_TYPES) {
            this.doTestDecimalCoerce(type);
        }
    }

    protected abstract void doTestDecimalCoerce(String var1) throws IOException;

    public void testNullValue() throws IOException {
        for (String type : this.TYPES) {
            this.doTestNullValue(type);
        }
    }

    protected abstract void doTestNullValue(String var1) throws IOException;

    public void testEmptyName() throws IOException {
        for (String type : this.TYPES) {
            String mapping = Strings.toString((XContentBuilder)XContentFactory.jsonBuilder().startObject().startObject("type").startObject("properties").startObject("").field("type", type).endObject().endObject().endObject().endObject());
            IllegalArgumentException e = (IllegalArgumentException)AbstractNumericFieldMapperTestCase.expectThrows(IllegalArgumentException.class, () -> this.parser.parse("type", new CompressedXContent(mapping)));
            AbstractNumericFieldMapperTestCase.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"name cannot be empty string"));
        }
    }

    public void testMeta() throws Exception {
        for (String type : this.TYPES) {
            IndexService indexService = this.createIndex("test-" + type);
            String mapping = Strings.toString((XContentBuilder)XContentFactory.jsonBuilder().startObject().startObject("_doc").startObject("properties").startObject("field").field("type", type).field("meta", Collections.singletonMap("foo", "bar")).endObject().endObject().endObject().endObject());
            DocumentMapper mapper = indexService.mapperService().merge("_doc", new CompressedXContent(mapping), MapperService.MergeReason.MAPPING_UPDATE);
            AbstractNumericFieldMapperTestCase.assertEquals((Object)mapping, (Object)mapper.mappingSource().toString());
            String mapping2 = Strings.toString((XContentBuilder)XContentFactory.jsonBuilder().startObject().startObject("_doc").startObject("properties").startObject("field").field("type", type).endObject().endObject().endObject().endObject());
            mapper = indexService.mapperService().merge("_doc", new CompressedXContent(mapping2), MapperService.MergeReason.MAPPING_UPDATE);
            AbstractNumericFieldMapperTestCase.assertEquals((Object)mapping2, (Object)mapper.mappingSource().toString());
            String mapping3 = Strings.toString((XContentBuilder)XContentFactory.jsonBuilder().startObject().startObject("_doc").startObject("properties").startObject("field").field("type", type).field("meta", Collections.singletonMap("baz", "quux")).endObject().endObject().endObject().endObject());
            mapper = indexService.mapperService().merge("_doc", new CompressedXContent(mapping3), MapperService.MergeReason.MAPPING_UPDATE);
            AbstractNumericFieldMapperTestCase.assertEquals((Object)mapping3, (Object)mapper.mappingSource().toString());
        }
    }
}

