/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.hamcrest;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequestBuilder;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.alias.exists.AliasesExistResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.action.support.master.AcknowledgedRequestBuilder;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.test.NotEqualMessageBuilder;
import org.elasticsearch.test.hamcrest.ElasticsearchMatchers;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.CombinableMatcher;
import org.junit.Assert;

public class ElasticsearchAssertions {
    public static void assertAcked(AcknowledgedRequestBuilder<?, ?, ?> builder) {
        ElasticsearchAssertions.assertAcked((AcknowledgedResponse)builder.get());
    }

    public static void assertNoTimeout(ClusterHealthRequestBuilder requestBuilder) {
        ElasticsearchAssertions.assertNoTimeout((ClusterHealthResponse)requestBuilder.get());
    }

    public static void assertNoTimeout(ClusterHealthResponse response) {
        MatcherAssert.assertThat((String)("ClusterHealthResponse has timed out - returned: [" + response + "]"), (Object)response.isTimedOut(), (Matcher)CoreMatchers.is((Object)false));
    }

    public static void assertAcked(AcknowledgedResponse response) {
        MatcherAssert.assertThat((String)(response.getClass().getSimpleName() + " failed - not acked"), (Object)response.isAcknowledged(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    public static void assertAcked(DeleteIndexRequestBuilder builder) {
        ElasticsearchAssertions.assertAcked((AcknowledgedResponse)builder.get());
    }

    public static void assertAcked(CreateIndexResponse response) {
        MatcherAssert.assertThat((String)(response.getClass().getSimpleName() + " failed - not acked"), (Object)response.isAcknowledged(), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertTrue((String)(response.getClass().getSimpleName() + " failed - index creation acked but not all shards were started"), (boolean)response.isShardsAcknowledged());
    }

    public static void assertBlocked(ActionRequestBuilder builder) {
        ElasticsearchAssertions.assertBlocked(builder, (ClusterBlock)null);
    }

    public static void assertBlocked(BroadcastResponse replicatedBroadcastResponse) {
        MatcherAssert.assertThat((String)"all shard requests should have failed", (Object)replicatedBroadcastResponse.getFailedShards(), (Matcher)CoreMatchers.equalTo((Object)replicatedBroadcastResponse.getTotalShards()));
        for (DefaultShardOperationFailedException exception : replicatedBroadcastResponse.getShardFailures()) {
            ClusterBlockException clusterBlockException = (ClusterBlockException)ExceptionsHelper.unwrap((Throwable)exception.getCause(), (Class[])new Class[]{ClusterBlockException.class});
            Assert.assertNotNull((String)("expected the cause of failure to be a ClusterBlockException but got " + exception.getCause().getMessage()), (Object)clusterBlockException);
            MatcherAssert.assertThat((Object)clusterBlockException.blocks().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
            MatcherAssert.assertThat((Object)clusterBlockException.status(), (Matcher)CoreMatchers.equalTo((Object)RestStatus.FORBIDDEN));
        }
    }

    public static void assertBlocked(ActionRequestBuilder builder, @Nullable Integer expectedBlockId) {
        block3: {
            try {
                builder.get();
                Assert.fail((String)"Request executed with success but a ClusterBlockException was expected");
            }
            catch (ClusterBlockException e) {
                MatcherAssert.assertThat((Object)e.blocks().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
                MatcherAssert.assertThat((Object)e.status(), (Matcher)CoreMatchers.equalTo((Object)RestStatus.FORBIDDEN));
                if (expectedBlockId == null) break block3;
                boolean found = false;
                for (ClusterBlock clusterBlock : e.blocks()) {
                    if (clusterBlock.id() != expectedBlockId.intValue()) continue;
                    found = true;
                    break;
                }
                MatcherAssert.assertThat((String)("Request should have been blocked by [" + expectedBlockId + "] instead of " + e.blocks()), (Object)found, (Matcher)CoreMatchers.equalTo((Object)true));
            }
        }
    }

    public static void assertBlocked(ActionRequestBuilder builder, @Nullable ClusterBlock expectedBlock) {
        ElasticsearchAssertions.assertBlocked(builder, expectedBlock != null ? Integer.valueOf(expectedBlock.id()) : null);
    }

    public static String formatShardStatus(BroadcastResponse response) {
        StringBuilder msg = new StringBuilder();
        msg.append(" Total shards: ").append(response.getTotalShards()).append(" Successful shards: ").append(response.getSuccessfulShards()).append(" & ").append(response.getFailedShards()).append(" shard failures:");
        for (DefaultShardOperationFailedException failure : response.getShardFailures()) {
            msg.append("\n ").append(failure);
        }
        return msg.toString();
    }

    public static String formatShardStatus(SearchResponse response) {
        StringBuilder msg = new StringBuilder();
        msg.append(" Total shards: ").append(response.getTotalShards()).append(" Successful shards: ").append(response.getSuccessfulShards()).append(" & ").append(response.getFailedShards()).append(" shard failures:");
        for (ShardSearchFailure failure : response.getShardFailures()) {
            msg.append("\n ").append(failure);
        }
        return msg.toString();
    }

    public static void assertNoSearchHits(SearchResponse searchResponse) {
        Assert.assertEquals((long)0L, (long)searchResponse.getHits().getHits().length);
    }

    public static void assertSearchHits(SearchResponse searchResponse, String ... ids) {
        String shardStatus = ElasticsearchAssertions.formatShardStatus(searchResponse);
        HashSet<String> idsSet = new HashSet<String>(Arrays.asList(ids));
        for (SearchHit hit : searchResponse.getHits()) {
            MatcherAssert.assertThat((String)("id [" + hit.getId() + "] was found in search results but wasn't expected (type [" + hit.getType() + "], index [" + hit.getIndex() + "])" + shardStatus), (Object)idsSet.remove(hit.getId()), (Matcher)CoreMatchers.equalTo((Object)true));
        }
        MatcherAssert.assertThat((String)("Some expected ids were not found in search results: " + Arrays.toString(idsSet.toArray(new String[idsSet.size()])) + "." + shardStatus), (Object)idsSet.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    public static void assertSortValues(SearchResponse searchResponse, Object[] ... sortValues) {
        ElasticsearchAssertions.assertSearchResponse(searchResponse);
        SearchHit[] hits = searchResponse.getHits().getHits();
        Assert.assertEquals((long)sortValues.length, (long)hits.length);
        for (int i = 0; i < sortValues.length; ++i) {
            Object[] hitsSortValues = hits[i].getSortValues();
            Assert.assertArrayEquals((String)("Offset " + Integer.toString(i) + ", id " + hits[i].getId()), (Object[])sortValues[i], (Object[])hitsSortValues);
        }
    }

    public static void assertOrderedSearchHits(SearchResponse searchResponse, String ... ids) {
        String shardStatus = ElasticsearchAssertions.formatShardStatus(searchResponse);
        MatcherAssert.assertThat((String)("Expected different hit count. " + shardStatus), (Object)searchResponse.getHits().getHits().length, (Matcher)CoreMatchers.equalTo((Object)ids.length));
        for (int i = 0; i < ids.length; ++i) {
            SearchHit hit = searchResponse.getHits().getHits()[i];
            MatcherAssert.assertThat((String)("Expected id: " + ids[i] + " at position " + i + " but wasn't." + shardStatus), (Object)hit.getId(), (Matcher)CoreMatchers.equalTo((Object)ids[i]));
        }
    }

    public static void assertHitCount(SearchResponse countResponse, long expectedHitCount) {
        TotalHits totalHits = countResponse.getHits().getTotalHits();
        if (totalHits.relation != TotalHits.Relation.EQUAL_TO || totalHits.value != expectedHitCount) {
            Assert.fail((String)("Count is " + totalHits + " but " + expectedHitCount + " was expected. " + ElasticsearchAssertions.formatShardStatus(countResponse)));
        }
    }

    public static void assertExists(GetResponse response) {
        String message = String.format(Locale.ROOT, "Expected %s/%s/%s to exist, but does not", response.getIndex(), response.getType(), response.getId());
        MatcherAssert.assertThat((String)message, (Object)response.isExists(), (Matcher)CoreMatchers.is((Object)true));
    }

    public static void assertFirstHit(SearchResponse searchResponse, Matcher<SearchHit> matcher) {
        ElasticsearchAssertions.assertSearchHit(searchResponse, 1, matcher);
    }

    public static void assertSecondHit(SearchResponse searchResponse, Matcher<SearchHit> matcher) {
        ElasticsearchAssertions.assertSearchHit(searchResponse, 2, matcher);
    }

    public static void assertThirdHit(SearchResponse searchResponse, Matcher<SearchHit> matcher) {
        ElasticsearchAssertions.assertSearchHit(searchResponse, 3, matcher);
    }

    public static void assertFourthHit(SearchResponse searchResponse, Matcher<SearchHit> matcher) {
        ElasticsearchAssertions.assertSearchHit(searchResponse, 4, matcher);
    }

    public static void assertSearchHit(SearchResponse searchResponse, int number, Matcher<SearchHit> matcher) {
        MatcherAssert.assertThat((Object)number, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((String)"SearchHit number must be greater than 0", (Object)number, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(number)));
        MatcherAssert.assertThat((Object)searchResponse.getHits().getAt(number - 1), matcher);
    }

    public static void assertNoFailures(SearchResponse searchResponse) {
        MatcherAssert.assertThat((String)("Unexpected ShardFailures: " + Arrays.toString(searchResponse.getShardFailures())), (Object)searchResponse.getShardFailures().length, (Matcher)CoreMatchers.equalTo((Object)0));
    }

    public static void assertFailures(SearchResponse searchResponse) {
        MatcherAssert.assertThat((String)"Expected at least one shard failure, got none", (Object)searchResponse.getShardFailures().length, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    public static void assertNoFailures(BulkResponse response) {
        MatcherAssert.assertThat((String)("Unexpected ShardFailures: " + response.buildFailureMessage()), (Object)response.hasFailures(), (Matcher)CoreMatchers.is((Object)false));
    }

    public static void assertFailures(SearchRequestBuilder searchRequestBuilder, RestStatus restStatus, Matcher<String> reasonMatcher) {
        try {
            SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.get();
            MatcherAssert.assertThat((String)"Expected shard failures, got none", (Object)searchResponse.getShardFailures().length, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
            for (ShardSearchFailure shardSearchFailure : searchResponse.getShardFailures()) {
                MatcherAssert.assertThat((Object)shardSearchFailure.status(), (Matcher)CoreMatchers.equalTo((Object)restStatus));
                MatcherAssert.assertThat((Object)shardSearchFailure.reason(), reasonMatcher);
            }
        }
        catch (SearchPhaseExecutionException e) {
            MatcherAssert.assertThat((Object)e.status(), (Matcher)CoreMatchers.equalTo((Object)restStatus));
            MatcherAssert.assertThat((Object)e.toString(), reasonMatcher);
            for (ShardSearchFailure shardSearchFailure : e.shardFailures()) {
                MatcherAssert.assertThat((Object)shardSearchFailure.status(), (Matcher)CoreMatchers.equalTo((Object)restStatus));
                MatcherAssert.assertThat((Object)shardSearchFailure.reason(), reasonMatcher);
            }
        }
        catch (Exception e) {
            Assert.fail((String)("SearchPhaseExecutionException expected but got " + e.getClass()));
        }
    }

    public static void assertNoFailures(BroadcastResponse response) {
        MatcherAssert.assertThat((String)("Unexpected ShardFailures: " + Arrays.toString(response.getShardFailures())), (Object)response.getFailedShards(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    public static void assertAllSuccessful(BroadcastResponse response) {
        ElasticsearchAssertions.assertNoFailures(response);
        MatcherAssert.assertThat((String)"Expected all shards successful", (Object)response.getSuccessfulShards(), (Matcher)CoreMatchers.equalTo((Object)response.getTotalShards()));
    }

    public static void assertAllSuccessful(SearchResponse response) {
        ElasticsearchAssertions.assertNoFailures(response);
        MatcherAssert.assertThat((String)"Expected all shards successful", (Object)response.getSuccessfulShards(), (Matcher)CoreMatchers.equalTo((Object)response.getTotalShards()));
    }

    public static void assertHighlight(SearchResponse resp, int hit, String field, int fragment, Matcher<String> matcher) {
        ElasticsearchAssertions.assertHighlight(resp, hit, field, fragment, (Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(fragment)), matcher);
    }

    public static void assertHighlight(SearchResponse resp, int hit, String field, int fragment, int totalFragments, Matcher<String> matcher) {
        ElasticsearchAssertions.assertHighlight(resp, hit, field, fragment, (Matcher<Integer>)CoreMatchers.equalTo((Object)totalFragments), matcher);
    }

    public static void assertHighlight(SearchHit hit, String field, int fragment, Matcher<String> matcher) {
        ElasticsearchAssertions.assertHighlight(hit, field, fragment, (Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(fragment)), matcher);
    }

    public static void assertHighlight(SearchHit hit, String field, int fragment, int totalFragments, Matcher<String> matcher) {
        ElasticsearchAssertions.assertHighlight(hit, field, fragment, (Matcher<Integer>)CoreMatchers.equalTo((Object)totalFragments), matcher);
    }

    private static void assertHighlight(SearchResponse resp, int hit, String field, int fragment, Matcher<Integer> fragmentsMatcher, Matcher<String> matcher) {
        ElasticsearchAssertions.assertNoFailures(resp);
        MatcherAssert.assertThat((String)"not enough hits", (Object)resp.getHits().getHits().length, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(hit)));
        ElasticsearchAssertions.assertHighlight(resp.getHits().getHits()[hit], field, fragment, fragmentsMatcher, matcher);
    }

    private static void assertHighlight(SearchHit hit, String field, int fragment, Matcher<Integer> fragmentsMatcher, Matcher<String> matcher) {
        MatcherAssert.assertThat((Object)hit.getHighlightFields(), (Matcher)Matchers.hasKey((Object)field));
        MatcherAssert.assertThat((Object)((HighlightField)hit.getHighlightFields().get(field)).fragments().length, fragmentsMatcher);
        MatcherAssert.assertThat((Object)((HighlightField)hit.getHighlightFields().get(field)).fragments()[fragment].string(), matcher);
    }

    public static void assertNotHighlighted(SearchResponse resp, int hit, String field) {
        ElasticsearchAssertions.assertNoFailures(resp);
        MatcherAssert.assertThat((String)"not enough hits", (Object)resp.getHits().getHits().length, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(hit)));
        MatcherAssert.assertThat((Object)resp.getHits().getHits()[hit].getHighlightFields(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)field)));
    }

    public static void assertSuggestionSize(Suggest searchSuggest, int entry, int size, String key) {
        MatcherAssert.assertThat((Object)searchSuggest, (Matcher)Matchers.notNullValue());
        String msg = "Suggest result: " + searchSuggest.toString();
        MatcherAssert.assertThat((String)msg, (Object)searchSuggest.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        MatcherAssert.assertThat((String)msg, (Object)searchSuggest.getSuggestion(key).getName(), (Matcher)CoreMatchers.equalTo((Object)key));
        MatcherAssert.assertThat((String)msg, (Object)searchSuggest.getSuggestion(key).getEntries().size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(entry)));
        MatcherAssert.assertThat((String)msg, (Object)((Suggest.Suggestion.Entry)searchSuggest.getSuggestion(key).getEntries().get(entry)).getOptions().size(), (Matcher)CoreMatchers.equalTo((Object)size));
    }

    public static void assertSuggestionPhraseCollateMatchExists(Suggest searchSuggest, String key, int numberOfPhraseExists) {
        int counter = 0;
        MatcherAssert.assertThat((Object)searchSuggest, (Matcher)Matchers.notNullValue());
        String msg = "Suggest result: " + searchSuggest.toString();
        MatcherAssert.assertThat((String)msg, (Object)searchSuggest.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        MatcherAssert.assertThat((String)msg, (Object)searchSuggest.getSuggestion(key).getName(), (Matcher)CoreMatchers.equalTo((Object)key));
        for (Suggest.Suggestion.Entry.Option option : ((Suggest.Suggestion.Entry)searchSuggest.getSuggestion(key).getEntries().get(0)).getOptions()) {
            if (!option.collateMatch()) continue;
            ++counter;
        }
        MatcherAssert.assertThat((Object)counter, (Matcher)CoreMatchers.equalTo((Object)numberOfPhraseExists));
    }

    public static void assertSuggestion(Suggest searchSuggest, int entry, int ord, String key, String text) {
        MatcherAssert.assertThat((Object)searchSuggest, (Matcher)Matchers.notNullValue());
        String msg = "Suggest result: " + searchSuggest.toString();
        MatcherAssert.assertThat((String)msg, (Object)searchSuggest.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        MatcherAssert.assertThat((String)msg, (Object)searchSuggest.getSuggestion(key).getName(), (Matcher)CoreMatchers.equalTo((Object)key));
        MatcherAssert.assertThat((String)msg, (Object)searchSuggest.getSuggestion(key).getEntries().size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(entry)));
        MatcherAssert.assertThat((String)msg, (Object)((Suggest.Suggestion.Entry)searchSuggest.getSuggestion(key).getEntries().get(entry)).getOptions().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(ord)));
        MatcherAssert.assertThat((String)msg, (Object)((Suggest.Suggestion.Entry.Option)((Suggest.Suggestion.Entry)searchSuggest.getSuggestion(key).getEntries().get(entry)).getOptions().get(ord)).getText().string(), (Matcher)CoreMatchers.equalTo((Object)text));
    }

    public static void assertSuggestion(Suggest searchSuggest, int entry, String key, String ... text) {
        ElasticsearchAssertions.assertSuggestion(searchSuggest, entry, key, text.length, text);
    }

    public static void assertSuggestion(Suggest searchSuggest, int entry, String key, int size, String ... text) {
        ElasticsearchAssertions.assertSuggestionSize(searchSuggest, entry, size, key);
        for (int i = 0; i < text.length; ++i) {
            ElasticsearchAssertions.assertSuggestion(searchSuggest, entry, i, key, text[i]);
        }
    }

    public static void assertIndexTemplateMissing(GetIndexTemplatesResponse templatesResponse, String name) {
        ArrayList<String> templateNames = new ArrayList<String>();
        for (IndexTemplateMetaData indexTemplateMetaData : templatesResponse.getIndexTemplates()) {
            templateNames.add(indexTemplateMetaData.name());
        }
        MatcherAssert.assertThat(templateNames, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)name)));
    }

    public static void assertIndexTemplateExists(GetIndexTemplatesResponse templatesResponse, String name) {
        ArrayList<String> templateNames = new ArrayList<String>();
        for (IndexTemplateMetaData indexTemplateMetaData : templatesResponse.getIndexTemplates()) {
            templateNames.add(indexTemplateMetaData.name());
        }
        MatcherAssert.assertThat(templateNames, (Matcher)Matchers.hasItem((Object)name));
    }

    public static void assertAliasesMissing(AliasesExistResponse aliasesExistResponse) {
        Assert.assertFalse((String)"Aliases shouldn't exist", (boolean)aliasesExistResponse.exists());
    }

    public static void assertAliasesExist(AliasesExistResponse aliasesExistResponse) {
        Assert.assertTrue((String)"Aliases should exist", (boolean)aliasesExistResponse.exists());
    }

    public static Matcher<SearchHit> hasId(String id) {
        return new ElasticsearchMatchers.SearchHitHasIdMatcher(id);
    }

    public static Matcher<SearchHit> hasType(String type) {
        return new ElasticsearchMatchers.SearchHitHasTypeMatcher(type);
    }

    public static Matcher<SearchHit> hasIndex(String index) {
        return new ElasticsearchMatchers.SearchHitHasIndexMatcher(index);
    }

    public static Matcher<SearchHit> hasScore(float score) {
        return new ElasticsearchMatchers.SearchHitHasScoreMatcher(score);
    }

    public static <T, V> CombinableMatcher<T> hasProperty(Function<? super T, ? extends V> property, Matcher<V> valueMatcher) {
        return ElasticsearchMatchers.HasPropertyLambdaMatcher.hasProperty(property, valueMatcher);
    }

    public static Function<SearchHit, Object> fieldFromSource(String fieldName) {
        return response -> response.getSourceAsMap().get(fieldName);
    }

    public static <T extends Query> T assertBooleanSubQuery(Query query, Class<T> subqueryType, int i) {
        MatcherAssert.assertThat((Object)query, (Matcher)Matchers.instanceOf(BooleanQuery.class));
        BooleanQuery q = (BooleanQuery)query;
        MatcherAssert.assertThat((Object)q.clauses().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(i)));
        MatcherAssert.assertThat((Object)((BooleanClause)q.clauses().get(i)).getQuery(), (Matcher)Matchers.instanceOf(subqueryType));
        return (T)((Query)subqueryType.cast(((BooleanClause)q.clauses().get(i)).getQuery()));
    }

    public static <T extends Query> T assertDisjunctionSubQuery(Query query, Class<T> subqueryType, int i) {
        MatcherAssert.assertThat((Object)query, (Matcher)Matchers.instanceOf(DisjunctionMaxQuery.class));
        DisjunctionMaxQuery q = (DisjunctionMaxQuery)query;
        MatcherAssert.assertThat((Object)q.getDisjuncts().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(i)));
        MatcherAssert.assertThat((Object)((Query)q.getDisjuncts().get(i)), (Matcher)Matchers.instanceOf(subqueryType));
        return (T)((Query)subqueryType.cast(q.getDisjuncts().get(i)));
    }

    public static <E extends Throwable> void assertThrows(ActionRequestBuilder<?, ?> builder, Class<E> exceptionClass) {
        ElasticsearchAssertions.assertThrows(builder.execute(), exceptionClass);
    }

    public static <E extends Throwable> void assertThrows(ActionRequestBuilder<?, ?> builder, Class<E> exceptionClass, RestStatus status) {
        ElasticsearchAssertions.assertThrows(builder.execute(), exceptionClass, status);
    }

    public static <E extends Throwable> void assertThrows(ActionRequestBuilder<?, ?> builder, Class<E> exceptionClass, String extraInfo) {
        ElasticsearchAssertions.assertThrows(builder.execute(), exceptionClass, extraInfo);
    }

    public static <E extends Throwable> void assertThrows(ActionFuture future, Class<E> exceptionClass) {
        ElasticsearchAssertions.assertThrows(future, exceptionClass, null, null);
    }

    public static <E extends Throwable> void assertThrows(ActionFuture future, Class<E> exceptionClass, RestStatus status) {
        ElasticsearchAssertions.assertThrows(future, exceptionClass, status, null);
    }

    public static <E extends Throwable> void assertThrows(ActionFuture future, Class<E> exceptionClass, String extraInfo) {
        ElasticsearchAssertions.assertThrows(future, exceptionClass, null, extraInfo);
    }

    public static <E extends Throwable> void assertThrows(ActionFuture future, Class<E> exceptionClass, @Nullable RestStatus status, @Nullable String extraInfo) {
        boolean fail;
        block6: {
            fail = false;
            extraInfo = extraInfo == null || extraInfo.isEmpty() ? "" : extraInfo + ": ";
            extraInfo = extraInfo + "expected a " + exceptionClass + " exception to be thrown";
            if (status != null) {
                extraInfo = extraInfo + " with status [" + status + "]";
            }
            try {
                future.actionGet();
                fail = true;
            }
            catch (ElasticsearchException esException) {
                MatcherAssert.assertThat((String)extraInfo, (Object)esException.unwrapCause(), (Matcher)Matchers.instanceOf(exceptionClass));
                if (status != null) {
                    MatcherAssert.assertThat((String)extraInfo, (Object)ExceptionsHelper.status((Throwable)esException), (Matcher)CoreMatchers.equalTo((Object)status));
                }
            }
            catch (Exception e) {
                MatcherAssert.assertThat((String)extraInfo, (Object)e, (Matcher)Matchers.instanceOf(exceptionClass));
                if (status == null) break block6;
                MatcherAssert.assertThat((String)extraInfo, (Object)ExceptionsHelper.status((Throwable)e), (Matcher)CoreMatchers.equalTo((Object)status));
            }
        }
        if (fail) {
            throw new AssertionError((Object)extraInfo);
        }
    }

    public static <E extends Throwable> void assertThrows(ActionRequestBuilder<?, ?> builder, RestStatus status) {
        ElasticsearchAssertions.assertThrows(builder.execute(), status);
    }

    public static <E extends Throwable> void assertThrows(ActionRequestBuilder<?, ?> builder, RestStatus status, String extraInfo) {
        ElasticsearchAssertions.assertThrows(builder.execute(), status, extraInfo);
    }

    public static <E extends Throwable> void assertThrows(ActionFuture future, RestStatus status) {
        ElasticsearchAssertions.assertThrows(future, status, null);
    }

    public static void assertThrows(ActionFuture future, RestStatus status, String extraInfo) {
        boolean fail = false;
        extraInfo = extraInfo == null || extraInfo.isEmpty() ? "" : extraInfo + ": ";
        extraInfo = extraInfo + "expected a " + status + " status exception to be thrown";
        try {
            future.actionGet();
            fail = true;
        }
        catch (Exception e) {
            MatcherAssert.assertThat((String)extraInfo, (Object)ExceptionsHelper.status((Throwable)e), (Matcher)CoreMatchers.equalTo((Object)status));
        }
        if (fail) {
            throw new AssertionError((Object)extraInfo);
        }
    }

    public static SearchResponse assertSearchResponse(SearchRequestBuilder request) {
        return ElasticsearchAssertions.assertSearchResponse((SearchResponse)request.get());
    }

    public static SearchResponse assertSearchResponse(SearchResponse response) {
        ElasticsearchAssertions.assertNoFailures(response);
        return response;
    }

    public static void assertFileExists(Path file) {
        MatcherAssert.assertThat((String)("file/dir [" + file + "] should exist."), (Object)Files.exists(file, new LinkOption[0]), (Matcher)CoreMatchers.is((Object)true));
    }

    public static void assertFileNotExists(Path file) {
        MatcherAssert.assertThat((String)("file/dir [" + file + "] should not exist."), (Object)Files.exists(file, new LinkOption[0]), (Matcher)CoreMatchers.is((Object)false));
    }

    public static void assertToXContentEquivalent(BytesReference expected, BytesReference actual, XContentType xContentType) throws IOException {
        Map actualMap = null;
        Map expectedMap = null;
        try (XContentParser actualParser = xContentType.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (InputStream)actual.streamInput());){
            actualMap = actualParser.map();
            try (XContentParser expectedParser = xContentType.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (InputStream)expected.streamInput());){
                expectedMap = expectedParser.map();
                try {
                    ElasticsearchAssertions.assertMapEquals(expectedMap, actualMap);
                }
                catch (AssertionError error) {
                    NotEqualMessageBuilder message = new NotEqualMessageBuilder();
                    message.compareMaps(actualMap, expectedMap);
                    throw new AssertionError("Error when comparing xContent.\n" + message.toString(), (Throwable)((Object)error));
                }
            }
        }
    }

    public static void awaitLatch(CountDownLatch latch, long timeout, TimeUnit unit) throws InterruptedException {
        TimeValue timeValue = new TimeValue(timeout, unit);
        String message = String.format(Locale.ROOT, "expected latch to be counted down after %s, but was not", timeValue);
        boolean isCountedDown = latch.await(timeout, unit);
        MatcherAssert.assertThat((String)message, (Object)isCountedDown, (Matcher)CoreMatchers.is((Object)true));
    }

    private static void assertMapEquals(Map<String, Object> expected, Map<String, Object> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (Map.Entry<String, Object> expectedEntry : expected.entrySet()) {
            String expectedKey = expectedEntry.getKey();
            Object expectedValue = expectedEntry.getValue();
            if (expectedValue == null) {
                Assert.assertTrue((actual.get(expectedKey) == null && actual.containsKey(expectedKey) ? 1 : 0) != 0);
                continue;
            }
            Object actualValue = actual.get(expectedKey);
            ElasticsearchAssertions.assertObjectEquals(expectedValue, actualValue);
        }
    }

    private static void assertListEquals(List<Object> expected, List<Object> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        Iterator<Object> actualIterator = actual.iterator();
        for (Object expectedValue : expected) {
            Object actualValue = actualIterator.next();
            ElasticsearchAssertions.assertObjectEquals(expectedValue, actualValue);
        }
    }

    private static void assertObjectEquals(Object expected, Object actual) {
        if (expected instanceof Map) {
            MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.instanceOf(Map.class));
            ElasticsearchAssertions.assertMapEquals((Map)expected, (Map)actual);
        } else if (expected instanceof List) {
            ElasticsearchAssertions.assertListEquals((List)expected, (List)actual);
        } else if (expected instanceof byte[]) {
            Assert.assertArrayEquals((byte[])((byte[])expected), (byte[])((byte[])actual));
        } else {
            Assert.assertEquals((Object)expected, (Object)actual);
        }
    }
}

