/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.util.LuceneTestCase;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.coordination.ApplyCommitRequest;
import org.elasticsearch.cluster.coordination.CoordinationMetaData;
import org.elasticsearch.cluster.coordination.CoordinationState;
import org.elasticsearch.cluster.coordination.CoordinationStateRejectedException;
import org.elasticsearch.cluster.coordination.ElectionStrategy;
import org.elasticsearch.cluster.coordination.InMemoryPersistedState;
import org.elasticsearch.cluster.coordination.Join;
import org.elasticsearch.cluster.coordination.PublishRequest;
import org.elasticsearch.cluster.coordination.PublishResponse;
import org.elasticsearch.cluster.coordination.StartJoinRequest;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.test.ESTestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class CoordinationStateTestCluster {
    final ElectionStrategy electionStrategy;
    final List<Message> messages;
    final List<ClusterNode> clusterNodes;
    final CoordinationMetaData.VotingConfiguration initialConfiguration;
    final long initialValue;

    public static ClusterState clusterState(long term, long version, DiscoveryNode localNode, CoordinationMetaData.VotingConfiguration lastCommittedConfig, CoordinationMetaData.VotingConfiguration lastAcceptedConfig, long value) {
        return CoordinationStateTestCluster.clusterState(term, version, DiscoveryNodes.builder().add(localNode).localNodeId(localNode.getId()).build(), lastCommittedConfig, lastAcceptedConfig, value);
    }

    public static ClusterState clusterState(long term, long version, DiscoveryNodes discoveryNodes, CoordinationMetaData.VotingConfiguration lastCommittedConfig, CoordinationMetaData.VotingConfiguration lastAcceptedConfig, long value) {
        return CoordinationStateTestCluster.setValue(ClusterState.builder((ClusterName)ClusterName.DEFAULT).version(version).nodes(discoveryNodes).metaData(MetaData.builder().clusterUUID(UUIDs.randomBase64UUID((Random)LuceneTestCase.random())).coordinationMetaData(CoordinationMetaData.builder().term(term).lastCommittedConfiguration(lastCommittedConfig).lastAcceptedConfiguration(lastAcceptedConfig).build())).stateUUID(UUIDs.randomBase64UUID((Random)LuceneTestCase.random())).build(), value);
    }

    public static ClusterState setValue(ClusterState clusterState, long value) {
        return ClusterState.builder((ClusterState)clusterState).metaData(MetaData.builder((MetaData)clusterState.metaData()).persistentSettings(Settings.builder().put(clusterState.metaData().persistentSettings()).put("value", value).build()).build()).build();
    }

    public static long value(ClusterState clusterState) {
        return clusterState.metaData().persistentSettings().getAsLong("value", Long.valueOf(0L));
    }

    CoordinationStateTestCluster(List<DiscoveryNode> nodes, ElectionStrategy electionStrategy) {
        this.electionStrategy = electionStrategy;
        this.messages = new ArrayList<Message>();
        this.clusterNodes = nodes.stream().map(node -> new ClusterNode((DiscoveryNode)node, electionStrategy)).collect(Collectors.toList());
        this.initialConfiguration = this.randomVotingConfig();
        this.initialValue = ESTestCase.randomLong();
    }

    void reply(Message m, Object payload) {
        this.messages.add(new Message(m.targetNode, m.sourceNode, payload));
    }

    void broadcast(DiscoveryNode sourceNode, Object payload) {
        this.messages.addAll(this.clusterNodes.stream().map(cn -> new Message(sourceNode, cn.localNode, payload)).collect(Collectors.toList()));
    }

    Optional<ClusterNode> getNode(DiscoveryNode node) {
        return this.clusterNodes.stream().filter(cn -> cn.localNode.equals((Object)node)).findFirst();
    }

    CoordinationMetaData.VotingConfiguration randomVotingConfig() {
        return new CoordinationMetaData.VotingConfiguration(ESTestCase.randomSubsetOf(ESTestCase.randomIntBetween(1, this.clusterNodes.size()), this.clusterNodes).stream().map(cn -> cn.localNode.getId()).collect(Collectors.toSet()));
    }

    void applyMessage(Message message) {
        Optional<ClusterNode> maybeNode = this.getNode(message.targetNode);
        if (!maybeNode.isPresent()) {
            throw new CoordinationStateRejectedException("node not available", new Object[0]);
        }
        Object payload = message.payload;
        if (payload instanceof StartJoinRequest) {
            this.reply(message, maybeNode.get().state.handleStartJoin((StartJoinRequest)payload));
        } else if (payload instanceof Join) {
            maybeNode.get().state.handleJoin((Join)payload);
        } else if (payload instanceof PublishRequest) {
            this.reply(message, maybeNode.get().state.handlePublishRequest((PublishRequest)payload));
        } else if (payload instanceof PublishResponse) {
            maybeNode.get().state.handlePublishResponse(message.sourceNode, (PublishResponse)payload).ifPresent(ac -> this.broadcast(message.targetNode, ac));
        } else if (payload instanceof ApplyCommitRequest) {
            maybeNode.get().state.handleCommit((ApplyCommitRequest)payload);
        } else {
            throw new AssertionError((Object)"unknown message type");
        }
    }

    void runRandomly() {
        int iterations = 10000;
        long maxTerm = 4L;
        long nextTerm = 1L;
        for (int i = 0; i < 10000; ++i) {
            try {
                if (RandomizedTest.rarely() && nextTerm < 4L) {
                    long l;
                    if (RandomizedTest.rarely()) {
                        l = ESTestCase.randomLongBetween(0L, 5L);
                    } else {
                        long l2 = nextTerm;
                        l = l2;
                        nextTerm = l2 + 1L;
                    }
                    long term = l;
                    StartJoinRequest startJoinRequest = new StartJoinRequest(ESTestCase.randomFrom(this.clusterNodes).localNode, term);
                    this.broadcast(startJoinRequest.getSourceNode(), startJoinRequest);
                } else if (RandomizedTest.rarely()) {
                    ESTestCase.randomFrom(this.clusterNodes).setInitialState(this.initialConfiguration, this.initialValue);
                } else if (RandomizedTest.rarely() && RandomizedTest.rarely()) {
                    ESTestCase.randomFrom(this.clusterNodes).reboot();
                } else if (RandomizedTest.rarely()) {
                    List masterNodes = this.clusterNodes.stream().filter(cn -> cn.state.electionWon()).collect(Collectors.toList());
                    if (!masterNodes.isEmpty()) {
                        ClusterNode clusterNode = (ClusterNode)ESTestCase.randomFrom(masterNodes);
                        long term = RandomizedTest.rarely() ? ESTestCase.randomLongBetween(0L, 5L) : clusterNode.state.getCurrentTerm();
                        long version = RandomizedTest.rarely() ? (long)ESTestCase.randomIntBetween(0, 5) : clusterNode.state.getLastPublishedVersion() + 1L;
                        CoordinationMetaData.VotingConfiguration acceptedConfig = RandomizedTest.rarely() ? this.randomVotingConfig() : clusterNode.state.getLastAcceptedConfiguration();
                        PublishRequest publishRequest = clusterNode.state.handleClientValue(CoordinationStateTestCluster.clusterState(term, version, clusterNode.localNode, clusterNode.state.getLastCommittedConfiguration(), acceptedConfig, ESTestCase.randomLong()));
                        this.broadcast(clusterNode.localNode, publishRequest);
                    }
                } else if (!this.messages.isEmpty()) {
                    this.applyMessage(ESTestCase.randomFrom(this.messages));
                }
                this.clusterNodes.forEach(cn -> cn.state.invariant());
                continue;
            }
            catch (CoordinationStateRejectedException coordinationStateRejectedException) {
                // empty catch block
            }
        }
        this.invariant();
    }

    void invariant() {
        this.messages.stream().filter(m -> m.payload instanceof PublishRequest).collect(Collectors.groupingBy(m -> ((PublishRequest)m.payload).getAcceptedState().term())).forEach((term, publishMessages) -> {
            Set<DiscoveryNode> mastersForTerm = publishMessages.stream().collect(Collectors.groupingBy(m -> m.sourceNode)).keySet();
            Assert.assertThat((String)("Multiple masters " + mastersForTerm + " for term " + term), mastersForTerm, (Matcher)Matchers.hasSize((int)1));
        });
        this.messages.stream().filter(m -> m.payload instanceof PublishRequest).map(m -> ((PublishRequest)m.payload).getAcceptedState()).collect(Collectors.groupingBy(ClusterState::term)).forEach((term, clusterStates) -> clusterStates.stream().collect(Collectors.groupingBy(ClusterState::version)).forEach((version, clusterStates1) -> {
            Set<String> clusterStateUUIDsForTermAndVersion = clusterStates1.stream().collect(Collectors.groupingBy(ClusterState::stateUUID)).keySet();
            Assert.assertThat((String)("Multiple cluster states " + clusterStates1 + " for term " + term + " and version " + version), clusterStateUUIDsForTermAndVersion, (Matcher)Matchers.hasSize((int)1));
            Set<Long> clusterStateValuesForTermAndVersion = clusterStates1.stream().collect(Collectors.groupingBy(CoordinationStateTestCluster::value)).keySet();
            Assert.assertThat((String)("Multiple cluster states " + clusterStates1 + " for term " + term + " and version " + version), clusterStateValuesForTermAndVersion, (Matcher)Matchers.hasSize((int)1));
        }));
    }

    static class Message {
        final DiscoveryNode sourceNode;
        final DiscoveryNode targetNode;
        final Object payload;

        Message(DiscoveryNode sourceNode, DiscoveryNode targetNode, Object payload) {
            this.sourceNode = sourceNode;
            this.targetNode = targetNode;
            this.payload = payload;
        }
    }

    static class ClusterNode {
        private final ElectionStrategy electionStrategy;
        DiscoveryNode localNode;
        CoordinationState.PersistedState persistedState;
        CoordinationState state;

        ClusterNode(DiscoveryNode localNode, ElectionStrategy electionStrategy) {
            this.localNode = localNode;
            this.persistedState = new InMemoryPersistedState(0L, CoordinationStateTestCluster.clusterState(0L, 0L, localNode, CoordinationMetaData.VotingConfiguration.EMPTY_CONFIG, CoordinationMetaData.VotingConfiguration.EMPTY_CONFIG, 0L));
            this.electionStrategy = electionStrategy;
            this.state = new CoordinationState(localNode, this.persistedState, electionStrategy);
        }

        void reboot() {
            if (!this.localNode.isMasterNode() && RandomizedTest.rarely()) {
                CoordinationMetaData.VotingConfiguration votingConfiguration = this.persistedState.getLastAcceptedState().getLastAcceptedConfiguration().isEmpty() ? CoordinationMetaData.VotingConfiguration.EMPTY_CONFIG : CoordinationMetaData.VotingConfiguration.MUST_JOIN_ELECTED_MASTER;
                this.persistedState = new InMemoryPersistedState(0L, CoordinationStateTestCluster.clusterState(0L, 0L, this.localNode, votingConfiguration, votingConfiguration, 0L));
            }
            HashSet<DiscoveryNodeRole> roles = new HashSet<DiscoveryNodeRole>(this.localNode.getRoles());
            if (ESTestCase.randomBoolean()) {
                if (roles.contains(DiscoveryNodeRole.MASTER_ROLE)) {
                    roles.remove(DiscoveryNodeRole.MASTER_ROLE);
                } else {
                    roles.add(DiscoveryNodeRole.MASTER_ROLE);
                }
            }
            this.localNode = new DiscoveryNode(this.localNode.getName(), this.localNode.getId(), UUIDs.randomBase64UUID((Random)LuceneTestCase.random()), this.localNode.getHostName(), this.localNode.getHostAddress(), this.localNode.getAddress(), this.localNode.getAttributes(), roles, this.localNode.getVersion());
            this.state = new CoordinationState(this.localNode, this.persistedState, this.electionStrategy);
        }

        void setInitialState(CoordinationMetaData.VotingConfiguration initialConfig, long initialValue) {
            ClusterState.Builder builder = ClusterState.builder((ClusterState)this.state.getLastAcceptedState());
            builder.metaData(MetaData.builder().coordinationMetaData(CoordinationMetaData.builder().lastAcceptedConfiguration(initialConfig).lastCommittedConfiguration(initialConfig).build()));
            this.state.setInitialState(CoordinationStateTestCluster.setValue(builder.build(), initialValue));
        }
    }
}

